/*
 * Decompiled with CFR 0.152.
 */
package com.objects;

import com.iceberg.graphics3d.Fps;
import com.iceberg.math.MathUtils;
import com.iceberg.math.Matrix;

public class Camera {
    public Matrix tmpPos = new Matrix();
    private Matrix tmp = new Matrix();
    private Matrix camera = new Matrix();
    public int angle = -8;
    public int y = 1400;
    public int x = 500;
    public int z = 1000;

    public void set(Matrix matrix) {
        this.interpolation(this.tmpPos, matrix);
        this.camera.set(this.tmpPos);
        this.camera.translate(this.x, this.y, this.z);
        this.tmp.setRotX(this.angle);
        this.camera.mul(this.tmp);
    }

    public void set2(Matrix matrix) {
        this.camera.set(matrix);
        this.tmpPos.set(matrix);
        this.camera.translate(this.x, this.y, this.z);
        this.tmp.setRotX(this.angle);
        this.camera.mul(this.tmp);
    }

    private void interpolation(Matrix matrix, Matrix matrix2) {
        int n = Fps.getFps2();
        float f = 8.0f * (float)n / 400.0f;
        matrix.m00 += (int)((float)(matrix2.m00 - matrix.m00) / f);
        matrix.m01 += (int)((float)(matrix2.m01 - matrix.m01) / f);
        matrix.m02 += (int)((float)(matrix2.m02 - matrix.m02) / f);
        matrix.m10 += (int)((float)(matrix2.m10 - matrix.m10) / f);
        matrix.m11 += (int)((float)(matrix2.m11 - matrix.m11) / f);
        matrix.m12 += (int)((float)(matrix2.m12 - matrix.m12) / f);
        matrix.m20 += (int)((float)(matrix2.m20 - matrix.m20) / f);
        matrix.m21 += (int)((float)(matrix2.m21 - matrix.m21) / f);
        matrix.m22 += (int)((float)(matrix2.m22 - matrix.m22) / f);
        matrix.m03 = matrix2.m03;
        matrix.m13 = matrix2.m13;
        matrix.m23 = matrix2.m23;
        float f2 = this.invLength(matrix.m00, matrix.m01, matrix.m02) * 16384.0f;
        matrix.m00 = (int)((float)matrix.m00 * f2);
        matrix.m01 = (int)((float)matrix.m01 * f2);
        matrix.m02 = (int)((float)matrix.m02 * f2);
        f2 = this.invLength(matrix.m10, matrix.m11, matrix.m12) * 16384.0f;
        matrix.m10 = (int)((float)matrix.m10 * f2);
        matrix.m11 = (int)((float)matrix.m11 * f2);
        matrix.m12 = (int)((float)matrix.m12 * f2);
        f2 = this.invLength(matrix.m20, matrix.m21, matrix.m22) * 16384.0f;
        matrix.m20 = (int)((float)matrix.m20 * f2);
        matrix.m21 = (int)((float)matrix.m21 * f2);
        matrix.m22 = (int)((float)matrix.m22 * f2);
    }

    private float invLength(int n, int n2, int n3) {
        return MathUtils.invSqrt(n * n + n2 * n2 + n3 * n3);
    }

    public void addAngle(int n) {
        this.angle += n;
    }

    public void addY(int n) {
        this.y += n;
    }

    public void addZ(int n) {
        this.z += n;
    }

    public void addX(int n) {
        this.x += n;
    }

    public Matrix getCamera() {
        return this.camera;
    }
}

