    device zxspectrum128
    org 0xBF80
    
start
    di
    
    ; set im2 and our handler
    
    ld      a, #18    
    ld      (#FFFF), a     ; jr    0xFFF4
    ld      a, #C3
    ld      (#FFF4), a
    ld      hl, isr
    ld      (#FFF5), hl
    
    ld      hl, #FD00
    ld      de, #FD01
    
    ld      a, h
    ld      i, a
    im      2
    
    ld      b, 2            ; 52 bytes - nevermind
    add     b               ; a = 0xFF
    ld      (hl), a
    ldir
    
    ld      ix, #5800
    
    xor     a
    ld      r, a
    inc     a
    ld      h, a
    ld      d, #15
    exx
    ld      l, a
    ld      h, a
    dec     a
    ld      b, a
    ld      c, a
    ld      d, #13
    
    ei
    
    ; bc - downcounter, d - flag, hl - counter val
loop
    ; 1st chan
ch1_dn
    dec     bc
    
    ld      a, b
    or      c
    jr      nz, ch2_dn
    
    ; reset counter
    ld      a, d
    xor     #13
    ld      d, a
    ld      bc, hl
    
    ; 2nd chan
ch2_dn
    exx
    dec     bc
    
    ld      a, b
    or      c
    jr      nz, chout
    
    ; reset counter
    ld      a, d
    xor     #15
    ld      d, a
    ld      bc, hl
    
    ; out
chout
    ld      a, d
    exx
    xor     d
    out     (#FE), a
        
    jr      loop
    
    ; interrupt handler
isr
    ld      a, #30
delay   equ $-1
    dec     a
    ld      (delay), a
    jr      nz, phuk
    
    ld      a, r
    and     #1F
    inc     a
    ld      (delay), a
    
    ld      [ix+0], c
    inc     ix
    
    ld      a, (hl)
    and     0x03
    ld      l, a
    ld      a, (bc)
    and     0x1
    inc     a
    ld      h, a
    exx
    ld      a, (hl)
    and     0x03
    inc     a
    ld      l, a
    ld      a, (bc)
    and     0x1
    inc     a
    ld      h, a
    exx
phuk
    ei
    ret
    
end

    savebin "petr.bin", start, (end-start)
    savehob "petr.$c", "petr.C", start, (end-start)
    savesna "petr.sna", start