﻿using System;
using UnityEngine;

namespace Steer2D
{
    public class Seek : SteeringBehaviour
    {
        public Vector2 TargetPoint = Vector2.zero;

        public override Vector2 GetVelocity()
        {
            GameObject target = GameObject.FindWithTag("Player");

            if (target != null)
                TargetPoint = (Vector2)target.transform.position;
            
            return ((TargetPoint - (Vector2)transform.position).normalized * agent.MaxVelocity) - agent.CurrentVelocity;   
        }
    }
}
