/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Line;
import org.tritonus.share.TDebug;

public interface Port
extends Line {

    public static class Info
    extends Line.Info {
        public static final Info MICROPHONE = new Info(Info.getPortClass(), "MICROPHONE", true);
        public static final Info LINE_IN = new Info(Info.getPortClass(), "LINE_IN", true);
        public static final Info COMPACT_DISC = new Info(Info.getPortClass(), "COMPACT_DISC", true);
        public static final Info SPEAKER = new Info(Info.getPortClass(), "SPEAKER", false);
        public static final Info HEADPHONE = new Info(Info.getPortClass(), "HEADPHONE", false);
        public static final Info LINE_OUT = new Info(Info.getPortClass(), "LINE_OUT", false);
        private String m_strName;
        private boolean m_bIsSource;

        public static Class getPortClass() {
            try {
                return Class.forName("javax.sound.sampled.Port");
            }
            catch (ClassNotFoundException e) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(e);
                }
                return null;
            }
        }

        public Info(Class lineClass, String strName, boolean bIsSource) {
            super(lineClass);
            this.m_strName = strName;
            this.m_bIsSource = bIsSource;
        }

        public String getName() {
            return this.m_strName;
        }

        public boolean isSource() {
            return this.m_bIsSource;
        }

        public boolean matches(Line.Info info) {
            return super.matches(info) && this.getName().equals(((Info)info).getName()) && this.isSource() == ((Info)info).isSource();
        }

        public final boolean equals(Object obj) {
            return super.equals(obj);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return super.toString() + "[name=" + this.getName() + ", source = " + this.isSource() + "]";
        }
    }
}

