/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled.spi;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.TDebug;

public abstract class FormatConversionProvider {
    public abstract AudioFormat.Encoding[] getSourceEncodings();

    public abstract AudioFormat.Encoding[] getTargetEncodings();

    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        Object[] aSourceEncodings = this.getSourceEncodings();
        return FormatConversionProvider.arrayContains(aSourceEncodings, sourceEncoding);
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        Object[] aTargetEncodings = this.getTargetEncodings();
        return FormatConversionProvider.arrayContains(aTargetEncodings, targetEncoding);
    }

    public abstract AudioFormat.Encoding[] getTargetEncodings(AudioFormat var1);

    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">FormatConversionProvider.isConversionSupported(AudioFormat.Encoding, AudioFormat):");
            TDebug.out("class: " + this.getClass().getName());
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to: " + targetEncoding);
        }
        Object[] aTargetEncodings = this.getTargetEncodings(sourceFormat);
        boolean res = FormatConversionProvider.arrayContains(aTargetEncodings, targetEncoding);
        if (TDebug.TraceAudioConverter) {
            TDebug.out("< result=" + res);
        }
        return res;
    }

    public abstract AudioFormat[] getTargetFormats(AudioFormat.Encoding var1, AudioFormat var2);

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">FormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("class: " + this.getClass().getName());
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + sourceFormat);
            TDebug.out("to: " + targetFormat);
        }
        AudioFormat[] aTargetFormats = this.getTargetFormats(targetFormat.getEncoding(), sourceFormat);
        for (int i = 0; i < aTargetFormats.length; ++i) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("checking against possible target format: " + aTargetFormats[i]);
            }
            if (aTargetFormats[i] == null || !aTargetFormats[i].matches(targetFormat)) continue;
            if (TDebug.TraceAudioConverter) {
                TDebug.out("<result=true");
            }
            return true;
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<result=false");
        }
        return false;
    }

    public abstract AudioInputStream getAudioInputStream(AudioFormat.Encoding var1, AudioInputStream var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat var1, AudioInputStream var2);

    private static boolean arrayContains(Object[] aArray, Object obj) {
        for (int i = 0; i < aArray.length; ++i) {
            if (aArray[i] == null || !aArray[i].equals(obj)) continue;
            return true;
        }
        return false;
    }
}

