/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioMetaData;
import ddf.minim.AudioSource;
import ddf.minim.Minim;
import ddf.minim.Playable;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioRecordingStream;

public class AudioPlayer
extends AudioSource
implements Playable {
    private AudioRecordingStream recording;
    private AudioOut output;
    private boolean isPaused;

    public AudioPlayer(AudioRecordingStream recording, AudioOut out) {
        super(out);
        this.recording = recording;
        this.output = out;
        this.output.setAudioStream(recording);
    }

    public void play() {
        this.recording.play();
        this.isPaused = false;
    }

    public void play(int millis) {
        this.cue(millis);
        this.play();
    }

    public void pause() {
        this.recording.pause();
        this.isPaused = true;
    }

    public void rewind() {
        this.cue(0);
    }

    public void loop(int num) {
        if (this.isPaused) {
            int pos = this.recording.getMillisecondPosition();
            this.recording.loop(num);
            this.recording.setMillisecondPosition(pos);
        } else {
            this.recording.loop(num);
        }
        this.isPaused = false;
    }

    public void loop() {
        this.loop(-1);
    }

    public int loopCount() {
        return this.recording.getLoopCount();
    }

    public int length() {
        return this.recording.getMillisecondLength();
    }

    public int position() {
        return this.recording.getMillisecondPosition();
    }

    public void cue(int millis) {
        if (millis < 0) {
            millis = 0;
        } else if (millis > this.length()) {
            millis = this.length();
        }
        this.recording.setMillisecondPosition(millis);
    }

    public void skip(int millis) {
        int pos = this.position() + millis;
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.length()) {
            pos = this.length();
        }
        Minim.debug("AudioPlayer.skip: skipping " + millis + " milliseconds, new position is " + pos);
        this.recording.setMillisecondPosition(pos);
    }

    public boolean isLooping() {
        return this.recording.getLoopCount() != 0;
    }

    public boolean isPlaying() {
        return this.recording.isPlaying();
    }

    public AudioMetaData getMetaData() {
        return this.recording.getMetaData();
    }

    public void setLoopPoints(int start, int stop) {
        this.recording.setLoopPoints(start, stop);
    }

    public void close() {
        this.recording.close();
        super.close();
    }
}

