/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.effects.IIRFilter;

public class BandPass
extends IIRFilter {
    private float bw;

    public BandPass(float freq, float bandWidth, float sampleRate) {
        super(freq, sampleRate);
        this.setBandWidth(bandWidth);
    }

    public synchronized void setBandWidth(float bandWidth) {
        this.bw = bandWidth / this.sampleRate();
        this.calcCoeff();
    }

    public float getBandWidth() {
        return this.bw * this.sampleRate();
    }

    protected void calcCoeff() {
        float R = 1.0f - 3.0f * this.bw;
        float fracFreq = this.frequency() / this.sampleRate();
        float T = 2.0f * (float)Math.cos(Math.PI * 2 * (double)fracFreq);
        float K = (1.0f - R * T + R * R) / (2.0f - T);
        this.a = new float[]{1.0f - K, (K - R) * T, R * R - K};
        this.b = new float[]{R * T, -R * R};
    }
}

