/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.javasound.FloatSampleBuffer;

class SampleSignal
implements AudioSignal {
    private FloatSampleBuffer buffer;
    private int[] marks;
    private int markAt;

    public SampleSignal(FloatSampleBuffer samps) {
        this.buffer = samps;
        this.marks = new int[20];
        for (int i = 0; i < this.marks.length; ++i) {
            this.marks[i] = -1;
        }
        this.markAt = 0;
    }

    public void generate(float[] signal) {
        for (int i = 0; i < this.marks.length; ++i) {
            int j;
            int begin = this.marks[i];
            if (begin == -1) continue;
            int k = 0;
            for (j = begin; j < this.buffer.getSampleCount() && k < signal.length; ++j) {
                int n = k++;
                signal[n] = signal[n] + this.buffer.getChannel(0)[j];
            }
            this.marks[i] = j < this.buffer.getSampleCount() ? j : -1;
        }
    }

    public void generate(float[] left, float[] right) {
        for (int i = 0; i < this.marks.length; ++i) {
            int j;
            int begin = this.marks[i];
            if (begin == -1) continue;
            int k = 0;
            for (j = begin; j < this.buffer.getSampleCount() && k < left.length; ++j) {
                int n = k;
                left[n] = left[n] + this.buffer.getChannel(0)[j];
                int n2 = k++;
                right[n2] = right[n2] + this.buffer.getChannel(1)[j];
            }
            this.marks[i] = j < this.buffer.getSampleCount() ? j : -1;
        }
    }

    public void trigger() {
        this.marks[this.markAt] = 0;
        ++this.markAt;
        if (this.markAt == this.marks.length) {
            this.markAt = 0;
        }
    }

    public void stop() {
        for (int i = 0; i < this.marks.length; ++i) {
            this.marks[i] = -1;
        }
    }

    public float[] getChannel(int channelNumber) {
        if (channelNumber == 1) {
            return this.buffer.getChannel(0);
        }
        if (channelNumber == 2) {
            return this.buffer.getChannel(1);
        }
        Minim.error("getChannel: Illegal channel number " + channelNumber);
        return null;
    }
}

