/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.tests;

import ddf.minim.Minim;
import ddf.minim.spi.AudioRecordingStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Paths;

public class AudioRecordingStreamLoop {
    String fileFolder;
    Minim minim;

    public static void main(String[] args) {
        AudioRecordingStreamLoop test = new AudioRecordingStreamLoop();
        test.Start(args);
    }

    void Start(String[] args) {
        long reads;
        this.fileFolder = args[0];
        this.minim = new Minim(this);
        AudioRecordingStream recording = this.minim.loadFileStream(args[1]);
        int loopCount = 1;
        long expectedReads = recording.getSampleFrameLength() * (long)(loopCount + 1);
        recording.loop(loopCount);
        for (reads = 0L; recording.isPlaying() && reads < expectedReads; ++reads) {
            if (reads == 743041L) {
                System.out.println("..");
            }
            recording.read();
            if (recording.getLoopCount() != -1) continue;
            System.err.println("Loop count became -1 after " + reads + " reads!");
            break;
        }
        if (expectedReads != reads) {
            System.err.println("Expected " + expectedReads + " reads, and made " + reads);
        } else if (recording.isPlaying()) {
            System.err.println("Recording is still playing after expected number of read.");
        }
    }

    public String sketchPath(String fileName) {
        return Paths.get(this.fileFolder, fileName).toString();
    }

    public InputStream createInput(String fileName) {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(this.sketchPath(fileName));
        }
        catch (FileNotFoundException ex) {
            System.err.println("Unable to find file " + fileName);
        }
        return stream;
    }
}

