/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioMetaData;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.Playable;
import ddf.minim.UGen;
import ddf.minim.spi.AudioRecordingStream;
import java.util.Arrays;

public class FilePlayer
extends UGen
implements Playable {
    private AudioRecordingStream mFileStream;
    private boolean isPaused;
    private MultiChannelBuffer buffer;
    private int bufferOutIndex;

    public FilePlayer(AudioRecordingStream iFileStream) {
        this.mFileStream = iFileStream;
        this.buffer = new MultiChannelBuffer(1024, this.mFileStream.getFormat().getChannels());
        this.bufferOutIndex = 0;
    }

    public AudioRecordingStream getStream() {
        return this.mFileStream;
    }

    public void play() {
        this.mFileStream.play();
        this.isPaused = false;
    }

    public void play(int millis) {
        this.cue(millis);
        this.play();
    }

    public void pause() {
        this.mFileStream.pause();
        this.isPaused = true;
    }

    public void rewind() {
        this.cue(0);
    }

    public void loop() {
        this.loop(-1);
    }

    public void loop(int loopCount) {
        if (this.isPaused) {
            int pos = this.mFileStream.getMillisecondPosition();
            this.mFileStream.loop(loopCount);
            this.cue(pos);
        } else {
            this.mFileStream.loop(loopCount);
        }
        this.isPaused = false;
    }

    public int loopCount() {
        return this.mFileStream.getLoopCount();
    }

    public int length() {
        return this.mFileStream.getMillisecondLength();
    }

    public int position() {
        return this.mFileStream.getMillisecondPosition();
    }

    public void cue(int millis) {
        if (millis < 0) {
            millis = 0;
        } else if (millis > this.length()) {
            millis = this.length();
        }
        this.mFileStream.setMillisecondPosition(millis);
        this.fillBuffer();
    }

    public void skip(int millis) {
        int pos = this.position() + millis;
        if (pos < 0) {
            pos = 0;
        } else if (pos > this.length()) {
            pos = this.length();
        }
        this.cue(pos);
    }

    public boolean isLooping() {
        return this.mFileStream.getLoopCount() != 0;
    }

    public boolean isPlaying() {
        return this.mFileStream.isPlaying();
    }

    public AudioMetaData getMetaData() {
        return this.mFileStream.getMetaData();
    }

    public void setLoopPoints(int start, int stop) {
        this.mFileStream.setLoopPoints(start, stop);
    }

    public void close() {
        this.mFileStream.close();
    }

    private void fillBuffer() {
        this.mFileStream.read(this.buffer);
        this.bufferOutIndex = 0;
    }

    protected void uGenerate(float[] channels) {
        if (this.mFileStream.isPlaying()) {
            if (this.buffer.getChannelCount() == 1) {
                Arrays.fill(channels, this.buffer.getSample(0, this.bufferOutIndex));
            }
            if (this.buffer.getChannelCount() <= channels.length) {
                for (int i = 0; i < channels.length; ++i) {
                    channels[i] = this.buffer.getSample(i, this.bufferOutIndex);
                }
            } else if (channels.length == 1 && this.buffer.getChannelCount() == 2) {
                channels[0] = (this.buffer.getSample(0, this.bufferOutIndex) + this.buffer.getSample(1, this.bufferOutIndex)) / 2.0f;
            }
            ++this.bufferOutIndex;
            if (this.bufferOutIndex == this.buffer.getBufferSize()) {
                this.fillBuffer();
            }
        } else {
            Arrays.fill(channels, 0.0f);
        }
    }
}

