/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.UGen;
import java.util.Arrays;

public class Sampler
extends UGen {
    public UGen.UGenInput begin;
    public UGen.UGenInput end;
    public UGen.UGenInput attack;
    public UGen.UGenInput amplitude;
    public UGen.UGenInput rate;
    public boolean looping;
    private MultiChannelBuffer sampleData;
    private float sampleDataSampleRate;
    private float basePlaybackRate;
    private Trigger[] triggers;
    private int nextTrigger;

    public Sampler(String filename, int maxVoices, Minim system) {
        this.triggers = new Trigger[maxVoices];
        for (int i = 0; i < maxVoices; ++i) {
            this.triggers[i] = new Trigger();
        }
        this.sampleData = new MultiChannelBuffer(1, 1);
        this.sampleDataSampleRate = system.loadFileIntoBuffer(filename, this.sampleData);
        this.createInputs();
    }

    public Sampler(MultiChannelBuffer sampleData, float sampleRate, int maxVoices) {
        this.triggers = new Trigger[maxVoices];
        for (int i = 0; i < maxVoices; ++i) {
            this.triggers[i] = new Trigger();
        }
        this.sampleData = new MultiChannelBuffer(sampleData.getChannelCount(), sampleData.getBufferSize());
        this.sampleData.set(sampleData);
        this.sampleDataSampleRate = sampleRate;
        this.createInputs();
    }

    private void createInputs() {
        this.begin = this.addControl(0.0f);
        this.end = this.addControl(this.sampleData.getBufferSize() - 1);
        this.attack = this.addControl();
        this.amplitude = this.addControl(1.0f);
        this.rate = this.addControl(1.0f);
    }

    public void trigger() {
        this.triggers[this.nextTrigger].activate();
        this.nextTrigger = (this.nextTrigger + 1) % this.triggers.length;
    }

    public void stop() {
        for (Trigger t : this.triggers) {
            t.stop();
        }
    }

    public void setSample(MultiChannelBuffer newSampleData, float sampleRate) {
        this.sampleData.set(newSampleData);
        this.sampleDataSampleRate = sampleRate;
        this.basePlaybackRate = sampleRate / this.sampleRate();
    }

    protected void sampleRateChanged() {
        this.basePlaybackRate = this.sampleDataSampleRate / this.sampleRate();
    }

    protected void uGenerate(float[] channels) {
        Arrays.fill(channels, 0.0f);
        for (Trigger t : this.triggers) {
            t.generate(channels);
        }
    }

    private class Trigger {
        float beginSample;
        float endSample;
        float playbackRate;
        float sample;
        float outSampleCount;
        int attackLength;
        float attackAmp;
        float attackAmpStep;
        int release;
        boolean done = true;
        boolean triggering;

        Trigger() {
        }

        void activate() {
            this.triggering = true;
        }

        void stop() {
            this.done = true;
        }

        void generate(float[] sampleFrame) {
            if (this.triggering) {
                this.beginSample = (int)Math.min(Sampler.this.begin.getLastValue(), (float)(Sampler.this.sampleData.getBufferSize() - 2));
                this.endSample = (int)Math.min(Sampler.this.end.getLastValue(), (float)(Sampler.this.sampleData.getBufferSize() - 1));
                this.playbackRate = Sampler.this.rate.getLastValue();
                this.attackLength = (int)Math.max(Sampler.this.sampleRate() * Sampler.this.attack.getLastValue(), 1.0f);
                this.attackAmp = 0.0f;
                this.attackAmpStep = 1.0f / (float)this.attackLength;
                this.release = 0;
                this.sample = this.beginSample;
                this.outSampleCount = 0.0f;
                this.done = false;
                this.triggering = false;
            }
            if (this.done) {
                return;
            }
            float outAmp = Sampler.this.amplitude.getLastValue() * this.attackAmp;
            int c = 0;
            while (c < sampleFrame.length) {
                int sourceChannel = c < Sampler.this.sampleData.getChannelCount() ? c : Sampler.this.sampleData.getChannelCount() - 1;
                int n = c++;
                sampleFrame[n] = sampleFrame[n] + outAmp * Sampler.this.sampleData.getSample(sourceChannel, this.sample);
            }
            this.sample += this.playbackRate * Sampler.this.basePlaybackRate;
            if (this.sample > this.endSample) {
                if (Sampler.this.looping) {
                    this.sample -= this.endSample - this.beginSample;
                } else {
                    this.done = true;
                }
            }
            this.outSampleCount += 1.0f;
            if (this.outSampleCount <= (float)this.attackLength) {
                this.attackAmp += this.attackAmpStep;
            }
        }
    }
}

