package com.github.bjakke;

import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.event.KeyEvent;
import processing.opengl.PJOGL;

public class Main extends PApplet{
	//private static final int[] SCENE_SIZE = new int[]{640, 480};
	private static final int[] SCENE_SIZE = new int[]{640, 360};

	//private static final int[] SCENE_SIZE = new int[]{320, 240};
	//private static final int[] SCENE_SIZE = new int[]{160, 120};
	
	private static final boolean FULL_SCREEN = true;
	private static final String FILE_NAME = "music.wav";
	private static final int BPM = 140;
	private static final int RPB = 8;
	
	public static int screen = 0;
	
	public static void main(String[] args) {
		//the first arg if given decides the screen where the demo is shown
		//(if computer has multiple), needs fullscreen mode
		if(args != null && args.length > 0){
			screen = Integer.parseInt(args[0]);
		}
		PApplet.main("com.github.bjakke.Main");
	}
	private Moonlander ml;
	
	private Shader st2;

	private PGraphics pg;
	
	@Override
	public void draw() {
		frameRate(60);
		// do not draw cursor
		noCursor();
		
		ml.update();
		
		//"scene", which state we are in
		int scene = ml.getIntValue("scene");
		System.out.println("Scene: "+scene);	
		
		
		// end of entry
		if(scene > 99){
			System.out.println("END");
			exit();
		}
		
		//end credits
		if(scene > 10 ){
			System.out.println("Credits");
			//end, show blank (+exit in finished ver)
			background(0);
			
			textSize(36);
			text("\"Keep on Isle\"",100, 50);
			
			textSize(24);
			text("Code & Graphics & Music:", 100, 100);
			textSize(16);
			text("BJAKKE", 100, 150);
			
			//return here, as this is last screen, do not draw anything after this..
			return;
		}

		/*
		 * NORMAL draw begins here
		 */
		pg.beginDraw();
		//rotate transformation
				
		int bgcolor = ml.getIntValue("bgcolor");
		
		pg.background(bgcolor); 
		//float seconds = millis() /1000.0f;
		float seconds = (float) ml.getCurrentTime();
		System.out.println("FPS: "+frameRate + ", time: "+seconds);
		st2.draw(seconds);
		pg.endDraw();
		
		//post processing, wont work
		//pp.draw(pg);
		
		//show offscreen image
		image(pg, 0, 0);		
	}
	
	@Override
	public void keyPressed(KeyEvent event) {
		//if(event.getKeyCode() == )
	}

	@Override
	public void settings() {
		if(FULL_SCREEN){
			fullScreen(P3D, screen);
		}else{
			size(SCENE_SIZE[0], SCENE_SIZE[1], P3D);
		}
		
		PJOGL.profile = 3;
	} 
	
	@Override
	public void setup() {				
		//test offscreen drawing
		pg = createGraphics(width, height, P3D);
		
		ml = Moonlander.initWithSoundtrack(this, FILE_NAME, BPM, RPB);
		
		st2 = new Shader(this, pg, "shaders/frag.glsl", ml);
		
		ml.start("localhost", 1338, "syncdata.rocket");
	}

	
}
