#version 410

#include "uniforms.glsl"
#include "hg_sdf.glsl"
#include "material.glsl"
#include "math.glsl"
#include "noise.glsl"

// Textures
uniform sampler2D uFbmSampler;

// Lights
const int NUM_LIGHTS = 1;
vec3      LIGHT_POS[NUM_LIGHTS] = vec3[](vec3(0));
vec3      LIGHT_INT[NUM_LIGHTS] = vec3[](vec3(0));

// Object variables
uniform float uObjScale;
uniform float uObjPosX;
uniform float uObjPosY;
uniform float uObjPosZ;

SceneResult scene(vec3 p)
{
    vec3 pObject = p - vec3(uObjPosX, uObjPosY, uObjPosZ);
    pR(pObject.yz, -uGT);
    pR(pObject.xz, -uGT);
    vec3 pEdges = pObject;
    float eScale = uObjScale * 0.91;
    float fEdge1 = fBox(pEdges, vec3(eScale + 0.05, eScale, eScale));
    pR(pEdges.xz, PI * 0.5);
    float fEdge2 = fBox(pEdges, vec3(eScale + 0.05, eScale, eScale));
    pR(pEdges.yx, PI * 0.5);
    float fEdge3 = fBox(pEdges, vec3(eScale + 0.05, eScale, eScale));
    SceneResult edges = SceneResult(min(min(fEdge1, fEdge2), fEdge3), 1);
    SceneResult box = SceneResult(fBox(pObject, vec3(uObjScale)), 0);
    SceneResult object = opU(box, edges);
    vec3 pGridZ = p;
    pR(pGridZ.yx, PI * 0.5);
    pModInterval1(pGridZ.z, 2, -1, 2);
    float gridZ = fCylinder(pGridZ, 0.02, 1.5);
    vec3 pGridX = p - vec3(0, 0, 1);
    pR(pGridX.yz, PI * 0.5);
    pModInterval1(pGridX.x, 0.5, -3, 3);
    float gridX = fCylinder(pGridX, 0.02, 3);
    SceneResult grid = SceneResult(min(gridX, gridZ), 0);
    return opU(object, grid);
}

Material evalMaterial(vec3 p, float matI)
{
    Material mat;
    if (matI < 1) {
        mat = mWhiteLight;
    } else {
        mat = mWhiteLight;
        mat.emissivity = vec3(0);
    }
    return mat;
}

// Main sphere tracing -stuff
#include "sphere_tracing_end.glsl"
