#ifndef KEKO_CAMERA_H_
#define KEKO_CAMERA_H_

#include "math_3d.h"

struct Camera
{
	float fov;
	float horizontalAngle;
	float verticalAngle;
	float nearPlane;
	float farPlane;
	float viewportAspectRatio;

	vec3_t position;

	vec3_t forward;

	mat4_t cameraOrientation;
	mat4_t cameraMatrix;
	mat4_t cameraView;
	mat4_t cameraProjection;
};

struct CameraKeyFrame
{
	vec3_t position;
	float horizontalAngle;
	float verticalAngle;
	int demoTime;
};

struct Camera SetCamera();
void SetCameraPosition(struct Camera *camera, vec3_t newPosition);
void SetCameraViewportAspectRatio(struct Camera *camera, float newAspectRatio);
void OffsetCameraPosition(struct Camera *camera, vec3_t offset);
vec3_t GetCameraForwardVector(struct Camera *camera);
vec3_t GetCameraRightVector(struct Camera *camera);
vec3_t GetCameraUpVector(struct Camera *camera);
mat4_t CameraOrientation(struct Camera *camera);
mat4_t CameraView(struct Camera *camera);
mat4_t CameraProjection(struct Camera *camera);
mat4_t CameraMatrix(struct Camera *camera);
void CameraNormalizeAngles(struct Camera *camera);

CameraKeyFrame NewCameraKeyFrame(vec3_t position, float horizontalAngle, float verticalAngle, int demoTime);

#endif