/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PVector;

public class try5
extends PApplet {
    PFont myFont;
    String[] message = new String[]{"Puddle of Infinity - Wind Marching For Rain", "Dewdrop Fantasy - Kevin MacLeod", "Ambient Ambulance - Jingle Punks", "Inner Sanctum - Kevin MacLeod", "Epic Unease - Kevin MacLeod"};
    int SIZE = 400;
    int col = 0;
    float j = 0.5f;
    Moonlander moonlander;
    double value = 0.0;
    ArrayList<Circle> drops;
    int WIDTH = 1920;
    int HEIGHT = 1080;
    float ZOOM = 1.0f;
    int N = 500 * (int)this.ZOOM;
    float RADIUS = this.HEIGHT / 30;
    float SPEED = 3.0E-5f;
    float FOCAL_LENGTH = 0.5f;
    float BLUR_AMOUNT = 50.0f;
    int MIN_BLUR_LEVELS = 1;
    int BLUR_LEVEL_COUNT = 4;
    float ZSTEP = 0.015f;
    int BACKGROUND = this.color(0, 30, 30);
    ArrayList objects;
    float r = 0.0f;
    boolean zoomIn = false;
    boolean zoomOut = true;
    float xoffs = 0.5f;
    float yoffs = 0.5f;
    int count = 0;
    int n = 0;
    float m = 0.0f;
    Ptc[] ptcs;
    ArrayList<PVector> alivePath = new ArrayList();
    int aliveIndex = 0;
    float gMag = 1.0f;
    float gVelMax = 10.0f;
    float gThres;
    float gThresT = 100.0f;
    float gBgAlpha = 255.0f;
    float gBgAlphaT = 32.0f;
    float sliderForce = 1.0f;
    float sliderGhost = 32.0f;
    float sliderThres = 100.0f;
    boolean aliveAnimate = true;
    final float g = 0.1f;
    ArrayList<PVector> deathPath = new ArrayList();
    int deathIndex = 0;
    Body[] bs;

    public void blurred_circle(float x, float y, float rad, float blur, int col, float levels) {
        float level_distance = this.BLUR_AMOUNT * blur / levels;
        float i = 0.0f;
        while (i < levels * 2.0f) {
            this.fill(col, 255.0f * (levels * 2.0f - i) / (levels * 2.0f));
            this.ellipse(x, y, rad + (i - levels) * level_distance, rad + (i - levels) * level_distance);
            i += 1.0f;
        }
    }

    public void sortBubbles() {
        float last = 0.0f;
        ArrayList temp = new ArrayList();
        int i = 0;
        while (i < this.N) {
            int index = 0;
            float lowest = 100.0f;
            int j = 0;
            while (j < this.N) {
                ZObject current = (ZObject)this.objects.get(j);
                if (current.z < lowest && current.z > last) {
                    index = j;
                    lowest = current.z;
                }
                ++j;
            }
            temp.add(this.objects.get(index));
            last = ((ZObject)this.objects.get((int)index)).z;
            ++i;
        }
        this.objects = temp;
    }

    public void setup() {
        this.frameRate(24.0f);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"yoyo.mp3", (int)120, (int)8);
        this.moonlander.start();
        this.noStroke();
        this.objects = new ArrayList();
        int i = 0;
        while (i < this.N) {
            this.objects.add(new ZObject(this.random(1.0f), this.random(1.0f), this.random(1.0f), this.color(this.random(20.0f, 20.0f), this.random(150.0f, 190.0f), this.random(150.0f, 190.0f))));
            ++i;
        }
        this.sortBubbles();
        this.drops = new ArrayList();
        this.setupAlive();
        this.setupDeath();
        this.font_setup();
    }

    public void draw() {
        if (this.value < 60.0) {
            this.m = try5.min((float)(this.m + 0.1f), (float)150.0f);
            this.n = (int)this.m;
        } else {
            this.n -= 10;
        }
        if (this.value >= 40.0) {
            this.BACKGROUND = this.color(0 + this.col++ / 3, 30 + this.col++ / 3, 30 + this.col++ / 3);
        }
        this.moonlander.update();
        this.value = this.moonlander.getValue("my_track");
        ++this.count;
        this.background(this.BACKGROUND);
        int i = 0;
        while (i < this.n) {
            ZObject current = (ZObject)this.objects.get(i);
            current.update(this.zoomIn, this.zoomOut);
            ++i;
        }
        if (this.value >= 60.0) {
            // empty if block
        }
        this.sortBubbles();
        if (this.value < 70.0 && this.value != 420.0) {
            i = 0;
            while (i < this.n) {
                ((ZObject)this.objects.get(i)).draw(this.xoffs, this.yoffs);
                ++i;
            }
        }
        i = 0;
        while (i < this.drops.size()) {
            Circle drop = this.drops.get(i);
            drop.display();
            drop.movement();
            ++i;
        }
        this.fill(255);
        this.strokeWeight(2.0f);
        this.textSize(16.0f);
        this.strokeWeight(0.5f);
        if (this.value != 420.0 && this.value == 70.0) {
            this.drawAlive();
        }
        if (this.value != 420.0 && this.value == 80.0) {
            this.drawAlive();
        }
        if (this.value != 420.0 && this.value == 90.0) {
            this.drawAlive();
        }
        if (this.value != 420.0 && this.value == 100.0) {
            this.strokeWeight(1.0f);
            this.fill(255, 25.5f);
            this.drawDeath();
        }
        if (this.value != 420.0 && this.value == 110.0) {
            this.drawDeath();
        }
        if (this.value != 420.0 && this.value == 120.0) {
            this.font_draw();
        }
    }

    public void setupAlive() {
        this.initPtcs(160);
        this.alivePath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.alivePath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.alivePath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.alivePath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.alivePath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.8f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.8f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.2f, (float)this.height * 0.2f));
        this.alivePath.add(new PVector((float)this.width * 0.0f, (float)this.height * 0.0f));
        this.alivePath.add(new PVector((float)this.width * 0.0f, (float)this.height * 0.0f));
        this.alivePath.add(new PVector((float)this.width * 0.0f, (float)this.height * 0.0f));
        this.alivePath.add(new PVector((float)this.width * 0.0f, (float)this.height * 0.0f));
        this.alivePath.add(new PVector((float)this.width * 0.0f, (float)this.height * 0.0f));
        this.alivePath.add(new PVector((float)this.width * 1.0f, (float)this.height * 1.0f));
        this.alivePath.add(new PVector((float)this.width * 1.0f, (float)this.height * 1.0f));
        this.alivePath.add(new PVector((float)this.width * 1.0f, (float)this.height * 1.0f));
        this.alivePath.add(new PVector((float)this.width * 1.0f, (float)this.height * 1.0f));
        this.alivePath.add(new PVector((float)this.width * 1.0f, (float)this.height * 1.0f));
    }

    public void drawAlive() {
        this.gThres = try5.lerp((float)this.gThres, (float)this.gThresT, (float)0.02f);
        this.gBgAlpha = try5.lerp((float)this.gBgAlpha, (float)this.gBgAlphaT, (float)0.02f);
        this.gMag = this.sliderForce;
        this.updatePtcs();
        this.noStroke();
        this.fill(255, this.gBgAlpha);
        this.rect(0.0f, 0.0f, this.width, this.height);
        this.drawPtcs();
        this.drawCnts();
    }

    public void initPtcs(int amt) {
        this.ptcs = new Ptc[amt];
        int i = 0;
        while (i < this.ptcs.length) {
            this.ptcs[i] = new Ptc();
            ++i;
        }
    }

    public void updatePtcs() {
        if (this.aliveAnimate) {
            int i = 0;
            while (i < this.ptcs.length) {
                this.ptcs[i].update(this.alivePath.get((int)this.aliveIndex).x, this.alivePath.get((int)this.aliveIndex).y);
                this.aliveIndex = this.aliveIndex + 1 == this.alivePath.size() ? 0 : ++this.aliveIndex;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.ptcs.length) {
                this.ptcs[i].update();
                ++i;
            }
        }
    }

    public void drawPtcs() {
        int i = 0;
        while (i < this.ptcs.length) {
            this.ptcs[i].drawPtc();
            ++i;
        }
    }

    public void drawCnts() {
        int i = 0;
        while (i < this.ptcs.length) {
            int j = i + 1;
            while (j < this.ptcs.length) {
                float d = try5.dist((float)this.ptcs[i].pos.x, (float)this.ptcs[i].pos.y, (float)this.ptcs[j].pos.x, (float)this.ptcs[j].pos.y);
                if (d < this.gThres) {
                    float scalar = try5.map((float)d, (float)0.0f, (float)this.gThres, (float)1.0f, (float)0.0f);
                    this.ptcs[i].drawCnt(this.ptcs[j], scalar);
                }
                ++j;
            }
            ++i;
        }
    }

    public void setupDeath() {
        this.background(255);
        this.fill(255, 26.0f);
        this.deathPath.add(new PVector((float)(this.width / 2 - 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 - 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 - 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 - 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 - 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 - 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 + 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 + 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 + 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 + 25), (float)(this.height / 2)));
        this.deathPath.add(new PVector((float)(this.width / 2 + 25), (float)(this.height / 2)));
        this.bs = new Body[1000];
        int i = 0;
        while (i < this.bs.length) {
            this.bs[i] = new Body(1.0f, new PVector(this.random(this.width), this.random(this.height)));
            ++i;
        }
    }

    public void drawDeath() {
        this.noStroke();
        this.rect(0.0f, 0.0f, this.width, this.height);
        this.stroke(0);
        Body a = new Body(1000.0f, this.deathPath.get(this.deathIndex));
        this.deathIndex = this.deathIndex + 1 == this.deathPath.size() ? 0 : ++this.deathIndex;
        Body[] bodyArray = this.bs;
        int n = this.bs.length;
        int n2 = 0;
        while (n2 < n) {
            Body b = bodyArray[n2];
            b.show();
            b.attract(a);
            b.update();
            ++n2;
        }
    }

    public void font_setup() {
        this.myFont = this.loadFont("CharterBT-Italic-200.vlw");
    }

    public void font_draw() {
        this.background(255);
        this.textFont(this.myFont, 100.0f);
        this.fill(0);
        this.text("CREDITS", 50.0f, 150.0f);
        int i = 0;
        while (i < this.message.length) {
            this.textFont(this.myFont, 50.0f);
            this.fill(0);
            this.text(this.message[i], 50.0f, 250 + i * 50);
            ++i;
        }
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics2D");
        this.smooth();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"try5"};
        if (passedArgs != null) {
            PApplet.main((String[])try5.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Body {
        float m;
        PVector p;
        PVector q;
        PVector s;

        Body(float m, PVector p) {
            this.m = m;
            this.p = p;
            this.q = p;
            this.s = new PVector(0.0f, 0.0f);
        }

        public void update() {
            this.s.mult(0.98f);
            this.p = PVector.add((PVector)this.p, (PVector)this.s);
        }

        public void attract(Body b) {
            float d = try5.constrain((float)PVector.dist((PVector)this.p, (PVector)b.p), (float)10.0f, (float)100.0f);
            PVector f = PVector.mult((PVector)PVector.sub((PVector)b.p, (PVector)this.p), (float)(b.m * this.m * 0.1f / (d * d)));
            PVector a = PVector.div((PVector)f, (float)this.m);
            this.s.add(a);
        }

        public void show() {
            try5.this.line(this.p.x, this.p.y, this.q.x, this.q.y);
            this.q = this.p;
        }
    }

    class Circle {
        float x;
        float y;
        float rad;

        Circle(float tempX, float tempY, float tempR) {
            this.x = tempX;
            this.y = tempY;
            this.rad = tempR;
        }

        public void display() {
            try5.this.noFill();
            try5.this.stroke(255, 200.0f - 2.0f * this.rad);
            try5.this.strokeWeight(0.4f);
            try5.this.ellipse(this.x, this.y, this.rad, this.rad);
            try5.this.noStroke();
        }

        public void movement() {
            this.rad += 1.0f;
            if (255.0f - 2.0f * this.rad < 0.0f) {
                try5.this.drops.remove(0);
            }
        }
    }

    class Ptc {
        PVector pos;
        PVector pPos;
        PVector vel;
        PVector acc;
        float decay;
        float weight;
        float magScalar;

        Ptc() {
            this.pos = new PVector(try5.this.random(try5.this.width), try5.this.random(try5.this.height));
            this.pPos = new PVector(this.pos.x, this.pos.y);
            this.vel = new PVector(0.0f, 0.0f);
            this.acc = new PVector(0.0f, 0.0f);
            this.weight = try5.this.random(1.0f, 10.0f);
            this.decay = try5.map((float)this.weight, (float)1.0f, (float)10.0f, (float)0.95f, (float)0.85f);
            this.magScalar = try5.map((float)this.weight, (float)1.0f, (float)10.0f, (float)0.5f, (float)0.05f);
        }

        public void update(float tgtX, float tgtY) {
            this.pPos.set(this.pos.x, this.pos.y);
            this.acc.set(tgtX - this.pos.x, tgtY - this.pos.y);
            float accMag = try5.sqrt((float)(try5.sq((float)this.acc.x) + try5.sq((float)this.acc.y)));
            this.acc.mult(1.0f / accMag);
            this.acc.mult(try5.this.gMag * this.magScalar);
            this.vel.add(this.acc);
            float velMag = try5.sqrt((float)(try5.sq((float)this.vel.x) + try5.sq((float)this.vel.y)));
            if (velMag > try5.this.gVelMax) {
                this.vel.mult(try5.this.gVelMax / velMag);
            }
            this.pos.add(this.vel);
            this.acc.set(0.0f, 0.0f, 0.0f);
            this.boundaryCheck();
        }

        public void update() {
            this.pPos.set(this.pos.x, this.pos.y);
            this.vel.add(this.acc);
            this.vel.mult(this.decay);
            this.pos.add(this.vel);
            this.acc.set(0.0f, 0.0f);
            this.boundaryCheck();
        }

        public void drawPtc() {
            try5.this.strokeWeight(this.weight);
            try5.this.stroke(0, 255.0f);
            if (try5.this.aliveAnimate) {
                try5.this.line(this.pos.x, this.pos.y, this.pPos.x, this.pPos.y);
            } else {
                try5.this.point(this.pos.x, this.pos.y);
            }
        }

        public void drawCnt(Ptc coPtc, float scalar) {
            try5.this.strokeWeight((this.weight + coPtc.weight) * 0.5f * scalar);
            try5.this.stroke(0, 255.0f * scalar);
            try5.this.line(this.pos.x, this.pos.y, coPtc.pos.x, coPtc.pos.y);
        }

        public void boundaryCheck() {
            if (this.pos.x > (float)try5.this.width) {
                this.pos.x = try5.this.width;
                this.vel.x *= -1.0f;
            } else if (this.pos.x < 0.0f) {
                this.pos.x = 0.0f;
                this.vel.x *= -1.0f;
            }
            if (this.pos.y > (float)try5.this.height) {
                this.vel.y *= -1.0f;
            } else if (this.pos.y < 0.0f) {
                this.vel.y *= -1.0f;
            }
        }
    }

    class ZObject {
        float x;
        float y;
        float z;
        float xsize;
        float ysize;
        int bubble_color;
        int shaded_color;
        float vx;
        float vy;
        float vz;

        ZObject(float ix, float iy, float iz, int icolor) {
            this.x = ix;
            this.y = iy;
            this.z = iz;
            this.xsize = try5.this.RADIUS;
            this.ysize = try5.this.RADIUS;
            this.bubble_color = icolor;
            this.setColor();
            this.vx = try5.this.random(-1.0f, 1.0f);
            this.vy = try5.this.random(-1.0f, 1.0f);
            this.vz = try5.this.random(-1.0f, 1.0f);
            float magnitude = try5.sqrt((float)(this.vx * this.vx + this.vy * this.vy + this.vz * this.vz));
            this.vx = try5.this.SPEED * this.vx / magnitude;
            this.vy = try5.this.SPEED * this.vy / magnitude;
            this.vz = try5.this.SPEED * this.vz / magnitude;
        }

        public void setColor() {
            float shade = this.z;
            float shadeinv = 1.0f - shade;
            this.shaded_color = try5.this.color(try5.this.red(this.bubble_color) * shade + try5.this.red(try5.this.BACKGROUND) * shadeinv, try5.this.green(this.bubble_color) * shade + try5.this.green(try5.this.BACKGROUND) * shadeinv, try5.this.blue(this.bubble_color) * shade + try5.this.blue(try5.this.BACKGROUND) * shadeinv);
        }

        public void zoomIn(float step) {
            this.z += step;
            if (this.z > 1.0f) {
                this.z = 0.0f + (this.z - 1.0f);
            }
        }

        public void zoomOut(float step) {
            this.z -= step;
            if (this.z < 0.0f) {
                this.z = 1.0f - (0.0f - this.z);
            }
        }

        public void update(boolean doZoomIn, boolean doZoomOut) {
            if (doZoomIn) {
                this.zoomIn(try5.this.ZSTEP);
            }
            if (doZoomOut) {
                this.zoomOut(try5.this.ZSTEP);
            }
            if (this.x <= 0.0f) {
                this.vx = try5.abs((float)this.vx);
                this.x = 0.0f;
            }
            if (this.x >= 1.0f) {
                this.vx = -1.0f * try5.abs((float)this.vx);
                this.x = 1.0f;
            }
            if (this.y <= 0.0f) {
                this.vy = try5.abs((float)this.vy);
                this.y = 0.0f;
            }
            if (this.y >= 1.0f) {
                this.vy = -1.0f * try5.abs((float)this.vy);
                this.y = 1.0f;
            }
            if (this.z < 0.0f || this.z > 1.0f) {
                this.z %= 1.0f;
            }
            this.x += this.vx;
            this.y += this.vy;
            this.setColor();
        }

        public void draw(float xoffs, float yoffs) {
            block5: {
                float radius;
                float posY;
                float posX;
                block6: {
                    block4: {
                        posX = try5.this.ZOOM * this.x * (float)try5.this.WIDTH * (1.0f + this.z * this.z) - try5.this.ZOOM * xoffs * (float)try5.this.WIDTH * this.z * this.z;
                        posY = try5.this.ZOOM * this.y * (float)try5.this.HEIGHT * (1.0f + this.z * this.z) - try5.this.ZOOM * yoffs * (float)try5.this.HEIGHT * this.z * this.z;
                        radius = this.z * this.xsize;
                        if (posX > -this.xsize * 2.0f && posX < (float)try5.this.WIDTH + this.xsize * 2.0f && posY > -this.xsize * 2.0f && posY < (float)try5.this.HEIGHT + this.xsize * 2.0f && try5.this.value < 70.0 && try5.this.value != 420.0) {
                            try5.this.blurred_circle(posX, posY, radius, try5.abs((float)(this.z - try5.this.FOCAL_LENGTH)), this.shaded_color, (float)try5.this.MIN_BLUR_LEVELS + this.z * (float)try5.this.BLUR_LEVEL_COUNT);
                        }
                        if (!(radius < 1.0f) || !(try5.this.value > 20.0)) break block4;
                        int i = 0;
                        while (i < 1) {
                            try5.this.drops.add(new Circle(posX, posY, try5.this.r - (float)(10 * i)));
                            ++i;
                        }
                        break block5;
                    }
                    if (!(radius < 1.0f) || !(try5.this.value > 30.0)) break block6;
                    int i = 0;
                    while (i < 1) {
                        try5.this.drops.add(new Circle(posX, posY, try5.this.r - (float)(10 * i)));
                        ++i;
                    }
                    break block5;
                }
                if (!(radius < 1.0f) || !(try5.this.value > 40.0) || !(try5.this.value <= 60.0)) break block5;
                int i = 0;
                while (i < 1) {
                    try5.this.drops.add(new Circle(posX, posY, try5.this.r - (float)(10 * i)));
                    ++i;
                }
            }
        }
    }
}

