long runtime;

void setup() {
  size(1920, 1080);
  //fullScreen(); //P2D
  frameRate(24);
  starInit();
  noise1();
  sys = new ObjectSystem();
  smooth(8);
  noStroke();
  
  //sound:
  minim = new Minim(this);
  audioplayer = minim.loadFile(musicfile, bufsize);
  buffers = new MultiChannelBuffer(2, 2);
  rate = (int)audioplayer.sampleRate();
  minim.loadFileIntoBuffer(musicfile, buffers);
  sampledata = buffers.getChannel(0); //vain vasen kanava
  ding = new BeatDetect(windowsize, rate);
  ding.detectMode(BeatDetect.FREQ_ENERGY);
  for (int i = 0; i < width; i++) {
    oscillatorHeights.add(0.0);
  }
  audioplayer.play();
  
}

void draw() {
  runtime = millis()/1000l; //
  if (runtime < 17) { //0-16
    background(0);
    textSize(250);
    fill(#ffffff);
    textAlign(CENTER, CENTER);
    text("Battle Baouws", width/2, height/2-20);
  }

  else if (runtime >= 17 && runtime < 24) { //16-20
    background(0);
    drawStarL(0, height/2, 10);
  }
  else if (runtime >= 24 && runtime < 31) {
    background(0);
    drawStarR(width, height/2, 10);
  }
  else if (runtime >= 31 && runtime < 39) {
    background(0);
    drawStarL(width/2, height/2, 100);
  }
  else if (runtime >= 39 && runtime < 46) {
    background(0);
    drawStarR(width/2, height/2, 100);
  }
  else if (runtime >= 46 && runtime < 53) {
    background(0);
    drawStarL(0, height/2, 100);
    drawStarR(width, 0, 100);
  }
  else if (runtime >= 53 && runtime < 62) {
    background(0);
    sys.run();
    drawHud();
    soundDraw();
    if (runtime > 57 && runtime <= 62) {
      textSize(300);
      fill(#ffffff);
      textAlign(CENTER, CENTER);
      text("Destroy", width/2, height/2-20);
    }
  }
  else if (runtime >= 62 && runtime < 67) {
    background(0);
    drawStarL(0, height/2, 100);
    drawStarR(width, 0, 100);
  }
  else if (runtime >= 37 && runtime < 105) {
    destroyActive = true;
    background(0);
    sys.run();
    drawHud();
    soundDraw();
  }
  else {
    background(0);
    textSize(450);
    fill(#ffffff);
    textAlign(CENTER, CENTER);
    text("The End", width/2, height/2-20);
  }
  if (runtime > 110) {
    exit(); //noLoop();
  }
}