ObjectSystem sys;

class ObjectSystem {
  
  float Dim = 25.0; //diameter of circles
  int howMany = 200; //how many circles gets greated.
  
  float t = 20; //randomises speed between -t and t.
  
  ArrayList<Circle> circlesL;
  ArrayList<Circle> circlesR;
  ObjectSystem() {
    circlesL = new ArrayList<Circle>();
    circlesR = new ArrayList<Circle>();
    for (int i = 0; i < howMany; i++) { //greates and adds circles to arrays
     circlesL.add(new Circle(random(Dim/2, width-Dim/2), random(height/2, height-Dim/2), random(-t, t), random(-t, t), Dim, #ff0000));
     circlesR.add(new Circle(random(Dim/2, width-Dim/2), random(height/2, height-Dim/2), random(-t, t), random(-t, t), Dim, #0000ff));
    }
  }
  
  void run() { //runs through arrays and draws, moves and checks collisions.
    Circle l;
    Circle r;
    boolean destroy = false;
    
    for (int i = 0; i < circlesL.size(); i++) {
      l = circlesL.get(i);
      l.drawC();
      l.move(l.getDirX(), l.getDirY());
      checkBoundaryCollision(l);
      for (int j = 0; j < circlesR.size(); j++) {
        r = circlesR.get(j);
        destroy = checkCollision(l, r);
        if (destroy) {
          circlesR.remove(r);
          circlesL.remove(l);
        }
      }
    }
    
    for (int i = 0; i < circlesR.size(); i++) {
      r = circlesR.get(i);
      r.drawC();
      r.move(r.getDirX(), r.getDirY());
      checkBoundaryCollision(r);
    }
    
    for (int i = 0; i < circlesL.size()-1; i++) {
      Circle li = circlesL.get(i);
      for (int j = i+1; j < circlesL.size(); j++) {
        Circle lj = circlesL.get(j);
        destroy = checkCollision(li, lj);
        if (destroy) {
          circlesL.remove(li);
          //circlesL.remove(lj); //might cause error
        }
      }
    }
    
    for (int i = 0; i < circlesR.size()-1; i++) {
      Circle ri = circlesR.get(i);
      for (int j = i+1; j < circlesR.size(); j++) {
        Circle rj = circlesR.get(j);
        checkCollision(ri, rj);
        destroy = checkCollision(ri, rj);
        if (destroy) {
          circlesR.remove(ri);
          //circlesR.remove(rj); //might cause error
        }
      }
    }
  }
}