/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

public class FFT {
    PApplet parent;
    private Engine m_engine;
    public int m_fftSize;
    private long ptr;
    public float[] spectrum;

    public FFT(PApplet pApplet, int n) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        this.spectrum = new float[n];
        this.m_fftSize = n;
        Engine.setPreferences(pApplet, 512, 44100);
        FFT fFT = this;
        fFT.m_engine.start();
    }

    public void input(SoundObject soundObject) {
        this.ptr = Engine.fft(soundObject.returnId(), this.m_fftSize);
    }

    public void analyze(float[] fArray) {
        float[] fArray2 = Engine.poll_fft(this.ptr);
        int n = Math.min(fArray.length, fArray2.length);
        for (int i = 0; i < n; ++i) {
            fArray[i] = fArray2[i];
        }
    }

    public void analyze() {
        float[] fArray = Engine.poll_fft(this.ptr);
        int n = Math.min(this.spectrum.length, fArray.length);
        for (int i = 0; i < n; ++i) {
            this.spectrum[i] = fArray[i];
        }
    }

    public int size() {
        return this.m_fftSize;
    }

    public void dispose() {
        Engine.destroy_fft(this.ptr);
    }
}

