/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import java.io.File;
import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.MethClaInterface;
import processing.sound.SoundObject;

public class SoundFile
implements SoundObject {
    PApplet parent;
    private Engine m_engine;
    private MethClaInterface methCla;
    private int[] m_nodeId = new int[]{-1, -1};
    int[] m_info;
    String m_filePath;
    float m_rate = 1.0f;
    float m_amp = 1.0f;
    float m_add = 0.0f;
    int m_cue = 0;
    float m_pos = 0.0f;
    boolean m_loop;
    int m_panBusId;
    int m_isPlaying = 0;

    public SoundFile(PApplet pApplet, String string) {
        this.parent = pApplet;
        this.parent.registerMethod("dispose", (Object)this);
        Engine.setPreferences(pApplet, 512, 44100);
        SoundFile soundFile = this;
        soundFile.m_engine.start();
        this.methCla = new MethClaInterface();
        this.m_filePath = pApplet.dataPath(string);
        File file = new File(this.m_filePath);
        if (file.isFile()) {
            this.m_info = Engine.soundFileInfo(this.m_filePath);
        } else {
            System.out.println("Error: Soundfile doesn't exist. Pleae check path");
        }
        SoundFile soundFile2 = this;
        this.m_panBusId = soundFile2.m_engine.busConstructMono();
    }

    public int frames() {
        return this.m_info[0];
    }

    public int sampleRate() {
        return this.m_info[1];
    }

    public int channels() {
        return this.m_info[2];
    }

    public float duration() {
        return (float)this.frames() / (float)this.sampleRate();
    }

    public void play() {
        this.m_loop = false;
        if (this.channels() == 1) {
            this.m_nodeId = this.methCla.soundFilePlayMono(this.m_rate, this.m_pos, this.m_amp, this.m_add, false, this.m_filePath, this.duration() * (1.0f / this.m_rate), this.m_cue, this.m_panBusId);
        } else if (this.channels() == 2) {
            this.m_nodeId = this.methCla.soundFilePlayMulti(this.m_rate, this.m_amp, this.m_add, false, this.m_filePath, this.duration() * (1.0f / this.m_rate), this.m_cue);
        }
        this.m_isPlaying = 1;
    }

    public void play(float f, float f2, float f3, float f4, int n) {
        this.m_rate = f;
        this.m_pos = f2;
        this.m_amp = f3;
        this.m_add = f4;
        this.m_cue = n * this.m_info[1];
        this.play();
    }

    public void play(float f, float f2, float f3, float f4) {
        this.m_rate = f;
        this.m_pos = f2;
        this.m_amp = f3;
        this.m_add = f4;
        this.play();
    }

    public void play(float f, float f2, float f3) {
        this.m_rate = f;
        this.m_pos = f2;
        this.m_amp = f3;
        this.play();
    }

    public void play(float f, float f2) {
        this.m_rate = f;
        this.m_amp = f2;
        this.play();
    }

    public void play(float f) {
        this.m_rate = f;
        this.play();
    }

    public void loop() {
        this.m_loop = true;
        if (this.channels() < 2) {
            this.m_nodeId = this.methCla.soundFilePlayMono(this.m_rate, this.m_pos, this.m_amp, this.m_add, true, this.m_filePath, this.duration() * (1.0f / this.m_rate), this.m_cue, this.m_panBusId);
        } else if (this.channels() == 2) {
            this.m_nodeId = this.methCla.soundFilePlayMulti(this.m_rate, this.m_amp, this.m_add, true, this.m_filePath, this.duration() * (1.0f / this.m_rate), this.m_cue);
        }
    }

    public void loop(float f, float f2, float f3, float f4, int n) {
        this.m_rate = f;
        this.m_pos = f2;
        this.m_amp = f3;
        this.m_add = f4;
        this.m_cue = n;
        this.loop();
    }

    public void loop(float f, float f2, float f3, float f4) {
        this.m_rate = f;
        this.m_pos = f2;
        this.m_amp = f3;
        this.m_add = f4;
        this.loop();
    }

    public void loop(float f, float f2, float f3) {
        this.m_rate = f;
        this.m_pos = f2;
        this.m_amp = f3;
        this.loop();
    }

    public void loop(float f, float f2) {
        this.m_rate = f;
        this.m_amp = f2;
        this.loop();
    }

    public void loop(float f) {
        this.m_rate = f;
        this.loop();
    }

    public void jump(float f) {
        if (this.m_nodeId[0] > -1) {
            this.stop();
        }
        this.m_cue = (int)(f * (float)this.m_info[1]);
        if (this.m_loop) {
            if (this.channels() < 2) {
                this.m_nodeId = this.methCla.soundFilePlayMono(this.m_rate, this.m_pos, this.m_amp, this.m_add, true, this.m_filePath, this.duration() * (1.0f / this.m_rate), this.m_cue, this.m_panBusId);
            } else if (this.channels() == 2) {
                this.m_nodeId = this.methCla.soundFilePlayMulti(this.m_rate, this.m_amp, this.m_add, true, this.m_filePath, this.duration() * (1.0f / this.m_rate), this.m_cue);
            }
        } else if (this.channels() < 2) {
            this.m_nodeId = this.methCla.soundFilePlayMono(this.m_rate, this.m_pos, this.m_amp, this.m_add, false, this.m_filePath, this.duration() * (1.0f / this.m_rate), this.m_cue, this.m_panBusId);
        } else if (this.channels() == 2) {
            this.m_nodeId = this.methCla.soundFilePlayMulti(this.m_rate, this.m_amp, this.m_add, false, this.m_filePath, this.duration() * (1.0f / this.m_rate), this.m_cue);
        }
        this.m_isPlaying = 1;
    }

    public void cue(float f) {
        this.m_cue = (int)(f * (float)this.m_info[1]);
    }

    private void set() {
        if (this.m_nodeId[0] != -1) {
            if (this.channels() < 2) {
                Engine.soundFileSetMono(this.m_rate, this.m_pos, this.m_amp, this.m_add, this.m_nodeId);
            } else if (this.channels() == 2) {
                Engine.soundFileSetStereo(this.m_rate, this.m_amp, this.m_add, this.m_nodeId);
            }
        }
    }

    public void set(float f, float f2, float f3, float f4) {
        this.m_rate = f;
        this.m_pos = f2;
        this.m_amp = f3;
        this.m_add = f4;
        this.set();
    }

    public void pan(float f) {
        if (this.channels() > 1) {
            throw new UnsupportedOperationException("Panning is not supported for stereo files");
        }
        this.m_pos = f;
        this.set();
    }

    public void rate(float f) {
        this.m_rate = f;
        this.set();
    }

    public void amp(float f) {
        this.m_amp = f;
        this.set();
    }

    public void add(float f) {
        this.m_add = f;
        this.set();
    }

    public void stop() {
        Engine.synthStop(this.m_nodeId);
        for (int i = 0; i < this.m_nodeId.length; ++i) {
            this.m_nodeId[i] = -1;
        }
        this.m_isPlaying = 0;
    }

    @Override
    public int[] returnId() {
        return this.m_nodeId;
    }

    public int isPlaying() {
        return this.m_isPlaying;
    }

    public void dispose() {
        Engine.synthStop(this.m_nodeId);
    }
}

