/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PShape;
import processing.sound.Amplitude;
import processing.sound.SoundFile;
import processing.sound.SoundObject;

public class AwsumDemo
extends PApplet {
    Minim minim;
    AudioPlayer s;
    FFT f;
    SoundFile sample;
    SoundFile sample2;
    SoundFile sample3;
    SoundFile sample4;
    Amplitude rms;
    PImage img;
    PShape spinner;
    float zPosition;
    float timePrev;
    int stage;
    int demoCounter;
    float angle;
    ArrayList<demoBase> Demos;

    public void setup() {
        this.demoCounter = 0;
        this.minim = new Minim((Object)this);
        this.s = this.minim.loadFile("Furious Freak.mp3");
        this.f = new FFT(this.s.bufferSize(), this.s.sampleRate());
        PImage iJ = this.loadImage("Juge.JPG");
        PImage iH = this.loadImage("Hai.jpg");
        PImage iT = this.loadImage("Timo.jpg");
        PImage iM = this.loadImage("Max.jpg");
        this.sample = new SoundFile((PApplet)this, "Furious Freak.mp3");
        this.sample2 = new SoundFile((PApplet)this, "Furious Freak.mp3");
        this.sample3 = new SoundFile((PApplet)this, "Furious Freak.mp3");
        this.sample4 = new SoundFile((PApplet)this, "Furious Freak.mp3");
        PShape spinnuri = this.loadShape("helicopter_2.obj");
        PShape spinner = this.loadShape("fidget_spinner_final123.obj");
        this.rms = new Amplitude((PApplet)this);
        spinner = this.loadShape("fidget_spinner_final123.obj");
        this.zPosition = 0.0f;
        this.stage = 0;
        this.timePrev = 0.0f;
        this.Demos = new ArrayList();
        this.Demos.add(new lineDemo(this.sample3));
        this.Demos.add(new spinnerDemo(this.sample, this.rms, this.img, spinner));
        this.Demos.add(new TravercingBall(this.s, this.f));
        this.Demos.add(new copterDemo(this.sample4, spinnuri, spinner));
        this.Demos.add(new Presentation(iJ, iH, iT, iM, this.sample2));
    }

    public void draw() {
        float time = (float)this.millis() / 1000.0f;
        switch (this.stage) {
            case 0: {
                this.drawStuff();
                if (!(time - this.timePrev > 2.0f)) break;
                this.stage = 1;
                this.timePrev = time;
                break;
            }
            case 1: {
                this.drawStuff();
                this.zPosition += 10.0f;
                if (!(this.zPosition > 700.0f)) break;
                this.stage = 2;
                this.timePrev = time;
                break;
            }
            case 2: {
                if (this.Demos.size() <= this.demoCounter) {
                    this.stage = 5;
                    break;
                }
                demoBase demo2 = this.Demos.get(this.demoCounter);
                demo2.playDemo();
                if (!demo2.isOver()) break;
                this.stage = 3;
                this.timePrev = time;
                ++this.demoCounter;
                break;
            }
            case 3: {
                this.drawStuff();
                this.zPosition -= 10.0f;
                if (!(this.zPosition < 300.0f)) break;
                this.stage = 4;
                this.timePrev = time;
                this.angle = 0.0f;
                break;
            }
            case 4: {
                this.drawStuff();
                this.angle += 3.0f;
                if (!(this.angle > 89.0f)) break;
                this.angle = 90.0f;
                this.stage = 1;
                this.timePrev = time;
                break;
            }
            case 5: {
                this.exit();
            }
        }
    }

    public void drawStuff() {
        this.pushMatrix();
        this.background(0);
        this.translate(this.width / 2, this.height / 2, this.zPosition);
        this.rotateY(AwsumDemo.radians((float)this.angle));
        this.noFill();
        this.stroke(255);
        this.box(250.0f);
        this.popMatrix();
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--hide-stop", "AwsumDemo"};
        if (passedArgs != null) {
            PApplet.main((String[])AwsumDemo.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Anomaly {
        float yCoord;
        float xCoord;
        float zCoord;
        float xVelocity;
        float yVelocity;
        float yGround;
        float angle;

        public Anomaly(float xCoord) {
            this.yGround = AwsumDemo.this.height - 200;
            this.xCoord = xCoord;
            this.yCoord = AwsumDemo.this.height - 200;
            this.zCoord = -400.0f;
            this.angle = 0.0f;
        }

        public void bounce() {
            if (this.yVelocity > -30.0f) {
                this.yVelocity -= AwsumDemo.this.random(15.0f, 25.0f);
            }
        }

        public void draw(int r, int g, int b, float high) {
            this.yCoord += this.yVelocity;
            this.zCoord -= AwsumDemo.this.random(-10.0f, 10.0f) / 10.0f;
            if (this.yCoord > this.yGround) {
                this.yCoord = this.yGround;
                this.yVelocity = 0.0f;
            }
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.translate(this.xCoord, this.yCoord, this.zCoord);
            AwsumDemo.this.fill(0.0f, 0.0f, 0.0f, 255.0f);
            AwsumDemo.this.rotateX(AwsumDemo.radians((float)this.angle));
            AwsumDemo.this.strokeWeight(1.0f);
            AwsumDemo.this.stroke(r, g, b);
            AwsumDemo.this.sphere(300.0f + high);
            AwsumDemo.this.popMatrix();
            this.yVelocity += 8.0f;
            this.angle += 8.0f;
        }
    }

    class MistGenerator {
        float xPos;
        float yPos;
        float zPos;
        ArrayList<mistParticle> particleList;

        public MistGenerator(float x, float y, float z) {
            this.xPos = x;
            this.yPos = y;
            this.zPos = z;
            this.particleList = new ArrayList();
            this.makeMist();
        }

        public void makeMist() {
            int i = 0;
            while (i < 25) {
                this.particleList.add(new mistParticle(this.xPos + AwsumDemo.this.random(-400.0f, 400.0f), this.yPos + AwsumDemo.this.random(-300.0f, 200.0f), this.zPos));
                ++i;
            }
        }

        public void spawnNewParticle() {
            this.particleList.add(new mistParticle(this.xPos + AwsumDemo.this.random(-400.0f, 400.0f), this.yPos + AwsumDemo.this.random(-300.0f, 200.0f), this.zPos));
        }

        public void draw(float r, float g, float b) {
            float mult = AwsumDemo.this.randomGaussian();
            r *= mult;
            g *= mult;
            b *= mult;
            int i = 0;
            while (i < this.particleList.size()) {
                mistParticle p = this.particleList.get(i);
                p.draw(r, g, b);
                if (!p.isAlive()) {
                    this.particleList.remove(i);
                    this.spawnNewParticle();
                }
                ++i;
            }
        }
    }

    class Presentation
    extends demoBase {
        PShape rectangle;
        PImage imgJugge;
        PImage imgHai;
        PImage imgMax;
        PImage imgTimo;
        PImage img;
        float angle;
        boolean large;
        float timeDelta;
        float timePrev;
        float startTime;
        SoundFile sample;
        String s;

        public Presentation(PImage j, PImage h, PImage m, PImage t, SoundFile sample) {
            this.large = false;
            this.timeDelta = 0.0f;
            this.timePrev = 0.0f;
            this.startTime = -1.0f;
            this.imgJugge = j;
            this.imgHai = h;
            this.imgMax = m;
            this.imgTimo = t;
            this.angle = 0.0f;
            this.s = "";
            this.rectangle = AwsumDemo.this.createShape(40, new float[]{250.0f});
            this.rectangle.setTexture(this.img);
            this.sample = sample;
        }

        @Override
        public void playDemo() {
            AwsumDemo.this.background(66.0f, 240.0f, 240.0f);
            if (this.startTime == -1.0f) {
                this.sample.loop();
                this.startTime = (float)AwsumDemo.this.millis() / 1000.0f;
            }
            this.getFace();
            float time = (float)AwsumDemo.this.millis() / 1000.0f;
            this.timeDelta = time - this.timePrev;
            if (this.timeDelta > 0.2f) {
                this.timePrev = time;
                if (this.large) {
                    AwsumDemo.this.background(66.0f, 241.0f, 161.0f);
                    AwsumDemo.this.noStroke();
                    AwsumDemo.this.fill(255);
                    this.rectangle = AwsumDemo.this.createShape(40, new float[]{250.0f});
                    this.rectangle.setTexture(this.img);
                    this.large = false;
                } else {
                    AwsumDemo.this.background(66.0f, 240.0f, 240.0f);
                    AwsumDemo.this.noStroke();
                    AwsumDemo.this.fill(255);
                    this.rectangle = AwsumDemo.this.createShape(40, new float[]{450.0f});
                    this.rectangle.setTexture(this.img);
                    this.large = true;
                }
            } else if (this.large) {
                AwsumDemo.this.pushMatrix();
                AwsumDemo.this.background(66.0f, 241.0f, 161.0f);
                AwsumDemo.this.noStroke();
                AwsumDemo.this.fill(255);
                this.rectangle = AwsumDemo.this.createShape(40, new float[]{250.0f});
                this.rectangle.setTexture(this.img);
                AwsumDemo.this.popMatrix();
            } else {
                AwsumDemo.this.pushMatrix();
                AwsumDemo.this.background(66.0f, 240.0f, 240.0f);
                AwsumDemo.this.noStroke();
                AwsumDemo.this.fill(255);
                this.rectangle = AwsumDemo.this.createShape(40, new float[]{450.0f});
                this.rectangle.setTexture(this.img);
                AwsumDemo.this.popMatrix();
            }
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.translate(AwsumDemo.this.width / 2, AwsumDemo.this.height / 2);
            AwsumDemo.this.rotateY(AwsumDemo.radians((float)this.angle));
            AwsumDemo.this.rotateX(AwsumDemo.radians((float)this.angle));
            AwsumDemo.this.shape(this.rectangle);
            AwsumDemo.this.popMatrix();
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.translate(10.0f, 10.0f, 0.0f);
            AwsumDemo.this.noFill();
            AwsumDemo.this.stroke(255);
            AwsumDemo.this.sphere(280.0f);
            AwsumDemo.this.popMatrix();
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.translate(80.0f, AwsumDemo.this.height - 40, 0.0f);
            AwsumDemo.this.noFill();
            AwsumDemo.this.stroke(255);
            AwsumDemo.this.sphere(150.0f);
            AwsumDemo.this.popMatrix();
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.textSize(28.0f);
            AwsumDemo.this.fill(0.0f, 102.0f, 153.0f);
            AwsumDemo.this.text(this.s, AwsumDemo.this.width - 500, 150.0f);
            AwsumDemo.this.text("song: Furious Freak", AwsumDemo.this.width - 300, AwsumDemo.this.height - 150);
            AwsumDemo.this.popMatrix();
            this.angle += 1.0f;
        }

        public void getFace() {
            float t = (float)AwsumDemo.this.millis() / 1000.0f - this.startTime;
            if (t < 4.0f) {
                this.s = "HaiTech";
                this.img = this.imgHai;
            } else if (t < 8.0f) {
                this.s = "Max";
                this.img = this.imgTimo;
            } else if (t < 13.0f) {
                this.s = "Jidoor";
                this.img = this.imgMax;
            } else if (t < 16.0f) {
                this.s = "Juge";
                this.img = this.imgJugge;
            }
        }

        @Override
        public boolean isOver() {
            boolean result = false;
            if ((float)AwsumDemo.this.millis() / 1000.0f - this.startTime > 19.0f) {
                this.sample.stop();
                result = true;
            }
            return result;
        }
    }

    class Road {
        float yCoord;
        float xCoord;
        float zCoord = -1000.0f;
        ArrayList<roadStrip> stripList;
        MistGenerator mistGenerator1;
        MistGenerator mistGenerator2;
        MistGenerator mistGenerator3;

        public Road() {
            this.mistGenerator1 = new MistGenerator(100.0f, 100.0f, -500.0f);
            this.mistGenerator2 = new MistGenerator(AwsumDemo.this.width - 100, 100.0f, -500.0f);
            this.mistGenerator3 = new MistGenerator(AwsumDemo.this.width / 2, 100.0f, -500.0f);
            this.stripList = new ArrayList();
            this.stripList.add(new roadStrip(-500.0f));
            this.stripList.add(new roadStrip(-1000.0f));
            this.stripList.add(new roadStrip(-1500.0f));
        }

        public void update(int r, int g, int b) {
            if (this.stripList.size() < 3) {
                this.stripList.add(new roadStrip(-1000.0f));
            }
            this.mistGenerator1.draw(r, g, b);
            this.mistGenerator2.draw(r, g, b);
            this.mistGenerator3.draw(r, g, b);
            int i = 0;
            while (i < this.stripList.size()) {
                roadStrip road = this.stripList.get(i);
                road.update(r, g, b);
                ++i;
            }
        }
    }

    class TravercingBall
    extends demoBase {
        Minim minim;
        AudioPlayer s;
        FFT f;
        float specLow;
        float specMid;
        float specHi;
        int scoreLow;
        int scoreMid;
        int scoreHi;
        ArrayList<Anomaly> a;
        Road road;
        boolean done;
        float startTime;
        float angle;

        public TravercingBall(AudioPlayer s, FFT f) {
            this.specLow = 0.03f;
            this.specMid = 0.125f;
            this.specHi = 0.2f;
            this.scoreLow = 0;
            this.scoreMid = 0;
            this.scoreHi = 0;
            this.s = s;
            this.f = f;
            this.startTime = -1.0f;
            this.road = new Road();
            this.a = new ArrayList();
            this.a.add(new Anomaly(AwsumDemo.this.width / 2));
        }

        @Override
        public void playDemo() {
            float t;
            if (this.startTime == -1.0f) {
                this.angle = 0.0f;
                this.done = false;
                this.s.play(44500);
                this.startTime = (float)AwsumDemo.this.millis() / 1000.0f;
            }
            if ((t = (float)AwsumDemo.this.millis() / 1000.0f - this.startTime) > 20.0f) {
                if (this.angle < 90.0f) {
                    this.angle += 8.0f;
                } else {
                    this.s.pause();
                    this.done = true;
                }
            }
            this.drawBackGround();
            this.calculateScores();
            this.doStuff();
        }

        public void doStuff() {
            int i = this.a.size() - 1;
            while (i >= 0) {
                Anomaly h = this.a.get(i);
                if (this.scoreLow > 400) {
                    h.bounce();
                }
                h.draw(100 + this.scoreLow, 100 + this.scoreMid, 100 + this.scoreHi, this.scoreLow / 4);
                --i;
            }
            this.road.update(100 + this.scoreLow, 100 + this.scoreMid, 100 + this.scoreHi);
        }

        public void calculateScores() {
            this.scoreLow = 0;
            this.scoreMid = 0;
            this.scoreHi = 0;
            this.f.forward(this.s.mix);
            int i = 0;
            while ((float)i < (float)this.f.specSize() * this.specLow) {
                this.scoreLow = (int)((float)this.scoreLow + this.f.getBand(i));
                ++i;
            }
            i = (int)((float)this.f.specSize() * this.specLow);
            while ((float)i < (float)this.f.specSize() * this.specMid) {
                this.scoreMid = (int)((float)this.scoreMid + this.f.getBand(i));
                ++i;
            }
            i = (int)((float)this.f.specSize() * this.specMid);
            while ((float)i < (float)this.f.specSize() * this.specHi) {
                this.scoreHi = (int)((float)this.scoreHi + this.f.getBand(i));
                ++i;
            }
        }

        public void drawBackGround() {
            AwsumDemo.this.rotateY(AwsumDemo.radians((float)this.angle));
            AwsumDemo.this.background(this.scoreLow / 100, this.scoreHi / 10, this.scoreMid / 10);
        }

        @Override
        public boolean isOver() {
            if (this.done) {
                this.s.close();
                this.startTime = -1.0f;
            }
            return this.done;
        }
    }

    class copterDemo
    extends demoBase {
        PShape s;
        PShape spinner;
        float startTime;
        SoundFile sample;
        float rotation;
        float rotAcc;
        float copterZ;
        float copAcc;

        public copterDemo(SoundFile sample, PShape s, PShape spinner) {
            this.rotation = -90.0f;
            this.rotAcc = 0.5f;
            this.copterZ = -210.0f;
            this.copAcc = 0.2f;
            this.startTime = -1.0f;
            this.sample = sample;
            this.s = s;
            this.spinner = spinner;
        }

        @Override
        public void playDemo() {
            if (this.startTime == -1.0f) {
                this.startTime = (float)AwsumDemo.this.millis() / 1000.0f;
                this.sample.loop();
            }
            AwsumDemo.this.background(0);
            AwsumDemo.this.lights();
            AwsumDemo.this.translate((float)AwsumDemo.this.width * 0.5f, (float)AwsumDemo.this.height * 0.5f, 0.0f);
            AwsumDemo.this.rotateX(-0.31415927f);
            if (this.rotation >= -395.0f) {
                AwsumDemo.this.rotateY(AwsumDemo.radians((float)this.rotation));
                this.rotation -= this.rotAcc;
                this.rotAcc += 0.005f;
            } else {
                AwsumDemo.this.rotateY(AwsumDemo.radians((float)this.rotation));
                this.copterZ += this.copAcc;
                this.copAcc += 0.1f;
            }
            AwsumDemo.this.translate(0.0f, 0.0f, this.copterZ);
            this.drawChoppa();
        }

        public void drawChoppa() {
            float t = (float)AwsumDemo.this.millis() / 1000.0f;
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.translate(0.0f, 100.0f, 0.0f);
            AwsumDemo.this.scale(15.0f);
            AwsumDemo.this.rotateZ((float)Math.PI);
            AwsumDemo.this.shape(this.s, 0.0f, 0.0f);
            AwsumDemo.this.popMatrix();
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.translate(0.0f, -15.0f, 40.0f);
            AwsumDemo.this.scale(20.0f);
            AwsumDemo.this.rotateX((float)Math.PI);
            AwsumDemo.this.rotateY((float)Math.PI * 5 * t);
            AwsumDemo.this.shape(this.spinner, 0.0f, 0.0f);
            AwsumDemo.this.popMatrix();
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.translate(10.0f, -10.0f, -210.0f);
            AwsumDemo.this.scale(8.0f);
            AwsumDemo.this.rotateZ(1.5707964f);
            AwsumDemo.this.rotateY((float)Math.PI * 5 * t);
            AwsumDemo.this.shape(this.spinner, 0.0f, 0.0f);
            AwsumDemo.this.popMatrix();
        }

        @Override
        public boolean isOver() {
            boolean result = false;
            if ((float)AwsumDemo.this.millis() / 1000.0f - this.startTime > 7.0f) {
                this.sample.stop();
                result = true;
            }
            return result;
        }
    }

    abstract class demo {
        public void playDemo() {
        }
    }

    abstract class demoBase {
        demoBase() {
        }

        public abstract void playDemo();

        public abstract boolean isOver();
    }

    class lineDemo
    extends demoBase {
        PShape boxi;
        PShape globe;
        float zDimension = 1000.0f;
        Boolean forward = true;
        ArrayList<Integer> listOfLines;
        int colorChange = 0;
        int RGBSwitch = 0;
        int x = -990;
        int y = 0;
        int x2 = 990;
        int y2 = 0;
        int x3 = 150;
        int x4 = -150;
        float startTime = -1.0f;
        SoundFile sample;

        public lineDemo(SoundFile sample) {
            this.sample = sample;
        }

        @Override
        public void playDemo() {
            if (this.startTime == -1.0f) {
                this.startTime = (float)AwsumDemo.this.millis() / 1000.0f;
                this.sample.loop();
            }
            AwsumDemo.this.background(255);
            AwsumDemo.this.noFill();
            AwsumDemo.println((String)(String.valueOf(this.colorChange) + " " + this.forward + " " + this.RGBSwitch));
            if (this.colorChange < 255 && this.forward.booleanValue() && this.RGBSwitch == 0) {
                AwsumDemo.this.stroke(AwsumDemo.min((int)this.colorChange, (int)255), 0.0f, 0.0f);
                this.colorChange += 5;
                if (this.colorChange == 255 || this.colorChange == 250) {
                    this.RGBSwitch = 1;
                }
            } else if (this.colorChange <= 255 && this.forward.booleanValue() && this.RGBSwitch == 1) {
                AwsumDemo.this.stroke(0.0f, AwsumDemo.min((int)this.colorChange, (int)255), 0.0f);
                this.colorChange -= 5;
                if (this.colorChange == 0) {
                    this.RGBSwitch = 2;
                }
            } else if (this.colorChange < 255 && this.forward.booleanValue() && this.RGBSwitch == 2) {
                AwsumDemo.this.stroke(0.0f, 0.0f, AwsumDemo.min((int)this.colorChange, (int)255));
                this.colorChange += 5;
                if (this.colorChange == 250 || this.colorChange == 250) {
                    this.RGBSwitch = 0;
                }
            }
            AwsumDemo.this.translate(AwsumDemo.this.width / 2, AwsumDemo.this.height / 2);
            int i = 0;
            while (i < 35) {
                AwsumDemo.this.fill(i * 150 / 35);
                AwsumDemo.this.line(this.x + i, this.y + 100 * i, this.x2 - i, this.y2 - 100 * i);
                AwsumDemo.this.line(this.x + i, this.y - 100 * i, this.x2 - i, this.y2 + 100 * i);
                ++i;
            }
            AwsumDemo.this.stroke(255.0f, 0.0f, 0.0f);
            AwsumDemo.this.strokeWeight(5.0f);
            float seconds = (float)AwsumDemo.this.millis() / 1000.0f - this.startTime;
            if (this.forward.booleanValue()) {
                this.x3 = (int)((float)this.x3 + (1.0f + 5.9f * seconds));
                this.x4 = (int)((float)this.x4 - (1.0f + 5.9f * seconds));
                AwsumDemo.this.line(this.x3, 2000.0f, this.x3, -2000.0f);
                AwsumDemo.this.line(this.x4, 2000.0f, this.x4, -2000.0f);
            } else {
                this.x3 = (int)((float)this.x3 - (1.0f + 5.9f * seconds));
                this.x4 = (int)((float)this.x4 + (1.0f + 5.9f * seconds));
                AwsumDemo.this.line(this.x3, 2000.0f, this.x3, -2000.0f);
                AwsumDemo.this.line(this.x4, 2000.0f, this.x4, -2000.0f);
            }
            if (this.x3 > 800 && this.forward.booleanValue()) {
                this.forward = false;
            } else if (this.x3 < 0 && !this.forward.booleanValue()) {
                this.x3 = (int)((float)this.x3 - (1.0f + 1.9f * seconds));
                this.x4 = (int)((float)this.x4 + (1.0f + 1.9f * seconds));
                AwsumDemo.this.line(this.x3, 2000.0f, this.x3, -2000.0f);
                AwsumDemo.this.line(this.x4, 2000.0f, this.x4, -2000.0f);
                this.forward = true;
            }
        }

        @Override
        public boolean isOver() {
            boolean result = false;
            if ((float)AwsumDemo.this.millis() / 1000.0f - this.startTime > 7.0f) {
                this.sample.stop();
                result = true;
            }
            return result;
        }
    }

    class mistParticle {
        float xPos;
        float yPos;
        float zPos;
        float lifespan;
        float treshold;
        float sphereSize;
        boolean isBooming;
        boolean isDecaying;

        public mistParticle(float x, float y, float z) {
            this.xPos = x;
            this.yPos = y;
            this.zPos = z;
            this.zPos = AwsumDemo.this.random(-1000.0f, -100.0f);
            this.sphereSize = AwsumDemo.this.random(5.0f, 10.0f);
            this.isBooming = true;
            this.isDecaying = false;
            this.lifespan = AwsumDemo.this.random(10.0f, 60.0f);
            this.treshold = AwsumDemo.this.random(100.0f, 150.0f);
        }

        public void draw(float r, float g, float b) {
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.fill(r, g, b, this.lifespan);
            AwsumDemo.this.noStroke();
            AwsumDemo.this.translate(this.xPos, this.yPos, this.zPos);
            AwsumDemo.this.sphere(this.sphereSize);
            AwsumDemo.this.popMatrix();
            this.uptadePosition();
        }

        public void uptadePosition() {
            if (this.isBooming) {
                if (this.lifespan < this.treshold) {
                    this.lifespan += AwsumDemo.this.random(0.1f, 0.8f);
                } else {
                    this.isDecaying = true;
                    this.isBooming = false;
                }
            } else {
                this.lifespan -= AwsumDemo.this.random(0.2f, 0.4f);
            }
            this.xPos += AwsumDemo.this.random(-0.1f, 0.1f);
            this.yPos += AwsumDemo.this.random(-0.1f, 0.1f);
            this.zPos += 10.0f;
            if (this.zPos > 100.0f) {
                this.zPos = -1000.0f;
            }
        }

        public boolean isAlive() {
            boolean result = true;
            if (this.lifespan < 0.0f) {
                result = false;
            }
            return result;
        }
    }

    class roadStrip {
        float yCoord;
        float xCoord;
        float zCoord;

        public roadStrip(float z) {
            this.zCoord = z;
        }

        public void update(int r, int g, int b) {
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.stroke(10 + r, 10 + g, 10 + b, this.zCoord * -1.0f);
            AwsumDemo.this.strokeWeight(10.0f);
            AwsumDemo.this.line(-1500.0f, AwsumDemo.this.height - 100, 100.0f + this.zCoord, AwsumDemo.this.width + 1500, AwsumDemo.this.height - 50, this.zCoord);
            AwsumDemo.this.popMatrix();
            this.zCoord += 10.0f;
            if (this.zCoord > 100.0f) {
                this.zCoord = -1500.0f;
            }
        }
    }

    class spinnerDemo
    extends demoBase {
        SoundFile sample;
        Amplitude rms;
        float scale = 5.0f;
        float smooth_factor = 0.25f;
        float sum;
        PShape spinner;
        float startTime = 30.0f;
        float demoStartTime = -1.0f;
        float spinSpeed = 8.356637f;
        PImage img;
        boolean done;

        public spinnerDemo(SoundFile sample, Amplitude rms, PImage img, PShape spinner) {
            this.sample = sample;
            this.rms = rms;
            this.img = img;
            this.spinner = spinner;
        }

        @Override
        public void playDemo() {
            if (this.demoStartTime == -1.0f) {
                this.demoStartTime = (float)AwsumDemo.this.millis() / 1000.0f;
                this.sample.loop();
                this.sample.jump(this.startTime);
                this.rms.input((SoundObject)this.sample);
            }
            float t = (float)AwsumDemo.this.millis() / 1000.0f - this.demoStartTime + this.startTime;
            AwsumDemo.this.background(0);
            AwsumDemo.this.lights();
            AwsumDemo.this.translate(AwsumDemo.this.width / 2, AwsumDemo.this.height / 2, 0.0f);
            AwsumDemo.this.stroke(255);
            this.sum += (this.rms.analyze() - this.sum) * this.smooth_factor;
            float stage1 = 40.0f;
            float stage2 = 48.0f;
            float stage3 = 50.0f;
            float stage4 = 65.0f;
            if (t < stage1) {
                AwsumDemo.this.rotateX(-0.5235988f);
                AwsumDemo.this.rotateY(this.spinSpeed * t);
                AwsumDemo.this.scale(this.sum * 5.0f);
                this.drawSpinner();
            } else if (t < stage2) {
                AwsumDemo.this.rotateX(-0.5235988f);
                AwsumDemo.this.rotateY(this.spinSpeed * t);
                AwsumDemo.this.scale(this.sum * 5.0f);
                AwsumDemo.this.pushMatrix();
                float disp = (t - stage1) * 100.0f;
                AwsumDemo.this.translate(disp, 0.0f, 0.0f);
                this.drawSpinner();
                AwsumDemo.this.popMatrix();
                AwsumDemo.this.pushMatrix();
                AwsumDemo.this.translate(-disp, 0.0f, 0.0f);
                this.drawSpinner();
                AwsumDemo.this.popMatrix();
            } else if (t < stage3) {
                AwsumDemo.this.rotateX(1.5707964f);
                AwsumDemo.this.rotateY(this.spinSpeed * t);
                AwsumDemo.this.scale(0.25f);
                this.drawSpinner();
            } else if (t < stage4) {
                AwsumDemo.this.rotateX(1.5707964f);
                AwsumDemo.this.rotateY(this.spinSpeed * t);
                AwsumDemo.this.scale(0.25f);
                float disp = (t - stage3) * 100.0f;
                int counter = 0;
                float i = 0.0f;
                while (i < (float)Math.PI * 2) {
                    AwsumDemo.this.pushMatrix();
                    AwsumDemo.this.translate(disp * AwsumDemo.sin((float)i), 0.0f, disp * AwsumDemo.cos((float)i));
                    if (counter % 2 == 0) {
                        AwsumDemo.this.rotateY(this.spinSpeed * t);
                    }
                    this.drawSpinner();
                    AwsumDemo.this.popMatrix();
                    ++counter;
                    i += 1.0471976f;
                }
            } else {
                this.done = true;
                AwsumDemo.this.textSize(32.0f);
                AwsumDemo.this.fill(0.0f, 102.0f, 153.0f);
                float t_diff = t - stage4;
                AwsumDemo.this.text("Speed: " + (this.spinSpeed + t_diff), (float)(-AwsumDemo.this.width) * 0.5f + 50.0f, (float)(-AwsumDemo.this.height) * 0.5f + 50.0f);
                AwsumDemo.this.rotateX(1.5707964f);
                AwsumDemo.this.rotateY((this.spinSpeed + t_diff) * t);
                AwsumDemo.this.scale(10.0f);
                AwsumDemo.this.scale(this.sum);
                this.drawSpinner();
            }
        }

        @Override
        public boolean isOver() {
            if (this.done) {
                this.sample.stop();
            }
            return this.done;
        }

        public void drawSpinner() {
            AwsumDemo.this.pushMatrix();
            AwsumDemo.this.scale(100.0f);
            AwsumDemo.this.shape(this.spinner, 0.0f, 0.0f);
            AwsumDemo.this.popMatrix();
        }
    }
}

