#include "demo.h"

static GLuint introVao, introVbo;

extern const GLchar *vertexshader_i, *fragmentshader_i;
extern GLint vertexshader_i_len, fragmentshader_i_len;

static struct shaderProgram introShader = {
        .vertexShadersrc = &vertexshader_i,
        .fragmentShadersrc = &fragmentshader_i,
        .vertexShadersize = &vertexshader_i_len,
        .fragmentShadersize = &fragmentshader_i_len,
        .name = "intro",
};

static float rectVertices[] = {
	0.0f, 0.0f, 0.0f, 1.0f,
	 0.0f, 1.0f, 0.0f, 0.0f,
	 1.0f, 1.0f, 1.0f, 0.0f, 

	 1.0f, 1.0f, 1.0f, 0.0f,
	 1.0f, 0.0f, 1.0f, 1.0f,
	 0.0f, 0.0f, 0.0f, 1.0f,
};

static struct attribute rectAttributes[] = {
        { .name = "position", .size = 2, .offset = 0},
        { .name = "texcoord", .size = 2, .offset = 2},
};

static struct textTexture texts[] = {
	{ .text = "Finnish summer 2017", },
	{ .text = "A p2-mate production", },
	{ .text = "Code by p2", },
	{ .text = "Sound by GoaD vs Proxeeus", },
	{ .text = "Finnish summer is short", },
	{ .text = "Have fun!", },
	{ .text = "END", },
};

static int w_width, w_height;
static int intro_limit = 4;
static int display_interval = 5000;
static int intro_offset = 0;

void setup_intro(int width, int height)
{
	int i;

	w_width = width;
	w_height = height;

	for (i = 0; i < ARRAY_SIZE(texts); i++) {
		texts[i].texID = render_text(texts[i].text, &texts[i].width,
					     &texts[i].height, FONT, GL_CLAMP_TO_EDGE);

	}

	setup_vertices(&introVao, &introVbo, rectVertices, sizeof(rectVertices));
	setup_shaders(&introShader);
	glUseProgram(introShader.shaderProgram);
	setup_attributes(&introShader, rectAttributes, ARRAY_SIZE(rectAttributes), 4);
	glUniform1i(glGetUniformLocation(introShader.shaderProgram, "image"), 0);
}

void do_loop_intro(double ts, double base_ts)
{
	GLint uniTextColour, uniProj;
	GLfloat colour;
	mat4_t proj;
	double elapsed;
	static double textBaseTs;
	int textIdx;
	struct textTexture *text;
	static int prev_textIdx = -1;

	elapsed = ts - base_ts;
	textIdx = intro_offset + (elapsed / display_interval);
	textIdx = min(textIdx, intro_limit -1);
	text = texts + textIdx;
	if (prev_textIdx != textIdx) {
		textBaseTs = ts;
		prev_textIdx = textIdx;
	}

	glUseProgram(introShader.shaderProgram);

	uniTextColour =  glGetUniformLocation(introShader.shaderProgram, "textColour");
	colour = (ts - textBaseTs) / 1000.0;
	glUniform3f(uniTextColour, colour, colour, colour);

	uniProj = glGetUniformLocation(introShader.shaderProgram, "proj"); 
        proj = m4_mul(m4_mul(m4_ortho(0.0, w_width, 0.0,w_height, 0.0, 1.0), 
			m4_translation(vec3((w_width - text->width)/2.0, (w_height - text->height)/2.0,0.0))),
			m4_scaling(vec3(text->width, text->height, 1.0)));

	glUniformMatrix4fv(uniProj, 1, GL_FALSE, &proj.m00);

	glBindVertexArray(introVao);
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, text->texID);

	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	glClearColor(0.0, 0.0, 0.0, 1.0);
        glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glDrawArrays(GL_TRIANGLES, 0, 6);
}

void do_loop_outro(double ts, double base_ts)
{
	intro_limit = ARRAY_SIZE(texts);
	display_interval = 2000;
	intro_offset = 4;
	do_loop_intro(ts, base_ts);
}
