#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif
#define PROCESSING_TEXTURE_SHADER

uniform float iGlobalTime;
uniform int waveset;
uniform vec2 iResolution;
uniform float iIntensity;

uniform sampler2D texture;

void main(void) // out vec4 fragColor, in vec2 fragCoord
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
  //if ( ){
    const int waves = 5;

    //angle, speed, frequenzy, intensity
    vec4[waves] wavearray;
    wavearray[0] = vec4(3.8, 3.14, .05, 0.75);
    wavearray[1] = vec4(0.8, 3, .055, 0.5);
    wavearray[2] = vec4(1.8, 1.5, .065, 0.25);
    wavearray[3] = vec4(0.2, 4.5, .12, 0.12);
    wavearray[4] = vec4(4.9, 5.6, .165, 0.0625);

    //float angle = 3.8;
    float x = 0.0;
    float y = 0.0;

    for(int i = 0; i < waves; i++){
        vec4 wavedata = wavearray[i];
        float angle = wavedata.x;
        float speed = wavedata.y;
        float freq = wavedata.z;
        float intensity = wavedata.w;
  	    float wave = sin(angle)*gl_FragCoord.x + cos(angle)*gl_FragCoord.y;
        x += iIntensity*intensity*abs(sin(angle))*sin(iGlobalTime*speed + wave*freq);
        y += iIntensity*intensity*abs(cos(angle))*sin(iGlobalTime*speed + wave*freq);

    }
    // gamma pow(coloc, 1.0/2.2)
    // colorspaces? tonemapping? reinhard operator? unchartedtonemapping? frame  rate not important?

    //float y = cos(iGlobalTime + fragCoord.x + fragCoord.y);

		// vec2(uv.s + x*0.05, uv.t + y*0.05)
    gl_FragColor = texture2D(texture, vec2(uv.s + x*0.005, 1.0-uv.t + y*0.005)) * vec4(vec3(min(1, 1/iIntensity)), 1.0);
  	//gl_FragColor = vec4((x+1.0)/2.0, (y+1.0)/2.0, 0.0, 1.0);
    //gl_FragColor = vec4(vec3((x+y)/2.0), 1.0);
  //}
}
