
void drawCubeMoveScene1(final float time, final float beats) {
    background(16, 16, 16);

    noStroke();
    lights();
    //strokeWeight(1);
    //stroke(cubes_color_blue1);
    int boxes = 11;
    int boxSize = (int)(width/(boxes*1.25));
    float off = (boxes+1.0)/2;
    float space = boxSize + boxSize;//*(beats%1);
    pushMatrix();
    translate(width/2, height/2, 0);
    translate( space*(beats%1), space*(beats%1), 0);
    translate(-space*off, -space*off, -space*boxes);

    for (int i = 0; i < boxes; i++) {
      translate(0, space, 0);
      pushMatrix();
      for (int j = 0; j < boxes; j++) {
        translate(space, 0, 0);
        pushMatrix();
        for (int k = 0; k < boxes; k++) {
          translate(0, 0, space);
          color fill_color = lerpColor(
              cubes_color_blue1, cubes_color_blue2, (float)(i+j+k) / (boxes*3.0));

          fill(fill_color);
          box(boxSize);
        }
        popMatrix();
      }
      popMatrix();
    }
    //box();
    popMatrix();
}

void drawCubeMoveScene2(final float time, final float beats) {
    background(16, 16, 16);

    noStroke();
    lights();
    //strokeWeight(1);
    //stroke(cubes_color_blue1);
    int boxes = 9;
    int boxSize = (int)(width/(boxes*1.25));
    float off = (boxes+1.0)/2;
    float space = boxSize + boxSize/4.0 + 20.0;//*(beats%1);
    float test = beats/8.0 * 3.14159265358979;
    pushMatrix();
    translate(width/2, height/2, 0);
    float direction = (float)moonlander.getValue("direction");
    translate( cos(test)*space*0.6, sin(test)*space*0.6, space + direction*space*(beats%1) );
    translate(-space*off, -space*off, -space*off);

    for (int i = 0; i < boxes; i++) {
      translate(0, space, 0);
      pushMatrix();
      for (int j = 0; j < boxes; j++) {
        translate(space, 0, 0);
        pushMatrix();
        for (int k = 0; k < boxes; k++) {
          translate(0, 0, space);
          color fill_color = lerpColor(
              cubes_color_blue1, cubes_color_blue2, (float)(k*3.0) / (boxes*3.0));

          fill(fill_color);
          box(boxSize);
        }
        popMatrix();
      }
      popMatrix();
    }
    //box();
    popMatrix();
}


void drawCubeSpinScene4(final float time, final float beats) {
    background(16, 16, 16);

    noStroke();
    lights();
    //strokeWeight(1);
    //stroke(cubes_color_blue1);

    int boxes = 10;//floor(beats)%10+1;
    int boxSize = (int)(width/(boxes*2.5));
    float off = (boxes+1.0)/2;
    float space = boxSize + boxSize/2;
    pushMatrix();
    translate(width/2, height/2, 0);
    rotateY(beats);
    translate(-space*off, -space*off, -space*off);

    for (int i = 0; i < boxes; i++) {
      translate(0, space, 0);
      rotateY(beats/4.0);
      pushMatrix();
      for (int j = 0; j < boxes; j++) {
        translate(space, 0, 0);
        rotateX(beats/8.0);
        pushMatrix();
        for (int k = 0; k < boxes; k++) {
          translate(0, 0, space);
          rotateZ(beats/16.0);
          color fill_color = lerpColor(
              cubes_color_blue1, cubes_color_blue2, (float)(k*3.0) / (boxes*3.0));

          fill(fill_color);
          box(boxSize);
        }
        popMatrix();
      }
      popMatrix();
    }
    //box();
    popMatrix();
}

void drawCubeSpinScene5(final float time, final float beats) {
    background(16, 16, 16);

    //strokeWeight(1);
    //stroke(cubes_color_blue1);
    noStroke();
    lights();

    int boxes = 10;//floor(beats)%10+1;
    int boxSize = (int)(width/(boxes*3.0));
    float off = (boxes+1.0)/2;
    float space = boxSize + boxSize/2.0 + boxSize/2.0*(beats%1);
    pushMatrix();
    translate(width/2, height/2, 0);
    rotateY(beats);
    translate(-space*off, -space*off, -space*off);

    for (int i = 0; i < boxes; i++) {
      translate(0, space, 0);
      rotateY(beats/4.0);
      pushMatrix();
      for (int j = 0; j < boxes; j++) {
        translate(space, 0, 0);
        rotateX(beats/8.0);
        pushMatrix();
        for (int k = 0; k < boxes; k++) {
          translate(0, 0, space);
          rotateY(beats/16.0);
          color fill_color = lerpColor(
              cubes_color_blue1, cubes_color_blue2, (float)(k*3.0) / (boxes*3.0));

          fill(fill_color);
          box(boxSize);
        }
        popMatrix();
      }
      popMatrix();
    }
    //box();
    popMatrix();
}

void drawCubeSpinScene3(final float time, final float beats) {
    background(16, 16, 16);

    noStroke();
    lights();
    //strokeWeight(1);
    //stroke(cubes_color_blue1);

    int boxes = floor(beats)%10+1;
    int boxSize = (int)(width/(boxes*4));
    float off = (boxes+1.0)/2;
    float space = boxSize + /*boxSize/8.0 +*/ boxSize/1.25*(beats%1);
    pushMatrix();
    translate(width/2, height/2, 0);
    rotateY(beats*3.14159265358979/4.0);
    translate(-space*off, -space*off, -space*off);

    for (int i = 0; i < boxes; i++) {
      translate(0, space, 0);
      pushMatrix();
      for (int j = 0; j < boxes; j++) {
        translate(space, 0, 0);
        pushMatrix();
        for (int k = 0; k < boxes; k++) {
          translate(0, 0, space);
          color fill_color = cubes_color_blue2;//lerpColor(
              //cubes_color_blue1, cubes_color_blue2, (float)(k*3.0) / (boxes*3.0));

          fill(fill_color);
          box(boxSize);
        }
        popMatrix();
      }
      popMatrix();
    }
    //box();
    popMatrix();
}

void drawCubeSpinScene1(final float time, final float beats) {
    background(16, 16, 16);

    noStroke();
    lights();
    int boxes = 3;
    int boxSize = 100;
    float space = 110;
    pushMatrix();
    translate(width/2, height/2, 0);
    //translate(-space*1.5,-space*1.5,-space*1.5);
    translate(-space*2, -space*2, -space*2);

    for (int i = 0; i < boxes; i++) {
      translate(0, space, 0);
      pushMatrix();
      for (int j = 0; j < boxes; j++) {
        translate(space, 0, 0);
        rotateY(beats);
        pushMatrix();
        for (int k = 0; k < boxes; k++) {
          translate(0, 0, space);
          color fill_color = cubes_color_blue2;

          fill(fill_color);
          box(boxSize);
        }
        popMatrix();
      }
      popMatrix();
    }
    //box();
    popMatrix();
}

void drawCubeSpinScene2(final float time, final float beats) {
    background(16, 16, 16);

    noStroke();
    lights();
    int boxes = 3;
    int boxSize = 100;
    float space = 110;
    pushMatrix();
    translate(width/2, height/2, 0);
    //translate(-space*1.5,-space*1.5,-space*1.5);
    translate(-space*2, -space*2, -space*2);

    for (int i = 0; i < boxes; i++) {
      translate(0, space, 0);
      pushMatrix();
      for (int j = 0; j < boxes; j++) {
        translate(space, 0, 0);
        pushMatrix();
        for (int k = 0; k < boxes; k++) {
          translate(0, 0, space);
          rotateY(beats);
          color fill_color = cubes_color_blue2;

          fill(fill_color);
          box(boxSize);
        }
        popMatrix();
      }
      popMatrix();
    }
    //box();
    popMatrix();
}