import moonlander.library.*;
import ddf.minim.*;

Moonlander moonlander;
PShader shader;

final int bpm = 140;
final int rows_per_beat = 4;

// offset of Dub Zap song to the beat
// calculated in audacity
final float song_offset_seconds = -0.117;

PImage floor_texture;

PImage intro_header;
PImage intro_createdby;
PImage intro_wno;
PImage intro_qazhax;
PImage intro_locketeerian;
PImage intro_music;
PImage fake_scene;

void setup() {
    //size(720, 480, P3D);
    
  moonlander = Moonlander.initWithSoundtrack(this,
        "Gunnar_Olsen-Dub_Zap_fadeout.wav", bpm, rows_per_beat);
    // ENABLE THESE FOR FINAL RELEASE
    fullScreen(P3D);
    noCursor();

    floor_texture = loadImage("floor.png");
    intro_header = loadImage("title_header.png");
    intro_createdby = loadImage("title_createdby.png");
    intro_wno = loadImage("title_wno.png");
    intro_qazhax = loadImage("title_qazhax.png");
    intro_locketeerian = loadImage("title_locketeerian.png");
    intro_music = loadImage("title_music.png");
    fake_scene = loadImage("fakeshadertex.png");

    frameRate(60);


    shader = loadShader("waves.glsl","wavevert.glsl");
    // Set shadertoy uniforms
    shader.set("iResolution", (float)width, (float)height);

    untzReset();

    
    moonlander.start();
}

void draw() {
    moonlander.update();

    // time in seconds
    float time = (float)moonlander.getCurrentTime() + song_offset_seconds;

    // calculate number of beats since start of demo
    float beats = (float)moonlander.getCurrentRow() / rows_per_beat;

    int scene = moonlander.getIntValue("scene");

    if (scene == 1) {
        drawCubeScene(time, beats);
    } else if (scene == 2) {
        drawCubeScene2(time, beats);
    } else if (scene == 3) {
        drawCubeMoveScene1(time, beats);
    } else if (scene == 4) {
        drawCubeSpinScene3(time, beats);
    } else if (scene == 5) {
        drawCubeSpinScene1(time, beats);
    } else if (scene == 6) {
        drawCubeSpinScene2(time, beats);
    } else if (scene == 7) {
        drawIntroScene(time, beats);
    } else if (scene == 8 ) {
        drawCubeSpinScene4(time, beats);
    } else if (scene == 9 ) {
        drawCubeMoveScene2(time, beats);
    } else if (scene == 10 ) {
        drawCubeSpinScene5(time, beats);
    } else if (scene == 11 ) {
        drawCubeScene4(time, beats);
    } else if (scene == 12 ) {
        drawShaderScene(time, beats);
    } else if (scene == 999) {
        drawBlackScene(time, beats);
    } else if (scene == 666) {
        exit();
    }

}