// for use with the untz() and untzReset()
float untzCounter = 0;
float untz_xMax = random(-1, 1);
float untz_yMax = random(-1, 1);
float untz_zMax = random(-1, 1);
float untz_x = 0;
float untz_y = 0;
float untz_z = 0;

void untzReset(){

  // randomize a orthogonal vector with components and normalise it

  untz_xMax = random(-1, 1);
  untz_yMax = random(-1, 1);
  untz_zMax = random(-1, 1);

  float scaleDown = sqrt(sq(untz_xMax) + sq(untz_yMax) + sq(untz_zMax));
  untz_xMax = untz_xMax / scaleDown;
  untz_yMax = untz_yMax / scaleDown;
  untz_zMax = untz_zMax / scaleDown;
  // advance the counter for the oscillation
  untzCounter = 0;
}

void untz(float xx, float yy, float zz, float dampening, float maxAmplitude){

  untzCounter = untzCounter + 1;
  float temp = maxAmplitude * exp(-untzCounter / dampening)*sin(untzCounter);
  untz_x = xx + untz_xMax * temp;
  untz_y = yy + untz_yMax * temp;
  untz_z = zz + untz_zMax * temp;

}