
// grid effect

int block_w = 20;
int block_h = 20;
void drawGrid(float t, float bass, int type) {
  pushMatrix();
  camera(480, 270, 490, 480, 270, 0, 0, 1, 0);
  noLights();
  int nx = 960 / block_w;
  int ny = 540 / block_h;
  float cx = 0.355f;
  float cy = 0.28f;
  for (int iy = 0; iy < ny; iy++) {
    for (int ix = 0; ix < nx; ix++) {
      int px = (int)(ix - nx*cx);
      int py = (int)(iy - ny*cy);
      println(type);
      if (type < 1) {
        plainBlocks(px, py, ix * block_w, iy * block_h, bass);
      } else if (type == 1) {
        colorBlocks(px, py, ix * block_w, iy * block_h, bass, t);
      } else if (type == 2) {
        plainSpheres(px, py, ix * block_w, iy * block_h, bass);
      } else { 
        plainRotatingBlocks(px, py, ix * block_w, iy * block_h, bass);
      }
    }
  }
  popMatrix();
}

void plainBlocks(int ix, int iy, float x, float y, float bass) {
  float size = 1500.0 / (100.0 + ix*ix + iy*iy - bass);
  pushMatrix();
  translate(x, y, 1);
  box(size);
  popMatrix();
}

float b_rot = 0.f;
void plainRotatingBlocks(int ix, int iy, float x, float y, float bass) {
  float size = 5.0 + 1000.0 / (100.0 + ix*ix + iy*iy - bass);
  pushMatrix();
  translate(x, y, 1);
  b_rot += bass*0.000003f;
  rotate(b_rot);
  box(size);
  popMatrix();
}

void plainSpheres(int ix, int iy, float x, float y, float bass) {
  float size = 1.0 + 1000.0 / (100.0 + ix*ix + iy*iy - bass);
  pushMatrix();
  translate(x, y, 1);
  sphere(size);
  popMatrix();
}

// t = rotation angle
void colorBlocks(int ix, int iy, float x, float y, float bass, float t) {
  float size = 2000.0 / (100.0 + ix*ix + iy*iy - bass);
  float r = sqrt(ix*ix + iy*iy);
  float angle = atan2(iy, ix);
  float curl = 0.003f * bass;
  float h2 = 0.001f * bass + 1.0f * t + angle + curl * sin(r);
  float h = h2 - (int)h2;
  colorMode(HSB, 1.0f);
  pushMatrix();
  fill(h, 0.8, 1);
  translate(x, y, 1);
  box(size);
  popMatrix();
  colorMode(RGB, 256.0f);  // restore
}