
//int NUM=45*20*0;
final int N =100;
//float rad=4.0/((float)N);
float [][]ARR = new float[N][N];
float [][]ARRVEL = new float[N][N];
PVector [][] norm = new PVector[N][N];
    
PImage img,img_mask,tex;

boolean FILL=true;

int R = 10000;
PVector[] rockets= new PVector[R];
float [] init_time = new float[R];
color [] rocket_col = new color[R];

float rocket_start=25;
float rocket_delay=10;
float rocket_flytime=10;
float cube_start=45;
float shadow_start=75;
float cube_stop=114;


void setupKuutamo()
{
randomSeed(123124);
img = loadImage("cloud.jpg");
img_mask = loadImage("cloud_mask.jpg");
tex = createImage(img.width,img.height,ARGB);

for(int k =0;k<img.pixels.length;k++)
{
color col = img.pixels[k];
color mask = img_mask.pixels[k];
float c = red(col);
float alpha = red(mask);
tex.pixels[k]=color(c/2,alpha*1.5);//color(c,alpha*1.75);
}

for(int k =0;k<R;k++)
{ 
float x=2000;
float y=2000;
while(sqrt(x*x+y*y)>400)
{
 x= random(-400,400);
 y = random(-400,400);
}
rockets[k]=new PVector(x,y,0);
init_time[k]=random(rocket_start,rocket_start+rocket_delay);
rocket_col[k]=color(255);
}

//tex.mask(tex);

for(int i =0;i<N;i++)
{
for(int j =0;j<N;j++)
{
 float x = ((float)i)/N;
 float z = ((float)j)/N;
ARR[i][j]=0.1*sin((x+2*z)*PI*4)*cos((z-x)*6*PI)+0.2*cos(z*PI*2)+random(-0.01,0.01);
ARRVEL[i][j]=0;
}}
}

void drawKuutamo(float t, float bass, int phase)
{


update();

noStroke();
if(t<=shadow_start) FILL = true;
else if(t<cube_stop)
{
FILL=false;
stroke(255);
strokeWeight(1);
noFill();
}
else
{
FILL=true;
}


camera(0,-0.3+0.025*sin(t*2)+0.025,-1,0,-0.225+0.025*sin(t*2)+0.025,0,0,1,0);
perspective(PI/4.0,((float)W)/((float)H),0.01,500);
textureMode(NORMAL);

lightSpecular(255,255,200);
pointLight(127,255,255,3,-5,10);
ambientLight(255,255,255);

background(0,10,30);

pushMatrix();
emissive(255,255,225);//(220,220,200);
specular(0,0,0);
ambient(0);
translate(22,-14,80);
sphereDetail(20);
sphere(8.0);
popMatrix();



for(int k =0;k<R;k++)
{
if (t>init_time[k]&&t<init_time[k]+rocket_flytime)
{
PVector moon = new PVector(22,-14,80);
PVector vec = rockets[k];
vec.lerp(moon,(t-init_time[k])/rocket_flytime);

pushMatrix();
emissive(rocket_col[k]);//(220,220,200);
specular(0,0,0);
ambient(0);
translate(vec.x,vec.y,vec.z);
sphereDetail(2);
sphere(0.1);
popMatrix();
}
}

if(t>cube_start&&t<cube_stop) cube(phase,new PVector(22,-14,80),0,4.0+bass/20,(t-cube_start)*2.5,t*0.1);

//noFill();

if(FILL==true&&phase!=3&&phase!=4)
{
emissive(0,0,0);
ambient(100);
fill(0);
beginShape(QUADS);
texture(tex);
vertex(48,4,56    ,1,0);
vertex(48,-20,40    ,1,1);
vertex(-48,-20,40    ,0,1);
vertex(-48,4,56   ,0,0);
endShape();
}

// debug pump for dev without music
//for(int i =0; i<15;i++)
//{
//if(NUM==i*20+300) pump(random(-0.5,0.5),random(-0.5,0.5),1000,random(0.4,1.0));
//}







ambient(0);
emissive(0);
specular(200);
shininess(30);
color fillcol = color(0,100,200);
color fillcol2 = color(0,65,65);

for(int i =0;i<N;i++)
{
float x_ = (((float)i)/N*2-1)*4;
float x = (((float)(i+1))/N*2-1)*4;
int ii = (i+1)%N;
for(int j =0;j<N;j++)
{
float z_ = (((float)j)/N*2-1)*3;
float z = (((float)(j+1))/N*2-1)*3;
int jj = (j+1)%N;
noFill();
beginShape(QUADS);
if(FILL==true)fill(lerpColor(fillcol,fillcol2,ARRVEL[i][j]*10));
normal(norm[i][j].x,norm[i][j].y,norm[i][j].z);
vertex(x_,-ARR[i][j],1.5+z_);

if(FILL==true)fill(lerpColor(fillcol,fillcol2,ARRVEL[i][jj]*10));
normal(norm[i][jj].x,norm[i][jj].y,norm[i][jj].z);
vertex(x_,-ARR[i][jj],1.5+z);

if(FILL==true)fill(lerpColor(fillcol,fillcol2,ARRVEL[ii][jj]*10));
normal(norm[ii][jj].x,norm[ii][jj].y,norm[ii][jj].z);
vertex(x,-ARR[ii][jj],1.5+z);

if(FILL==true)fill(lerpColor(fillcol,fillcol2,ARRVEL[ii][j]*10));
normal(norm[ii][j].x,norm[ii][j].y,norm[ii][j].z);
vertex(x,-ARR[ii][j],1.5+z_);
endShape();

}
}


println(frameRate);
}



void update()
{
for(int i =0;i<N;i++)
{

for(int j =0;j<N;j++)
{
ARRVEL[i][j]+=0.25*(ARR[(i-1+N)%N][j]+ARR[(i+1)%N][j]+ARR[i][(j+1)%N]+ARR[i][(j-1+N)%N]-4*ARR[i][j]);
}}
for(int i =0;i<N;i++)
{

for(int j =0;j<N;j++)
{
ARR[i][j]+=ARRVEL[i][j]*0.05;
if(abs(ARR[i][j])>0.2)ARR[i][j]*=0.99;
//if(abs(ARRVEL[i][j])>1)ARRVEL[i][j]*=0.99;
}}

for(int i =0;i<N;i++)
{
int ii = (i+1)%N;
int ii_ = (i-1+N)%N;

for(int j =0;j<N;j++)
{
int jj = (j+1)%N;
int jj_ = (j-1+N)%N;
norm[i][j]=new PVector((ARR[ii][j]-ARR[ii_][j]),0.35,ARR[i][jj]-ARR[i][jj_]);
norm[i][j].normalize();
}}

//if(NUM%5==0)
//{
int texW = tex.width;
int texH = tex.height;
for(int l =0;l<texH;l++)
{
int index0 = l*texW;
color temp = tex.pixels[index0];
for(int k =0;k<texW-1;k++)
{
tex.pixels[index0+k]=tex.pixels[index0+k+1];
}
tex.pixels[index0+texW-1]=temp;
}
tex.updatePixels();
//}
}


void pump(float x0,float y0,float rad,float amp)
{
for(int i =0;i<N;i++)
{
for(int j =0;j<N;j++)
{
 float x = ((float)i)/N*2-1-x0;
 float z = ((float)j)/N*2-1-y0;
ARR[i][j]+=amp/(1+(x*x+z*z)*rad);
}}

}

void cube(int theme,PVector cen,int D,float rad,float delta,float t)
{
 // /float re = red(col);
 // float gr = green(col);
 // float bl = blue(col);
color col=color(0);

if(theme==9)
{
if(D<2)  col= color(55,0,55);
if(D==3) col= color(55,0,0);
if(D==4) col= color(0,55,55);
}
if(theme==8)
{
if(D<2)  col= color(200,255,255);
if(D==3) col= color(65);
if(D==4) col= color(255,255,200);
}
if(theme==4)
{
colorMode(HSB,100);
float x = cen.y*0.015;
x -= floor(x);
x*=100;
col= color(x,80,100);
colorMode(RGB,255);
}
if(theme==3)
{
colorMode(HSB,100);
float x = cen.x*0.025;
x -= floor(x);
x*=100;
col= color(x,100,100);
colorMode(RGB,255);
}
//if(theme==3)col= color(100,100,100);

pushMatrix();
if(FILL==true)emissive(0,0,0);//(220,220,200);
if(FILL==true)fill(col);
specular(0,0,0);
if(FILL==true)ambient(127);
translate(cen.x,cen.y,cen.z);
box(rad,rad,rad);
popMatrix();
if(D<4)
{
PVector vec1 = new PVector(delta,0,0);
vec1 = rotate(vec1,t,PI/3);
cube(theme,PVector.add(cen,vec1),D+1,rad*0.7,delta,t);

PVector vec2 = new PVector(-delta,0,0);
vec2 = rotate(vec2,-t,PI/2);
cube(theme,PVector.add(cen,vec2),D+1,rad*0.7,delta,t);

PVector vec3 = new PVector(0,delta,0);
vec3 = rotate(vec3,-PI/2,-t);
cube(theme,PVector.add(cen,vec3),D+1,rad*0.7,delta,t*1.5);

PVector vec4 = new PVector(0,-delta,0);
vec4 = rotate(vec4,PI/3,t);
cube(theme,PVector.add(cen,vec4),D+1,rad*0.7,delta,t*1.5);

PVector vec5 = new PVector(0,0,delta);
vec5 = rotate(vec5,-PI/3,t);
cube(theme,PVector.add(cen,vec5),D+1,rad*0.7,delta,0.5*t);

PVector vec6 = new PVector(0,0,-delta);
vec6 = rotate(vec6,-PI/2,-t);
cube(theme,PVector.add(cen,vec6),D+1,rad*0.7,delta,0.5*t);
//cube(new PVector(cen.x,cen.y+rad*3,cen.z),D+1,rad*0.7);
//cube(new PVector(cen.x,cen.y-rad*3,cen.z),D+1,rad*0.7);
//cube(new PVector(cen.x,cen.y,cen.z+rad*3),D+1,rad*0.7);
//cube(new PVector(cen.x,cen.y,cen.z-rad*3),D+1,rad*0.7);
}
}

PVector rotate(PVector vec,float rot_y,float rot_z)
{
PVector vec1 = new PVector(vec.x*cos(rot_y)-vec.z*sin(rot_y),vec.y,vec.z*cos(rot_y)+vec.x*sin(rot_y));
return new PVector(vec1.x*cos(rot_z)-vec1.y*sin(rot_z),vec1.y*cos(rot_z)+vec1.x*sin(rot_z),vec1.z);
}