
class copterDemo extends demoBase {
  
  
  PShape s;
  PShape spinner;

  float startTime;
  SoundFile sample;
  float rotation = -90;
  float rotAcc = 0.5;
  float copterZ = -210;
  float copAcc = 0.2;
  
  public copterDemo(SoundFile sample, PShape s, PShape spinner) {
    
    startTime = -1;
    this.sample = sample;
    this.s = s;
    this.spinner = spinner;
  }
  void playDemo() {
    if(startTime == -1) {
      startTime = millis()/1000.0;
      sample.loop();
    }
    
  background(0);
  lights();  
  translate(width*0.5,height*0.5,0);
  
  //rotateY(-PI/ 4);
  rotateX(-0.1*PI);
  
  // MEH NEED timeDelta
  if(rotation >= -395){
    rotateY(radians(rotation));
    rotation-=rotAcc;  
    rotAcc+=0.005;
  }
  else {
    rotateY(radians(rotation));
    copterZ+=copAcc;
    copAcc+=0.1;
  }
    
  translate(0,0,copterZ);
  drawChoppa();
  
  }
  
  void drawChoppa () {
    
  float t = millis()/1000.0;
  pushMatrix();
  translate(0,100,0);
  scale(15);
  rotateZ(PI);
  shape(s, 0, 0);
  popMatrix();
  
  pushMatrix();
  translate(0,-15,40);
  scale(20);
  rotateX(PI);
  rotateY(5*PI*t);
  shape(spinner, 0, 0);
  popMatrix();
  
  pushMatrix();
  translate(10,-10,-210);
  scale(8);
  rotateZ(PI/2); 
  rotateY(5*PI*t);
  shape(spinner, 0, 0);
  popMatrix();
  }
  boolean isOver(){
    boolean result = false;
    if(millis()/1000.0 - startTime > 7) {
      sample.stop();
      result = true;
    }
    return result;
  }
}