var vertexShaderText =
[
'precision mediump float;',
'',
'attribute vec3 vertPosition;',
'attribute vec3 vertColor;',
'varying vec3 fragColor;',
'uniform mat4 mWorld;',
'uniform mat4 mView;',
'uniform mat4 mProj;',
'',
'void main()',
'{',
'fragColor = vertColor;',
'gl_Position = mProj * mView * mWorld * vec4(vertPosition, 1.0);',
'}'
].join('\n');

var fragmentShaderText = 
[
'precision mediump float;',
'',
'varying vec3 fragColor;',
'void main()',
'{',
'gl_FragColor = vec4(fragColor, 1.0);',
'}'
].join('\n');

var gl;

var InitDemo = function (){
	console.log(' this is working !');
	
	var player = new CPlayer();
	player.init(song);
	while (!player.generate()){};
	var wave = player.createWave();
	audio = document.createElement("audio");
	audio.src = URL.createObjectURL(new Blob([wave],{type: "audio/wav"}));
	
	
	var canvas = document.getElementById('Demo');
	gl = canvas.getContext('webgl');
	canvas.width = document.body.clientWidth; //document.width is obsolete
    canvas.height = document.body.clientHeight; //document.height is obsolete
	gl.enable(gl.DEPTH_TEST);
	gl.enable(gl.CULL_FACE);
	gl.frontFace(gl.CCW);
	gl.cullFace(gl.BACK);
	
	if(!gl){
		console.log('stage two, works with experimental');
		gl = canvas.getContext('experimental-webgl');
	}
	
	if(!gl){
		alert('browser does NOT support webGL');
	}
	
	gl.clearColor(0.0, 0.5, 0.2, 1.0);
	gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
	
	var vertexShader = gl.createShader(gl.VERTEX_SHADER);
	var fragmentShader = gl.createShader(gl.FRAGMENT_SHADER);
	
	gl.shaderSource(vertexShader, vertexShaderText);
	gl.shaderSource(fragmentShader, fragmentShaderText);
	
	gl.compileShader(vertexShader);
	if(!gl.getShaderParameter(vertexShader, gl.COMPILE_STATUS)){
		console.error('ERROR compiling vertexShader', gl.getShaderInfoLog(vertexShader));
		return;
	}
	
	gl.compileShader(fragmentShader);
	if(!gl.getShaderParameter(fragmentShader, gl.COMPILE_STATUS)){
		console.error('ERROR compiling fragmentShader', gl.getShaderInfoLog(fragmentShader));
		return;
	}
	
	var program = gl.createProgram();
	gl.attachShader(program, vertexShader);
	gl.attachShader(program, fragmentShader);
	gl.linkProgram(program);
	if(!gl.getProgramParameter(program, gl.LINK_STATUS)){
		console.error('ERROR linking program',gl.getProgramInfoLog(program));
		return;
		
	}
	
	gl.validateProgram(program);
	if(!gl.getProgramParameter(program, gl.VALIDATE_STATUS)){
		console.error('ERROR validating program',gl.getProgramInfoLog(program));
		return;
	}
	
	//
	// create buffer
	//
	
	var boxVertices = 
	[ // X, Y, Z           R, G, B
		// Top
		-1.0, 1.0, -1.0,   0.5, 0.5, 0.5,
		-1.0, 1.0, 1.0,    0.5, 0.5, 0.5,
		1.0, 1.0, 1.0,     0.5, 0.5, 0.5,
		1.0, 1.0, -1.0,    0.5, 0.5, 0.5,

		// Left
		-1.0, 1.0, 1.0,    0.75, 0.25, 0.5,
		-1.0, -1.0, 1.0,   0.75, 0.25, 0.5,
		-1.0, -1.0, -1.0,  0.75, 0.25, 0.5,
		-1.0, 1.0, -1.0,   0.75, 0.25, 0.5,

		// Right
		1.0, 1.0, 1.0,    0.25, 0.25, 0.75,
		1.0, -1.0, 1.0,   0.25, 0.25, 0.75,
		1.0, -1.0, -1.0,  0.25, 0.25, 0.75,
		1.0, 1.0, -1.0,   0.25, 0.25, 0.75,

		// Front
		1.0, 1.0, 1.0,    1.0, 0.0, 0.15,
		1.0, -1.0, 1.0,    1.0, 0.0, 0.15,
		-1.0, -1.0, 1.0,    1.0, 0.0, 0.15,
		-1.0, 1.0, 1.0,    1.0, 0.0, 0.15,

		// Back
		1.0, 1.0, -1.0,    0.0, 1.0, 0.15,
		1.0, -1.0, -1.0,    0.0, 1.0, 0.15,
		-1.0, -1.0, -1.0,    0.0, 1.0, 0.15,
		-1.0, 1.0, -1.0,    0.0, 1.0, 0.15,

		// Bottom
		-1.0, -1.0, -1.0,   0.5, 0.5, 1.0,
		-1.0, -1.0, 1.0,    0.5, 0.5, 1.0,
		1.0, -1.0, 1.0,     0.5, 0.5, 1.0,
		1.0, -1.0, -1.0,    0.5, 0.5, 1.0,
	];

	var boxIndices =
	[
		// Top
		0, 1, 2,
		0, 2, 3,

		// Left
		5, 4, 6,
		6, 4, 7,

		// Right
		8, 9, 10,
		8, 10, 11,

		// Front
		13, 12, 14,
		15, 14, 12,

		// Back
		16, 17, 18,
		16, 18, 19,

		// Bottom
		21, 20, 22,
		22, 20, 23
	];

	
	var boxVertexBufferObject = gl.createBuffer();
	gl.bindBuffer(gl.ARRAY_BUFFER, boxVertexBufferObject);
	gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(boxVertices), gl.STATIC_DRAW);
	
	var boxIndexBufferObject = gl.createBuffer();
	gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, boxIndexBufferObject);
	gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Uint16Array(boxIndices), gl.STATIC_DRAW)
	
	var positionAttribLocation = gl.getAttribLocation(program, 'vertPosition');
	var colorAttribLocation = gl.getAttribLocation(program, 'vertColor');
	gl.vertexAttribPointer(
		positionAttribLocation, //attribute location
		3, // number of elements per attribute 34:30
		gl.FLOAT,
		gl.false,
		6 * Float32Array.BYTES_PER_ELEMENT, //size of individual vertex 
		0 //offset single vertex -> to this attribute
	)
	
	gl.vertexAttribPointer(
		colorAttribLocation, //attribute location
		3, // number of elements per attribute 34:30
		gl.FLOAT,
		gl.false,
		6 * Float32Array.BYTES_PER_ELEMENT, //size of individual vertex 
		3 * Float32Array.BYTES_PER_ELEMENT //offset single vertex -> to this attribute
	)
	
	gl.enableVertexAttribArray(positionAttribLocation);
	gl.enableVertexAttribArray(colorAttribLocation);
	
	//Tell open GL state machine which program should be active
	gl.useProgram(program);
	
	var matWorldUniformLocation = gl.getUniformLocation(program, 'mWorld' );
	var matViewUniformLocation = gl.getUniformLocation(program, 'mView' );
	var matProjUniformLocation = gl.getUniformLocation(program, 'mProj' );
	
	var worldMatrix = new Float32Array(16);
	var viewMatrix = new Float32Array(16);
	var projMatrix = new Float32Array(16);
	mat4.identity(worldMatrix);
	mat4.lookAt(viewMatrix,[0,0,-30],[0,0,0],[0,1,0]); // kameran sijainti ===========================!!!!!!
	mat4.perspective(projMatrix, glMatrix.toRadian(45),canvas.width / canvas.height , 0.1 , 1000.0);//20 min tuto 2
	
	gl.uniformMatrix4fv(matWorldUniformLocation, gl.FALSE, worldMatrix);
	gl.uniformMatrix4fv(matViewUniformLocation, gl.FALSE, viewMatrix);
	gl.uniformMatrix4fv(matProjUniformLocation, gl.FALSE, projMatrix);
	
	var xRotationMatrix = new Float32Array(16);
	var yRotationMatrix = new Float32Array(16);
	
	//
	// main render loop
	//
	var identityMatrix = new Float32Array(16);
	mat4.identity(identityMatrix);
	var angle = 0;
	var move = [0,0,0];
	
	var t0 = 0;
	var t1 = 0;
	var tdif = 0;
	var timer = 0;
	var rand = 30;
	var red = 0.0;
	var green = 0.5;
	var blue = 0.2;
	var lap = 0;
	
	function getRandomInt(min, max) {
		min = Math.ceil(min);
		max = Math.floor(max);
		return Math.floor(Math.random() * (max - min)) + min;
	}
	
	function getRandom() {
		return Math.random();
	}
	
	var loop = function(){
		if(t1 == 0){
			t1 = performance.now();
			requestAnimationFrame(loop);
			return;
		}
		t0 = performance.now();
		tdif  = t0 - t1; 
		t1 = t0;
		timer = timer + tdif;
		
		angle = tdif / rand  / 6 * 2 * Math.PI;
		move = [- tdif/7 ,tdif/7 ,0];
		//mat4.rotate(yRotationMatrix, identityMatrix, angle, [0,1,0]); 
		//mat4.rotate(xRotationMatrix, identityMatrix, angle, [1,0,0]);
		mat4.scalar.translate(worldMatrix, worldMatrix, move);
		 
		//mat4.scalar.translate(worldMatrix, worldMatrix, move);
		mat4.rotate(worldMatrix, worldMatrix, angle, [1,0,1]);
		mat4.rotate(worldMatrix, worldMatrix, angle, [0,1,1]);
		
		if (timer > 3000){
			
			console.log('this resets!');
			worldMatrix = new Float32Array(16);
			mat4.identity(worldMatrix);
			timer = 0;
			rand = getRandomInt(15, 35);
			red = getRandom();
			green = getRandom();
			blue = getRandom();
			if(red > 0.85 || green > 0.85 || blue > 0.85)audio.play();
			lap = lap + 1;
			
		}
		if (lap > 10){
			worldMatrix = new Float32Array(16);
			mat4.identity(worldMatrix);
			mat4.scalar.translate(worldMatrix, identityMatrix, [100,100,0]);
			
			gl.uniformMatrix4fv(matWorldUniformLocation, gl.FALSE, worldMatrix);
			
			gl.clearColor(0.0, 0.0, 0.0, 1.0);
			gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
			gl.drawElements(gl.TRIANGLES, boxIndices.length, gl.UNSIGNED_SHORT, 0); 
			
			
			
			return;
		}
		gl.uniformMatrix4fv(matWorldUniformLocation, gl.FALSE, worldMatrix);
		
		gl.clearColor(red, green, blue, 1.0);
		gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
		gl.drawElements(gl.TRIANGLES, boxIndices.length, gl.UNSIGNED_SHORT, 0); 
		
		requestAnimationFrame(loop);
	};
	requestAnimationFrame(loop);
	
	gl.clearColor(1.0, 1.0, 1.0, 1.0);
	gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
	
};