/**
  * Democompo entry for Instanssi 2017
  * by em (Matti Eskelinen)
*/  
import moonlander.library.*;
import ddf.minim.*;
import hypermedia.net.*;

int port = 9909;
String ip = "192.168.69.115";
UDP valot;
int conn = 0;

Moonlander moonlander;
PFont titleFont;
PFont credFont;
PShader metab;

void setup(){
 
  valot = new UDP(this, port);
  //size(640,480,P2D);
  surface.setTitle("SIKI:O"); 
  fullScreen();
  noCursor();
  
  /*
    "Ave Marimba" Kevin MacLeod (incompetech.com)
    Licensed under Creative Commons: By Attribution 3.0 License
    http://creativecommons.org/licenses/by/3.0/
  */
  moonlander = Moonlander.initWithSoundtrack(this, "AveMarimba.mp3", 70, 4);
  moonlander.start();
  titleFont = createFont("Datalegreya-Gradient.otf",144);
  credFont = createFont("Datalegreya-Gradient.otf",72);
}

void draw(){
  moonlander.update();
  int effect = (int)(moonlander.getValue("effect"));
  int title = (int)(moonlander.getValue("title"));
  float fadeout = (float)moonlander.getValue("fadeout");
  float siittiox = (float)moonlander.getValue("siittiox");
  float blur = (float)moonlander.getValue("blur");
  float dna = (float)moonlander.getValue("dna");
  float split = (float)moonlander.getValue("split");
  float cam = (float)moonlander.getValue("cam");
  float dPos = (float)moonlander.getValue("dPos");
  float cols = (float)moonlander.getValue("cols");
  float cshift = 30*(0.5*blur);
  int nl = 28;
  for (int i = 0; i<nl; i++){
    byte[] packet = {
      1, // versio
      0, byte(101), byte(109), 0, // e m
      1, // efektin tyyppi
      byte(i), // Valon indeksi
      0,
      byte(225),
      byte(180-5*cshift),
      byte(180-5*cshift)
     };
    valot.send(packet, ip);
  }
  
  switch(effect){
    case 0:
      noStroke();
      background(40);
      fill(240);
      rectMode(CORNER);
      rect(0, 0, width,height/2);
      
      // Siittio
      fill(40);
      int sd = height/20;
      ellipse(width/2, siittiox*(height/2)+sd, sd, sd*1.2);
      float shd = sd/4.0;
      float shx;
      for (int i = 0; i < 16; i++){
        shx = siittiox*(height/2)+sd/2-(i*sd/8);
        ellipse(width/2+sin(0.3*shx), shx, shd, shd);
        shd = shd*0.9;
      }
      
      // Munasolu
      fill(240, 240-cshift, 240-cshift);
      ellipse(width/2, height+0.5*(width-height), fadeout*width, fadeout*width);
      
      fill(40);
      if (title==1){
        textSize(height/6);
        
        textFont(titleFont);
        textAlign(CENTER);
        text("SIKI:O",width/2, height/2);
      }
      
      filter(BLUR, blur);
      
      return;
    case 1:
      int pairs = 64*4;
      float dw = width*4/pairs;
      float phi;
      float pdiff = 1.5*PI;
      float zoom = 1 - 0.875*(1-cam);
      
      background(240, 240-cshift, 240-cshift);
      rectMode(CORNER);
      pushMatrix();
      rotate(-0.45*cam);
      translate(cam*(-width/4),cam*(height/5));
      noStroke();
      for(int k = -2; k < 3; k++){
        for(int i = 0; i < 2*pairs; i=i+2){
          phi = dna+(float)(0.15*i);
          fill(120+100*sin(0.5*phi),100,50);
          rect(
            zoom * (dw*i),
            height*0.5 + (k * height/3) + zoom *((int)(height*0.05*sin(phi)-height*split*(pairs/(pairs-i+1)))), 
            zoom * dw,
            zoom * (int)(height*0.1*sin(phi)));
          fill(100, 120+100*sin(0.5*(phi+pdiff)), 50);
          rect(
            zoom * (dw*(i+1)),
            height*0.5 + (k * height/3) + zoom *((int)(height*0.05*sin(phi+pdiff))+height*split*(pairs/(pairs-i+1))),
            zoom * dw, 
            zoom *(int)(height*0.1*sin(phi+pdiff)));
        }
      }
      popMatrix();
      fill(240, 240-cshift, 240-cshift, fadeout);
      rect(0,0,width, height);
      return;
    case 2:
      background(240, 240-cshift, 240-cshift);
      ellipseMode(CENTER);
      fill(40);
      stroke(255);
      strokeWeight(10);
      hint(ENABLE_STROKE_PURE);
      int offset = width/4;
      for (int i=0; i<=cols; i++){
        ellipse(width/2 + min(i,1)*offset, height/2, dPos*width/5, (2-dPos)*width/5);
        offset = -offset;
      }
      
      textFont(credFont);
      textAlign(CENTER);
      textSize(height/16);
      fill(40);
      if(title>0){
        text("Music: incompetech.com", width*0.5, height*0.75);
      }
      if(title>1){
          text("Code: em", width*0.25, height*0.25);
      }
      if(title>2){
          text("GFX: em", width*0.75, height*0.25);
      }
      
      fill(240, 240-cshift, 240-cshift, fadeout);
      noStroke();
      rect(0,0,width, height);
      
      char[] inst = {'i','n','s','t','a','n','s','s','i',' ','2','0','1','7'};
      
      textSize(height/8);
      if(title>3){
        for (int i = 0; i<14; i++){
            fill(40+215*sin(dna+1.1*i));
            text(inst, i, i+1, width*0.1+i*width/16, height*0.5);
        }
      }
      
      return;
    case 3:
        exit();
  }
  
}