@VERTEX
#version 410
precision highp float;
uniform mat4 projection_matrix;
uniform mat4 modelview_matrix;
uniform mat4 u_joint_matrix[3];
layout(location = 0) in vec3 in_position;
layout(location = 1) in vec3 in_normal;
layout(location = 2) in vec2 in_texCoord0;

layout(location = 3) in vec4 in_weight;
layout(location = 4)in vec4 in_joint;

out vec3 normal;
out vec2 texCoord0;

float rand(float n){return fract(sin(n) * 43758.5453123);}

void main(void)
{
	//works only for orthogonal modelvie
	mat4 skinMatrix = in_weight.x * u_joint_matrix[int(in_joint.x)]+
	in_weight.y* u_joint_matrix[int(in_joint.y)]+
	in_weight.z* u_joint_matrix[int(in_joint.z)]+
	in_weight.w* u_joint_matrix[int(in_joint.w)];

	normal = (modelview_matrix *skinMatrix* vec4(in_normal, 0)).xyz;
	texCoord0 = in_texCoord0;


	vec3 position = in_position;


	gl_Position = projection_matrix * modelview_matrix * skinMatrix* vec4(position, 1);
};

@FRAGMENT
#version 410
precision highp float;
const vec3 ambient = vec3(0.3, 0.3, 0.3);
const vec3 lightVecNormalized = normalize(vec3(2.0, 0.5, 0.4));
const vec3 lightColor = vec3(1.0, 1.0, 1.0);
in vec3 normal;
in vec2 texCoord0;
uniform sampler2D tex; 

out vec4 out_frag_color;
void main(void)
{
   float diffuse = clamp(dot(lightVecNormalized, normalize(normal)), 0.0, 1.0);
   out_frag_color = vec4(ambient + diffuse * lightColor, 1.0)* texture(tex, texCoord0);

 //  out_frag_color = data;
   //out_frag_color= data;
};
