@VERTEX
#version 410
precision highp float;
uniform mat4 projection_matrix;
uniform mat4 modelview_matrix;
uniform mat4 u_joint_matrix[3];
layout(location = 0) in vec3 in_position;
layout(location = 1) in vec3 in_normal;
layout(location = 2) in vec2 in_texCoord0;


out vec3 normal;
out vec4 position;
out vec2 texCoord0;

float rand(float n){return fract(sin(n) * 43758.5453123);}

void main(void)
{

	normal = (modelview_matrix * vec4(in_normal, 0)).xyz;
	texCoord0 = in_texCoord0;


	position = projection_matrix * modelview_matrix *  vec4(in_position, 1);

	gl_Position = position;
};

@FRAGMENT
#version 410
precision highp float;
const vec3 ambient = vec3(0.3, 0.3, 0.3);
const vec3 lightVecNormalized = normalize(vec3(2.0, 0.5, 0.4));
const vec3 lightColor = vec3(1.0, 1.0, 1.0);
in vec3 normal;
in vec4 position;
in vec2 texCoord0;
uniform sampler2D tex; 

layout (location = 3) out vec4 out_color;
layout (location = 1) out vec3 out_position;
layout (location = 2) out vec3 out_glow;
layout (location = 0) out vec3 out_normal;
void main(void)
{
	vec2 texcoord0 = mod(texCoord0, 1.0);
	float diffuse = clamp(dot(lightVecNormalized, normalize(normal)), 0.0, 1.0);
   	out_color = vec4(ambient + diffuse * lightColor, 1.0)* texture(tex, texcoord0);
   	//out_depth = position.z/position.w;
   	out_normal = normalize(normal);
    out_position = position.xyz/10.0;
    out_glow = vec3(1.0) - normalize(normal);
  // out_frag_color = vec4(texCoord0, 0,0);
 //  out_frag_color = data;
   //out_frag_color= data;
};
