@VERTEX
#version 410
precision highp float;
uniform mat4 projection_matrix;
uniform mat4 modelview_matrix;
uniform float time;


layout(location = 0) in vec3 in_position;
layout(location = 1) in vec3 in_normal;
layout(location = 2) in vec2 in_texCoord0;


out vec3 normal;
out vec2 texCoord0;

float rand(float n){return fract(sin(n) * 43758.5453123);}

void main(void)
{

	normal = (modelview_matrix * vec4(in_normal, 0)).xyz;
	texCoord0 = in_texCoord0;


	vec3 position = in_position;


	gl_Position = projection_matrix * modelview_matrix *  vec4(position, 1);
};

@FRAGMENT
#version 410
precision highp float;
in vec3 normal;
in vec2 texCoord0;

uniform mat4 ssaoProjection;
uniform sampler2D texColor;
uniform sampler2D texNormal;
uniform sampler2D texPosition;
uniform sampler2D texDepth;
uniform sampler2D texSsaoNoise;
uniform vec3 ssaoSamples[64];
//uniform sampler2D tex; 
uniform float time;

out vec4 out_frag_color;

vec4 SSAO(vec2 TexCoords)
{
	int kernelSize = 64;
	float radius = 4.0;
	float bias = 0.025;
	const vec2 noiseScale = vec2(640.0/4.0, 480.0/4.0); 
	// get input for SSAO algorithm
    vec3 fragPos = texture(texPosition, TexCoords).xyz;
    vec3 normal = normalize(texture(texNormal, TexCoords).rgb);
    vec3 randomVec = normalize(texture(texSsaoNoise, TexCoords * noiseScale).xyz);
    // create TBN change-of-basis matrix: from tangent-space to view-space
    vec3 tangent = normalize(randomVec - normal * dot(randomVec, normal));
    vec3 bitangent = cross(normal, tangent);
    mat3 TBN = mat3(tangent, bitangent, normal);
    // iterate over the sample kernel and calculate occlusion factor
    float occlusion = 0.0;
    for(int i = 0; i < kernelSize; ++i)
    {
        // get sample position
        vec3 occulsionSample = TBN * ssaoSamples[i];
         // from tangent to view-space
        occulsionSample = fragPos + occulsionSample * radius; 

        // project sample position (to sample texture) (to get position on screen/texture)
        vec4 offset = vec4(occulsionSample, 1.0);
        offset = ssaoProjection * offset; // from view to clip-space
        offset.xyz /= offset.w; // perspective divide
        offset.xyz = offset.xyz * 0.5 + 0.5; // transform to range 0.0 - 1.0
        
        // get sample depth
        float sampleDepth = texture(texPosition, offset.xy).z; // get depth value of kernel sample
        
        // range check & accumulate
        float rangeCheck = smoothstep(0.0, 1.0, radius / abs(fragPos.z - sampleDepth));
        occlusion += (sampleDepth >= occulsionSample.z + bias ? 1.0 : 0.0) * rangeCheck;           
    }
    occlusion = 1.0 - (occlusion / kernelSize);
	return vec4(occlusion);
}


vec4 blur(vec2 texCoord)
{
	float depth = texture(texDepth, texCoord).x;
	depth = depth*depth*depth*depth*depth*depth;
	depth = depth*depth;
	float dist = 0.005*(depth);

	vec4 col = texture(texColor, texCoord+vec2(-dist, dist)) +
	texture(texColor, texCoord+vec2(0, dist)) +
	texture(texColor, texCoord+vec2( dist, dist)) +

	texture(texColor, texCoord+vec2(-dist, 0)) +
	texture(texColor, texCoord+vec2(0, 0)) +
	texture(texColor, texCoord+vec2(dist, 0)) +

	texture(texColor, texCoord+vec2(-dist, -dist)) +
	texture(texColor, texCoord+vec2(0, -dist)) +
	texture(texColor, texCoord+vec2(dist, -dist));
	col /= 9.0;

	return vec4(col);
}
void main(void)
{
	vec2 texcoord0 = mod(texCoord0, 1.0);
//	texcoord0.x += sin(texcoord0.y*4.0+time)*0.1;
//	texcoord0.y += cos(texcoord0.x*4.3+time)*0.1;
	vec4 depth = texture(texDepth, texcoord0);
	vec4 color = texture(texColor, texcoord0);
	vec4 normal = texture(texNormal, texcoord0);
	vec4 position =  texture(texPosition, texcoord0);
	
   	out_frag_color = depth + texture(texSsaoNoise, texcoord0); 
   	vec2 texCoord = texcoord0;
 //  	texCoord.y = 1.0-texCoord.y;
	//out_frag_color = SSAO(texCoord)*color;
  // out_frag_color = vec4(texCoord0, 0,0);
 //  out_frag_color = data;
   out_frag_color= normal;
  // out_frag_color = blur(texcoord0);
};
