#version 120

uniform sampler2D texture1;
uniform sampler2D texture2;
uniform float time = 1.0;

void main()
{
    vec2 coord1=gl_TexCoord[0].xy;
    vec2 coord2=gl_TexCoord[0].xy;

    vec2 d = vec2(1.0,1.0)/vec2(256,256);

    coord2 *= 0.25;

    coord2.s = floor(coord2.s/d.s)*d.s;
    coord2.t = floor(coord2.t/d.t)*d.t;

    coord2.s -= time*0.025;
    coord2.t += time*0.015;

    vec4 color = texture2D(texture1, coord1)*0.8+texture2D(texture2, coord2)*0.2 * gl_Color;
    color.a *= gl_Color.a;
    if (texture2D(texture1, coord1).a < 0.1) {
        gl_FragColor = vec4(0,0,0,0);
        return;
    }

    gl_FragColor = color;

}
