//The texture loader
function TextureLoader(){

    //List of textures to be loaded
    var toBeLoaded = [
        {
            name : "valot",
            path: "bin/kuvat/valot6.jpg",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.MirroredRepeatWrapping,
            wrapT : THREE.RepeatWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "kalat_sininen",
            path: "bin/kuvat/sininenkalatekstuuri.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.MirroredRepeatWrapping,
            wrapT : THREE.MirroredRepeatWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [8, 8],
            offset : [0, 0]
        },

        {
            name : "kalat_lila",
            path: "bin/kuvat/lilakalatekstuuri.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.MirroredRepeatWrapping,
            wrapT : THREE.MirroredRepeatWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [8, 8],
            offset : [0, 0]
        },

        {
            name : "kansi",
            path: "bin/kuvat/kansi.jpg",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.MirroredRepeatWrapping,
            wrapT : THREE.RepeatWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "hbd",
            path: "bin/kuvat/primitiveonnittelu_02.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "agony_b",
            path: "bin/kuvat/agony_musta.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "anxiety_b",
            path: "bin/kuvat/anxiety_musta.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "domination_w",
            path: "bin/kuvat/domination_valkonen.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "hello_w",
            path: "bin/kuvat/hello_valkonen.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "pain_b",
            path: "bin/kuvat/pain_musta.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "panic_b",
            path: "bin/kuvat/panic_musta.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "paraguay_w",
            path: "bin/kuvat/paraguay_valkonen.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "party_w",
            path: "bin/kuvat/party_valkonen.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "world_w",
            path: "bin/kuvat/world_valkonen.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            minFilter : THREE.NearestFilter,//kayta NearestFilter:ia pikseligrafiikalle!
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },
        {
            name : "flake",
            path: "bin/kuvat/flake_tp.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.MirroredRepeatWrapping,
            wrapT : THREE.RepeatWrapping,
            magFilter : THREE.NearestFilter,
            minFilter : THREE.NearestFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "flake_repeat",
            path: "bin/kuvat/flake_tp.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.RepeatWrapping,
            wrapT : THREE.RepeatWrapping,
            magFilter : THREE.NearestFilter,
            minFilter : THREE.NearestFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [16, 16],
            offset : [0, 0]
        },

        {
            name : "flake2",
            path: "bin/kuvat/flake_tp.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.MirroredRepeatWrapping,
            wrapT : THREE.RepeatWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        }

    ];

    var textures = {};
    var loader = new THREE.TextureLoader();

    var loadReady = function(callback){
        for(var i = 0; i < toBeLoaded.length; ++i){
            if(!toBeLoaded[i].loaded){
                return false;
            }
        }
        callback(textures);
    };

    var textureOnLoad = function(index, one, callback){
        var info = toBeLoaded[index];
        if(info.loaded){
            if(one){
                callback(textures[info.name.toString()]);
            }
            else{
                loadReady(callback);
            }
        }
        else{
            loader.load(info.path,
            function(texture){
                texture.mapping = info.mapping;
                texture.wrapS = info.wrapS;
                texture.wrapT = info.wrapT;
                texture.magFilter = info.magFilter;
                texture.minFilter = info.minFilter;
                texture.format = info.format;
                texture.flipY = info.flipY;

                texture.repeat.set(info.repeat[0], info.repeat[1]);
                texture.offset.set(info.offset[0], info.offset[1]);


                textures[info.name.toString()] = texture;
                info.loaded = true;

                if(one){
                    callback(texture);
                }
                else{
                    loadReady(callback);
                }
            },
            function(xhr){
                console.log( (xhr.loaded / xhr.total * 100) + "% loaded");
            },
            function ( xhr ) {
                console.log("An error happened when loading texture: ", info.name);
                //Should we just stop or continue or what to do?
            });
        }
    };

    var customLoad = function(path, callback){
        loader.load(path,
        function(texture){
            callback(texture);
        },
        function(xhr){
            console.log( (xhr.loaded / xhr.total * 100) + "% loaded");
        },
        function(xhr){
            console.log("An error happened when loading texture: ", path);
            callback(false);
        });
    };

    var t = {
        loader : loader,

        //Loads all textures in the list and then calls the function given as parameter
        loadAll : function(cb){
            if(toBeLoaded.length < 1){
                loadReady(cb);
            }
            else{
                for(var i = 0; i < toBeLoaded.length; ++i){
                    textureOnLoad(i, false, cb);
                }
            }

        },

        //Loads one texture and then calls the function given as parameter
        loadOne : function(index, cb){
            textureOnLoad(index, true, cb);
        },

        loadOther : function(path, cb){
            customLoad(path, cb);
        },

        getTextures : function(){
            return textures;
        }
    }

    return t;
};
TDEMO.TEXTURES = TextureLoader();
