
        ;       MemTest64 - memory test program for C64/128/65
        ;       (can be both run in 64 and native modes)

        ;       also can be run on PET, VIC-20, LCD and TED machines
        ;       (even on the CBM-II series with special code)


*=$1301

        ;       20 i=peek(65534)+peek(65535)*256:a=peek(45)+peek(46)*256:
        ;          ifpeek(43)=1andpeek(45)=193thena=peek(44)*256+1
        ;       20 ifi=64014thena=peek(102)*256+1
        ;       20 b=i:s=a+3211:ifa=3thens=272:fori=sto315:bank-(b=64470):
        ;          a=peek(i+5452):bank15:pokei,a:next
        ;       20 ifa>4865thens=272:bank.:fori=sto402:pokei,peek(a+i+3068):
        ;          next:bank128+113*(b=65303)
        ;       20 syss

        byte    $4c,$0d,$14,$00,$49,$b2,$c2,$28,$36,$35,$35,$33,$34,$29,$aa,$c2
        byte    $28,$36,$35,$35,$33,$35,$29,$ac,$32,$35,$36,$3a,$41,$b2,$c2,$28
        byte    $34,$35,$29,$aa,$c2,$28,$34,$36,$29,$ac,$32,$35,$36,$3a,$8b,$c2
        byte    $28,$34,$33,$29,$b2,$31,$af,$c2,$28,$34,$35,$29,$b2,$31,$39,$33
        byte    $a7,$41,$b2,$c2,$28,$34,$34,$29,$ac,$32,$35,$36,$aa,$31,$00

        byte    $6c,$13,$14,$00,$8b,$49,$b2,$36,$34,$30,$31,$34,$a7,$41,$b2,$c2
        byte    $28,$31,$30,$32,$29,$ac,$32,$35,$36,$aa,$31,$00

        byte    $b4,$13,$14,$00,$42,$b2,$49,$3a,$53,$b2,$41,$aa,$33,$32,$31,$31
        byte    $3a,$8b,$41,$b2,$33,$a7,$53,$b2,$32,$37,$32,$3a,$81,$49,$b2,$53
        byte    $a4,$33,$31,$35,$3a,$dc,$ab,$28,$42,$b2,$36,$34,$34,$37,$30,$29
        byte    $3a,$41,$b2,$c2,$28,$49,$aa,$35,$34,$35,$32,$29,$3a,$dc,$31,$35
        byte    $3a,$97,$49,$2c,$41,$3a,$82,$00

        byte    $f8,$13,$14,$00,$8b,$41,$b1,$34,$38,$36,$35,$a7,$53,$b2,$32,$37
        byte    $32,$3a,$fe,$02,$2e,$3a,$81,$49,$b2,$53,$a4,$34,$30,$32,$3a,$97
        byte    $49,$2c,$c2,$28,$41,$aa,$49,$aa,$33,$30,$36,$38,$29,$3a,$82,$3a
        byte    $fe,$02,$31,$32,$38,$aa,$31,$31,$33,$ac,$28,$42,$b2,$36,$35,$33
        byte    $30,$33,$29,$00

        byte    $ff,$13,$14,$00,$9e,$53,$00

        byte    $00


*=$1400

        ;       0 sys5133

basic   byte    $00,$0b,$14,$00,$00,$9e,$35,$31,$33,$33,$00,$00,$00


*=$140d

        ;       machine detection

main    jsr     mtest

xain    byte    $2c
        bcs     olx

        ;       temporary disabling of fast mode

        jsr     reux

        pha
        tya
        pha

        ;       REU detection

rain    jsr     redet

        ;       GeoRAM detection

gain    jsr     gedet

        ;       SuperRAM detection (SuperCPU) or DMA (C65/DTV)

        jsr     cpu

        pla
        tay
        pla

        ;       restoring fast mode

        jsr     zeux

        ;       print message

        sec

olx     txa
        adc     #$0d
        tax

olp     lda     reu-$0e,x
        beq     oks

        cmp     #$ff
        bcs     olx

        jsr     $ffd2
        inx
        bpl     olp

        ;       speed test

oks     jsr     ewap

        ;       return to Basic

        jsr     bedet

clp     lda     basic,y
        sta     ($2b),y
        dey
        bpl     clp

        inc     $2b
        cli
        rts

        ;       detecting VDC

vedet   stx     $a2
        sei
        php
        inx
        stx     vchr+1
        stx     $d600

        ;       check if VDC answers (if exists and is present at all)
        ;       and gives back a valid revision number (0-2)

vpl     cli
        cpx     $a2
        sei
        bcc     ndc

        lda     $d600
        bpl     vpl

        ;       check VDC register #1 (must be set for 80-column mode)

        cpy     $d601
        bne     ndc

        and     #$07
        cmp     #$03
        ora     #$30
        bcs     ndc

        sta     rev

        ;       check for VDC memory (16K/64K)

        jsr     zptx

        ;       check for VDC memory (16K) by writing

wpx     jsr     zpxy
        inx
        bne     wpx

        ;       check for VDC memory (16K) by comparing #1
        ;       (the written bytes must be read back -> no VDC if not)

        jsr     zptx
        jsr     zpxy

wpq1    inx
        beq     wpy

        jsr     cplp
        beq     wpq1

ndc     plp
        rts

        ;       check for VDC memory (16K) by comparing #2
        ;       (if $13xx being mirrored at $93xx -> no 64K if so)

wpy     jsr     zptx

        ldx     #$93
        jsr     zpxy

        ldx     #$13
        lda     #$36

wpq2    inx
        beq     w16

        jsr     cplp
        beq     wpq2

        ;       VDC register #28 must be set (47/63 -> 16K/64K)

        ldx     #$34
        ldy     #$3f
        bne     w64

w16     tax
        lda     #$31
        ldy     #$2f

w64     sta     ram
        stx     ram+1

        lda     #$1c
        jsr     cptp

        lda     #$24
        cpy     $d601
        php
        jsr     cpts
        pla

        ;       VDC register #36 must also be set (DRAM refresh cycles)
        ;       according to former test results (possibly to zero)

x36     ldx     #$00
        jsr     wplx

        plp
        bne     rdc

        and     #$02
        bne     wdc

        ;       regeneration of VDC charset if necessary (in C128 mode)

        sta     vchr+1
        jsr     $ff62

wdc     lda     #<xdc-$0e
        byte    $2c

rdc     lda     #<vdc-$0e
        ldx     #$0d
        sta     olp+1
        stx     vdc
        rts

rynd    dex
        sec
        txa
        ldx     #$00
        stx     $02
rylp    ror     $02
        cpy     $02
        bcc     rylp
        asl
        asl
        tay
        lda     $02
        sbc     #$00
        rts

        ;       VDC subroutines

cplp    jsr     wplp
        cpx     $d601
reo     rts

zde     byte    $00


*=$14fe

        ;       (C128/C65 Basic fix) <- $14fe (see also at $13fe)
        ;       (without this, a "?syntax error in 0" may occur on return)

        byte    $00,$00,$00

        ;       GeoRAM subroutines

nogeo   lda     gemet,y

gc1     cmp     #$de
        bcc     geld

gc2     cmp     #$e0
        bcs     geld

ge1     eor     #$01
        sta     gemet,y
geld    iny
gemet   bpl     nogeo

ge2     lda     #$03
        eor     gem
        sta     gem
gen     cmp     #$45
        beq     reo

        ;       GeoRAM detection

gedet   ldx     #$00
        ldy     reu
        stx     geo
        beq     gedex

        lda     rem
        cmp     gem
        beq     nogeo

gedex   stx     $dfff
        stx     $dffe

glp1    txa
        sta     $de00,x
        inx
        bne     glp1

glp2    txa
        cmp     $de00,x
ceo     bne     nogeo
        inx
        bne     glp2

glp3    dex
        stx     $dfff
        stx     $deff
        bne     glp3

glp4    inx
        stx     $dfff
        beq     gzpq
        cpx     $deff
        beq     glp4

gzpc    cpx     #$04
        bcc     ceo

gzpq    txa
        ldx     #$06
        tay
        beq     glpq

glpl    asl
        dex
        bcc     glpl
        beq     gzpz

glpq    jsr     rynd
        lsr
        lsr
        sta     $fb

gapp    lda     m128,y
        beq     gzpz
        sta     g64,x
        cpx     #$03
        iny
        inx
        bcc     gapp

gzpz    lda     #$0d
        ldx     reu
        sta     geo
        bne     vreo

        lda     vdc
        bne     deo

        lda     #<geo-$0e
        sta     olp+1

deo     dec     reu

        ;       "magic bytes" for MEGA65 (VIC-IV mode)

vic4    lda     #$47
        sta     $d02f
        lda     #$53
        sta     $d02f

        ;       enable ROM write protect (on MEGA65)

        lda     #$04
        ora     $d67d
        sta     $d67d
vreo    rts

        ;       128/256/512(k)

m128    byte    $31,$32,$38,$00
m256    byte    $32,$35,$36,$00
m512    byte    $35,$31,$32,$00

        ;       1m/2m/4m/8m/16m

mb01    byte    $31,$4d,$20,$20
mb02    byte    $32,$4d,$20,$20
mb04    byte    $34,$4d,$20,$20
mb08    byte    $38,$4d,$20,$20
mb16    byte    $31,$36,$4d,$20

        ;       REU subroutines

noreu   lda     remet,x

        cmp     #$df
        beq     vicv

        cmp     #$de
remet   bne     xreu

        lda     #$46
        inc     remet,x
        sta     rem

xreu    dex
        bne     noreu

        ;       REU detection

redet   ldy     #$0d
        cpy     cwyp+1
        stx     reu
        bne     rzpy

        jsr     cpmz80
        beq     rzpy

        lda     rem
        cmp     #$46
        bne     noreu

        lda     #$2c
        sta     gain

rzpy    ldy     #$00

rzp1    txa
        sta     $1380,x
        inx
        bpl     rzp1

        jsr     reout
        inc     $13ff
        jsr     reuin

rzp3    tya
        cmp     $1380,y
        bne     noreu
        iny
        bpl     rzp3

        ldy     #$00

rzp4    sty     $13ff
        jsr     reout
        dey
        bne     rzp4

rzp5    iny
        beq     rzpq

        jsr     reuin
        cpy     $13ff
        beq     rzp5

rzpq    ldx     #$08
        tya
        beq     rlpq

rlpl    asl
        dex
        bcc     rlpl
        beq     rzpz

rlpq    jsr     rynd
        sta     $fe

rapp    lda     m128,y
        beq     rzpz
        sta     r64,x
        cpx     #$03
        iny
        inx
        bcc     rapp

rzpz    lda     #$0d
        sta     reu

vicv    lda     $ffff
        eor     #$ff
        beq     vic2

        ;       "magic bytes" for C65 (VIC-III mode)

vic3    lda     #$a5
        sta     $d02f
        lda     #$96
        byte    $2c

        ;       standard mode for VIC-II (hiding extra registers)

vic2    lda     #$ff
        sta     $d02f
        rts

        ;       REU transfer subroutine

reout   lda     #$90
        byte    $2c
reuin   lda     #$91

        ldx     #$13
        pha

        stx     $de03

        lda     #$80
        ldx     #$00
        sta     $de05
        stx     $de08

treu    sta     $de02
        stx     $de04
        sty     $de06
        sta     $de07
        stx     $de09
        stx     $de0a

        pla
        sta     $de01
        rts

zptx    ldy     #$00
bptx    lda     #$12
        bne     wptx

        ;       esc-x/scnclr/esc-x

xdc     byte    $1b,$58,$0e,$99,$93,$1b,$58

        ;       "vdc r1 with 16k"

vdc     byte    $00,$56,$44,$43,$20,$52
rev     byte    $31,$20,$57,$49,$54,$48,$20
ram     byte    $31,$36,$4b

        ;       "reu de00 64k"

reu     byte    $00,$52,$45,$55,$20,$44
rem     byte    $45,$30,$30,$20
r64     byte    $0e,$36,$34,$4b

        ;       "geo de00 64k"

geo     byte    $00,$47,$45,$4f,$20
gev     byte    $44
gem     byte    $45,$30,$30,$20
g64     byte    $0e,$36,$34,$4b

        ;       "srm scpu 64k"

scpu    byte    $00,$53,$52,$4d,$20
sev     byte    $53,$43,$50,$55
sem     byte    $20
s64     byte    $0e,$36,$34,$4b

ntab2   byte    $00,$00,$03,$27,$86,$42,$96
ntab1   byte    $0a,$64,$e8,$10,$a0,$40,$80

        ;       VDC subroutines

wplx    jsr     wplp
        stx     $d601

wplp    bit     $d600
        bpl     wplp
        rts

aptx    lda     #$12
        ldx     $05
        jsr     cptp

        jsr     wplp
        stx     $d601

        lda     #$1f

wptx    ldx     #$13

wpts    jsr     wplp
        stx     $d600

cpts    jsr     wplp
        sty     $d601

cptp    jsr     wplp
        sta     $d600
        rts

ntab3   byte    $00,$00,$00,$00,$01,$0f

aplp    tya
        and     #$3f
        ora     #$40
        rts

zpxy    ldy     #$1f

wpxy    jsr     wplx

wply    jsr     wplp
        sty     $d600
        rts

        ;       printing 16-bit/24-bit number in $02/$03/$04

num16   stx     $04
num24   stx     $05
        ldx     #$08
        bne     nlp0

nlp1    lda     $02
        sbc     ntab1-1,x
        sta     $02
        lda     $03
        sbc     ntab2-1,x
        sta     $03
        lda     $04
        sbc     ntab3-1,x
        sta     $04
        iny

nlp2    lda     $02
        cmp     ntab1-1,x
        lda     $03
        sbc     ntab2-1,x
        lda     $04
        sbc     ntab3-1,x
        bcs     nlp1

        tya
        bne     nlp3
        ldy     $05
        beq     nlpy

nlp3    ora     #$30
        sty     $05
        jsr     $ffd2

nlp0    ldy     #$00
nlpy    dex
        bne     nlp2

        lda     #$30
        ora     $02
        jmp     $ffd2


*=$1777

        ;       execute with swapping (continuation)

ewap    jsr     swap

        lda     #$60
        cmp     srest-$0800
        bne     swap

        jsr     stest-$0800

        ;       swapping memory (if possible) at $1800 <-> $2000

swap    sei
        ldx     $fd
        ldy     #$00
        dex
        clc
        bne     swax

        lda     $fc
        cmp     #$09
        bcc     swax

        tya

        ;       TAZ / MAP

        byte    $4b,$5c

        lda     #$07
        ora     $00
        sta     $00

        lda     #$fe
        and     $01
        sta     $01

swax    sty     $02
        sty     $04
        php

        lda     #$20
        ldx     #$0c
salp    sta     basic+2

selp    lda     basic,x
sejt    cmp     $2000,x
        bne     swre
        dex
        bpl     selp

        lda     #$18
        ldx     #$20
        sta     $03
        stx     $05

        lda     #$38
        ldx     #$08
        eor     sejt+2
        sta     sejt+2

swlp    lda     ($02),y
        pha
        lda     ($04),y
        sta     ($02),y
        pla
        sta     ($04),y
        iny
        bne     swlp

        inc     $03
        inc     $05
        dex
        bne     swlp

        jsr     swalt

swre    plp
        tya
        bcc     swex

swaz    lda     #$07
        ora     $01
        sta     $01

swyz    tya

        ;       LDX #$E3
        ;       LDZ #$B3

swxz    byte    $a2,$e3
        byte    $a3,$b3

        ;       MAP / TAZ

        byte    $5c,$4b

        clc

swex    tax
        nop
        rts


*=$17f7

        ;       (self-modifications)

dtv64   lda     #$33
        sta     ds+5
        lda     #$d3
dtv65   sta     $0b
dtv66   lda     #$60
        sta     reuy
        sta     zeuy
        rts

        ;       temporary disabling of fast mode

reux    ldx     #$00
reuy    ldy     $d030
        lda     $d0b8
        stx     $d030
        stx     $d07a
        rts

        ;       restoring fast mode

zeux    ldx     #$00
zeuy    sty     $d030
        and     #$c0
        bne     beux
        stx     $d07b
beux    rts

        ;       Basic detection

bedet   sei
        ldy     $ffff

        cpy     #$f0
        ldx     #$00
        lda     #$04
        bcc     basy

        lda     $fffe

        cpy     #$fa
        bne     blcd
        cmp     #$0e
        bne     blcd

        ldy     $65
        lda     $66
        bcs     basn

blcd    cpy     #$fc
        bne     btcd
        cmp     #$b3
        beq     btsd

btcd    iny
        bne     base

        cmp     #$17
        beq     base

btsd    lda     $2c
        ldy     $2b
        beq     basy

        lda     $2c
basn    bne     basc

base    ldy     $2d
        lda     $2e
        byte    $2c

basy    ldy     #$01

basc    sta     basic+2
        sta     $2c
        tya
        bne     basf
        byte    $24

basf    dey
        txa
        sty     $2b
        ldy     #$0c

belp    sta     $1300,x
        inx
        bne     belp

        nop
        rts

        ;       CPU and machine detection

mtest   jsr     bedet

        jsr     vic4

        lda     #$40
        ldy     #$13
        inc     $2b

        sta     $02
        txa

        stx     $03
        stx     $04
        sty     $05
        stx     $0a
        stx     $0b

        ;       $1A = INC A on newer CPU but only a NOP on 65xx

        byte    $1a,$ea,$ea
        beq     noxp

        byte    $eb,$a9,$ea

        ;       on 65CE02: ROW $EAA9     (a = $01)
        ;       on 65C02: NOP / LDA #$EA (a = $ea)
        ;       on 65816: XBA / LDA #$EA (a = $ea, b = $01)
        ;       (on 65xx: SBC #$A9 / NOP)

        cmp     #$01
        beq     nocp

        byte    $a9,$00,$eb,$1a,$1a

        ;       (on 65CE02: LDA #$00 / ROW $1A1A)
        ;       on 65C02: LDA #$00 / NOP / INC A / INC A (a = $02)
        ;       on 65816: LDA #$00 / XBA / INC A / INC A (a = $03, b = $00)
        ;       (on 65xx: LDA #$00 / SBC #$1A / NOP)

        cmp     #$04
        bcc     nocp

noxp    txa

nocp    sta     $fd

        ;       system identification (by Kernal)

        ldy     $ffff
        lda     $fffe

        cpy     #$e6
        beq     peyr
        bcs     nope
        cpy     #$e4
        bcc     nope

        ;       PET detected ($e66b/$e61b/$e442) <- Kernal revisions (1-2/3/4)

        ldy     #$03
        byte    $2c
peyr    ldy     #$02
        cmp     #$6b
        bne     pemr
        dey
pemr    lda     #$84
        sta     vetr+1
        sta     aetr+1
        lda     #$04
        bne     memr

nope    cpy     #$fa
        bne     nntd
        cmp     #$0e
        bne     nntd

        ;       LCD detected ($fa0e) <- Kernal

        lda     $fd
        ora     #$14
        tay
        lda     #$2c
        sta     xetr
        lda     #$05
        bne     memr

nntd    bne     nctd

        ;       detecting memory of PET, VIC-20, LCD or TED
        ;       (also used for all machines)

yemr    cpy     #$07
        tya
        beq     memr
        ldy     #$1a
        bcs     memr
        dey

memr    pha
demr    jsr     dtv66
remr    lda     #$04
        stx     $06

melp    sta     $07
        txa
        sta     ($04,x)
        lda     ($06,x)
        pha
        tya
        sta     ($06,x)
        cmp     ($06,x)
        bne     detr
        lda     #$aa
        sta     ($06,x)
        cmp     ($06,x)
        bne     detr
        pla
        sta     ($06,x)
        cmp     ($06,x)
        bne     petr
        lda     #$01
        inc     $06
        sta     ($04,x)
        byte    $24
detr    pla
petr    lda     $07
patr    inc     $04
        clc
        adc     #$10
vetr    cmp     #$d4
        beq     patr
metr    cmp     #$04
        bne     melp

xetr    stx     $ff3e

        lda     $06
        asl
        asl
aetr    cmp     #$04
        bne     netr
        adc     #$00
netr    cpy     #$15
        bcc     cetr
        cpy     #$18
        bcs     cetr
        cmp     #$20
        lda     #$20
        bcs     catr
cetr    cmp     #$2c
        bcc     satr
catr    lda     #$40
satr    sta     $02
xatr    stx     $03
        stx     $06

        jmp     nex

nctd    cpy     #$fc
        bne     nc64
        cmp     #$b3
        bne     nc64

        ;       TED detected ($fcb3) <- Kernal
        ;       (preparing with self-modifications)

        stx     $ff3f

        stx     $3ffe
        stx     $3fff
        stx     $7ffe
        stx     $7fff
        sta     $fffe
        sty     $ffff

        lda     #$38
        sta     xain

        ;       64K

        ldy     #$04
        lda     $7ffe
        ora     $7fff
        beq     tydd

        ;       32K

        ldy     #$84
        lda     $3ffe
        ora     $3fff
        beq     tydd

        ;       16K

        ldy     #$44
tydd    sty     metr+1

        inx
        stx     wmpa+1
        stx     rlhc+1
        ldx     #$1c
        lda     #$ff
        stx     wmpp+1
        sta     wmpp+2
        stx     rlhb+1
        sta     rlhb+2
        inx

        ldy     #$05
        bne     vydd

nc64    iny
        bne     nc65

        cmp     #$72
        bne     nvic

        ;       VIC-20 detected ($ff72) <- Kernal
        ;       (self-modifications for GeoRAM and scanlines)

vglp    ldx     gemet,y
        lda     #$98
        cpx     #$de
        beq     vgsp
        lda     #$9c
        cpx     #$df
        bne     vgyp
vgsp    sta     gemet,y
vgyp    iny
        bpl     vglp

        ldy     #$06
        cpy     ntpa
        sty     ntpa
        beq     xydd

        lda     #$94
        sta     vetr+1

        ldx     #$39
        lda     #$38
        stx     gev
        sta     gem

        ldx     #$7b
        sta     gen+1
        stx     ge2+1

        ldx     #$98
        lda     #$9d
        stx     gc1+1
        sta     gc2+1

        ldx     #$60
        lda     #$29
        stx     cpu
        stx     waitmp
        sta     rlhd

        ldx     #$04
        lda     #$90
        stx     ge1+1

vydd    stx     ntpr+1
        sta     ntpr+2
        stx     rllb+1
        sta     rllb+2

xydd    iny
        ldx     #$00

        jmp     yemr

nvic    ldy     #$50
        cmp     #$17

        ;       detecting VDC

        jsr     vedet

        sei
        ldx     #$00

        ;       detecting emulator

        jsr     emul
        beq     vclp

        ;       C64 mode (detecting C65 or MEGA65)

nc65    lda     $fd
        ldy     #$ff
        cmp     #$01
        beq     mc65
        bcs     ntx

        jsr     vic3

        cpy     $d030
        beq     no65
        lda     $d031
        cmp     #$ff
no65    sty     $d02f
        beq     m64
        bne     m65

        ;       C128 detected ($ff17) <- Kernal

vclp    lda     vc128,y
        sta     $0140,y
        iny
        bpl     vclp

        ;       detecting memory of C128 (four banks)

        jsr     $0140

mm18    ldy     #$18
        lda     $fd
        beq     mm28

        ora     #$14
        tay

mm28    lda     #$08
        bne     mb28

m65     and     $d02f
        and     #$f0
        cmp     #$d0
        beq     m64

        ;       C65 detected

mc65    lda     #$d7
        jsr     dtv65

        jsr     vic4

        lda     $d030
        sty     $d02f
        cmp     $d030
        php

        tya
        ldy     #$09

        plp
        beq     mg65

        ;       MEGA65 detected

        iny

mg65    cmp     $ffff
        beq     md64

        jsr     sylf

        asl     $02
        lda     #$09
mb28    bne     mc28

        ;       C64 mode (detecting Chameleon, DTV, TDC or C128)

m64     lda     #$2a
        sta     $d0fe
        cmp     $d0fe
        beq     chy

        cpy     $d0fe
chy     sty     $d0fe
        bne     cham

        cpy     $d03f
ntx     bne     dtx

        sta     $d800
        cmp     $d800
        bne     dtx

        lda     #$01
        sta     $d000
        sta     $d03f
        cmp     $d040
        stx     $d000
        bne     dtn
        cpx     $d040
dtn     stx     $d03f
        beq     dtx

        ;       DTV detected

        jsr     dtv64
        ldy     #$0d
        sty     $0a
        bne     md64

dtx     stx     $d02f
        lda     $d02f
        sty     $d02f
        tay

        and     $d031
        and     #$f0
        cmp     #$d0
        beq     tdc

        ;       C128 in C64 mode

        cpy     #$f8
        bcc     mc14

        cpy     #$ff
mc18    ldy     #$18
        bcc     mc64

        ;       C64 detected ($ff48) <- Kernal

mc14    ldy     #$14
mc64    lda     $fd
        beq     mc28

        ora     #$14
        tay
        byte    $2c

        ;       TDC detected

tdc     ldy     #$0b
        byte    $2c

        ;       Turbo Chameleon detected

cham    ldy     #$0c

        ;       C64 mode

md64    txa
mc28    pha

        sty     $09
        lda     #$99

        stx     $d020
        stx     $d021

        jsr     $ffd2

        sei
        pla
        pha

bns1    bne     x64
        lda     #$07

        ora     $00
        sta     $00

        lda     #$f8
        and     $01
        sta     $01

        bne     x128

x64     cmp     #$08
        bne     x128

        lda     #$3f
        sta     $ff00

        lda     #$8e
        byte    $2c

x128    lda     #$2c
        sta     xetr

        lda     #$24
        stx     xetr+1
        sta     satr
        sta     xatr

        jmp     remr

        ;       raster synchronization

waitmp  jsr     wmpp
        bne     waitmp
wmp     jsr     wmpp
        beq     wmp
        rts
wmpp    lda     $d011
wmpa    and     #$80
wex     rts

        ;       (continuation)

nex     pla
        pha

        sty     $09
        sta     $fc

bns2    bne     nx64
        lda     #$07

        ora     $01
        sta     $01

nx64    jsr     vicv

        ;       print message (machine type and CPU)

        lda     #$1f
        jsr     msg

        pla
        pha
        jsr     msg

        lda     #$1b
        jsr     msg

        tya
        cpy     #$09
        bne     x65
        lda     #$13
x65     jsr     msg

        lda     #$1c
        jsr     msg

        ;       printing memory (with "k")

        jsr     num16

        lda     #$4b
        jsr     $ffd2

        sei
        pla
        beq     ntpp
        cmp     #$06
        bcc     wex

ntpp    pha

        ;       detecting PAL/NTSC (by counting scanlines)

ntpx    txa

ntpl    tay
        sta     $02
ntpr    lda     $d012
        cmp     $02
        bcs     ntpl

        iny
        beq     ntpx

        stx     $04
        stx     $05
        stx     xiux+1

        inc     $02
        ldx     #$03
        ldy     #$ff
ntpa    bit     $02

        stx     x03+2
        dex
        stx     x02+2
        dex
        stx     x01+2

        lda     $02
        stx     $03

        cmp     #$10
        lda     #$68
        bcs     npal

        dex
        iny

npal    cmp     npl
        beq     npl

        pla
        ldx     #$00
        rts

        ;       detecting emulator #1

emul    ldy     #$60
        cpy     emma
        bne     emme

        lda     $fd
        jsr     emul2
        bne     emme

jmme    pla
        pla

        lda     #$0e
        sta     mm18+1
        sta     mc18+1
        sta     mc14+1

jsse    jsr     dtv66

dmme    jmp     dtx

emme    lda     $fffe
        ldy     #$00
        cmp     #$17
        rts

        ;       "dma d700"

ds      byte    $44,$4d,$41,$20,$44,$37,$30,$30


*=$1c00

        ;       0 sys5133

        byte    $00,$0b,$1c,$00,$00,$9e,$35,$31,$33,$33,$00,$00,$00


*=$1c0d

npl     pla
        cmp     #$08
        bcc     nplc
        bne     nplb

        ;       PAL/NTSC switch on C128

npla    sty     $0a03

        ;       PAL/NTSC switch on C65

nplb    sty     $1103
        bcs     nplx

        ;       PAL/NTSC switch on C64

nplc    stx     $02a6
        sec

nplx    txa
        pha

        ;       CPU speed test (for C64/128/65/TED/VIC-20):

        ;       Exactly for 0.1 second, we are counting the cycles. 100.000
        ;       cycles for this time period signs a 1 MHz clock. If we measure
        ;       more or less, the clock is also proportionately more or less.

        ;       (Although this method is not always perfectly exact, because
        ;       another type of CPU, e.g. a 65C02 or a 65CE02 etc., may produce
        ;       a slightly different number of cycles in the inner loop.)

        eor     #$01
        adc     #$04

        ;       0.1 sec = 5 x PAL or 6 x NTSC frames

        sta     $06
        sei

        ;       raster synchronization

        jsr     waitmp

        ;       The inner loop takes 99 cycles (from x00 to x09), so repeatedly
        ;       (2 + 99 x 10 - 2 + 9) x 100 = 99.900 cycles (from xxx to x99),
        ;       plus few (for a few times when a bit more because of branching)
        ;       that means just some hardly less than 100.000 cycles after all:

        ;       ...at least on a 65xx CPU (probably on C65 slightly less),
        ;       ...and with screen/sprites/interrupts completely turned off.

        ;       (This program takes only care about disabling the interrupts,
        ;       thus other things, like the screen and sprites, as well as the
        ;       fast mode and the turbo settings yet are waiting for the user!)

yyy     ldy     #$00

xxx     ldx     #$00

x00     lda     $04
        cmp     ($03,x)
        lda     $05
        cmp     ($02,x)

x01     lda     $0100
        cmp     ($04,x)
x02     lda     $0201
        cmp     ($03,x)
x03     lda     $0302
        cmp     ($02,x)

        inc     x01+2
        dec     x02+2
        inc     x03+2

        nop
        nop
        nop
        nop
        nop

rllb    lda     $d012
        and     #$f0
        beq     xiux
        nop
        sta     xiux+1

xuix    inx
        cpx     #$0a
        bcs     x09
        jmp     x00

x09     iny
        cpy     #$64
        bcs     x99
        jmp     xxx

x99     inc     $04
        bne     yyy
        inc     $05
        bcs     yyy

xiux    cmp     #$00
        beq     xuix
        sta     xiux+1

rlhb    lda     $d011
rlhc    and     #$80
rlhd    beq     xuix

        dec     $06
        bne     xuix

        cpx     #$05
        ldx     $04
        lda     $05
        bcc     roua
        iny
        cpy     #$64
        bcc     roua
        ldy     #$00
        inx
        bne     roua
        adc     #$00

roua    stx     $07
        sta     $08

        pla
        ora     #$10
        jsr     xsg

        lda     #$0f
        jsr     msg

        ;       printing number of scanlines

        tya
        pha
        jsr     num16

        lda     #$12
        jsr     msg

        lda     #$1d
        jsr     msg

        lda     $07
        ldy     $08
        sta     $02
        sty     $03

        ;       printing x.yy MHz

        jsr     num16
        pla
        sta     $02
        sty     $03

        lda     #$2e
        jsr     $ffd2

        lda     $02
        cmp     #$0a
        bcs     rum

        lda     #$30
        jsr     $ffd2

rum     jsr     num16

        lda     #$1e

        ;       print message subroutine

xsg     ldx     #$00
msg     sty     $05
        tay
        beq     ysg

xlp     inx

ylp     lda     mgx-1,x
        beq     ysp
        inx
        bne     ylp

ysp     dey
        bne     xlp

ysg     lda     mgx,x
        bne     mnx

        ldy     $05
        sei
        tax
        rts


*=$1cfe

        ;       (C128 Basic fix) <- $1cfe (see also at $20fe/$14fe/$13fe)

        byte    $00,$00,$00

mnx     cli
        jsr     $ffd2
        inx
        bne     ysg

        ;       #00 "c64"

mgx     byte    $43,$36,$34,$00

        ;       #01 "r1-2"

        byte    $52,$31,$2d,$32,$00

        ;       #02 "r3"

        byte    $52,$33,$00

        ;       #03 "r4"

        byte    $52,$34,$00

        ;       #04 "pet"

        byte    $50,$45,$54,$00

        ;       #05 "lcd"

        byte    $4c,$43,$44,$00

        ;       #06 "ted"

        byte    $54,$45,$44,$00

        ;       #07 "vic"

        byte    $56,$49,$43,$00

        ;       #08 "c128"

        byte    $43,$31,$32,$38,$00

        ;       #09 "c65"

        byte    $43,$36,$35,$00

        ;       #0a "mega65"

        byte    $4d,$45,$47,$41,$36,$35,$00

        ;       #0b "tdc"

        byte    $54,$44,$43,$00

        ;       #0c "chm"

        byte    $43,$48,$4d,$00

        ;       #0d "dtv"

        byte    $44,$54,$56,$00

        ;       #0e "emu"

xemu    byte    $45,$4d,$55,$00

        ;       #0f " on "

        byte    $20,$4f,$4e,$20,$00

        ;       #10 "ntsc"

        byte    $0d,$4e,$54,$53,$43,$00

        ;       #11 "pal"

        byte    $0d,$50,$41,$4c,$00

        ;       #12 " scanlines"

        byte    $20,$53,$43,$41,$4e,$4c,$49,$4e,$45,$53,$00

        ;       #13 "4510"

        byte    $34,$35,$31,$30,$00

        ;       #14 "6510"

        byte    $36,$35,$31,$30,$00

        ;       #15 "65ce02"

        byte    $36,$35,$43,$45,$30,$32,$00

        ;       #16 "65c02"

        byte    $36,$35,$43,$30,$32,$00

        ;       #17 "65816"

        byte    $36,$35,$38,$31,$36,$00

        ;       #18 "8502"

        byte    $38,$35,$30,$32,$00

        ;       #19 "7501"

        byte    $37,$35,$30,$31,$00

        ;       #1a "6502"

        byte    $36,$35,$30,$32,$00

        ;       #1b " ("

        byte    $20,$28,$00

        ;       #1c ") with "

        byte    $29,$20,$57,$49,$54,$48,$20,$00

        ;       #1d "cpu speed at "

        byte    $0d,$43,$50,$55,$20,$53,$50,$45,$45,$44,$20,$41,$54,$20,$00

        ;       #1e " mhz"

        byte    $20,$4d,$48,$5a,$00

        ;       #1f

        byte    $0e,$93,$00

        ;       "ide"

ide64   byte    $49,$44,$45

        ;       "ult"

ult     byte    $55,$4c,$54

        ;       SuperRAM detection (SuperCPU) or DMA (C65/DTV)
        ;       (continuation)

cpu     lda     $fd
        ldx     #$00
        cmp     #$03
        stx     $0d
        stx     scpu
        bne     sosc

        ldy     $d27b
        iny
        beq     nosc

        lda     $d27d
        ldy     $d27f
        sta     $0c
        sty     $0d

        tya
        dey
        sbc     $0c
        sty     sly1+3
        sty     sly2+3
        ldy     #$08
        bcc     nosc

slpl    asl
        dey
        beq     nosc
        bcc     slpl

slpq    tya
        asl
        asl
        tay

        stx     $13ff

        ;       STA $xx13ff

sly1    byte    $8f,$ff,$13,$ff

        ;       CMP $xx13ff

sly2    byte    $cf,$ff,$13,$ff

        bne     nosc

        lda     $13ff
        bne     nosc

sapp    lda     m128,y
        beq     szpz
        sta     s64,x
        cpx     #$03
        iny
        inx
        bcc     sapp

szpz    lda     #$0d
        cmp     geo
        beq     seo
        dec     geo

        cmp     reu
        beq     seo
        dec     reu

        cmp     vdc
        beq     seo

        ldy     #<scpu-$0e
        sty     olp+1

seo     sta     scpu

nosc    jmp     vicv

        ;       DMA (C65) detection (by writing and comparing)

sosc    cmp     #$01
        bne     dosc

        ldy     $ffff
        iny
        beq     nosc

        jsr     vic3

        ;       LDZ #$00

        byte    $a3,$00

        ldx     #$02
        ldy     #$40
        stx     $02
        sty     $03

        ;       DEZ / TZA

clp1    byte    $3b,$6b

        jsr     $ff77

        ;       TZA

        byte    $6b

        bne     clp1

        ;       INC A

        byte    $1a

clp2    jsr     $ff74
        sta     $04

        ;       TZA

        byte    $6b

        cmp     #$02
        beq     cinz
        cmp     #$03
        beq     cinz

        cmp     $04
        bne     clnq

        ;       INZ

cinz    byte    $1b

        bne     clp2

        ;       TZA

        byte    $6b

        beq     clnz

        ;       TZA

clnq    byte    $6b

        beq     nosc

        ;       LDZ #$00

        byte    $a3,$00

clnz    ldx     #$08
        tay

scp     lda     ds-1,x
        sta     scpu,x
        dex
        bne     scp

        ldx     #$08
        tya
        beq     clpq

clpl    asl
        dex
        bcc     clpl
        beq     szpz

clpq    jsr     rynd
        sta     $0d

        jmp     sapp

        ;       DMA (DTV) detection (by writing and comparing)

dosc    ldy     $0a
        beq     seux

        tay
        bne     seux

        lda     #$01
        sta     $d03f

dzp1    txa
        sta     $1380,x
        inx
        bpl     dzp1

        jsr     dmout
        inc     $13ff
        jsr     dmain

dzp3    tya
        cmp     $1380,y
        bne     ceux
        iny
        bpl     dzp3

        ldy     #$3f

dzp4    sty     $13ff
        jsr     dmout
        dey
        bpl     dzp4

dzp5    iny
        jsr     dmain
        cpy     $13ff
        beq     dzp5

dzpq    tya
        beq     ceux
        sec
        byte    $24
ceux    clc

deux    stx     $d03f
        bcs     clnz

seux    jmp     vicv

        ;       DMA (DTV) transfer subroutine

dmout   jsr     wdma

        lda     #$13
        sta     $d301
        lda     #$40
        sta     $d302
        sta     $d304
        jsr     aplp
        bne     dmsr

dmain   jsr     wdma

        jsr     aplp
        sta     $d302
        lda     #$13
        sta     $d304
        lda     #$40
        sta     $d301

dmsr    sta     $d305

        lda     #$80
        sta     $d300
        sta     $d303

wdmr    sta     $d30a
        stx     $d30b

        lda     #$01
        ldx     #$00
        sta     $d306
        stx     $d307
        sta     $d308
        stx     $d309

        lda     #$0d
        sta     $d31f

wdma    lda     #$01
wand    and     $d31f
        bne     wand

        tax
        rts

        ;       detecting IDE64 or 1541 Ultimate

emul3   ldy     #$02

neor    lda     $de60,y
        eor     ide64,y
        bne     nide

        dey
        bpl     neor

        sty     zde

        ldy     #<ide64+2
        bne     ulti

nide    lda     $df1d
        eor     #$c9
        bne     umma

        ldy     #<ult+2

ulti    lda     #$2c
        ldx     #$03
        sta     jsse

ulp     lda     $1d00,y
        dey
        dex
        sta     xemu,x
        bne     ulp

umma    sei
        rts


*=$1f57

        ;       (self-modification)

sylf    sty     $09
        ldy     #$11

splp    lda     spax,y
        sta     $1fee,y
        dey
        bpl     splp

        jsr     spixx

        ora     $00
        sta     $00

        lda     #$fe
        and     $01
        sta     $01

        jsr     xylf

        lda     #$07
        ora     $01
        sta     $01


*=$1f7a

        ;       (* = $1fee) <-> (* = $27ee)

spax    beq     spaq

spaxx   txa
        tay

        jsr     swxz


*=$1f81

        ;       (* = $1ff5) <-> (* = $27f5)

spix    beq     spiq

spixx   txa
        tay

        ;       TAZ / MAP

        byte    $4b,$5c

spiq    ldy     $09
spaq    lda     #$07
srts    rts


*=$1f8c

        ;       upward relocation (sys8076) <- Basic + 3211

        sei
        ldx     $2b
        lda     $2d
        ldy     $2e

        cmp     #<ende
        bne     bex
        dex
        bne     bex

        lda     #$01
        ldy     $2c

bex     ldx     $fffe
        cpx     #$0e
        bne     fex
        ldx     $ffff
        cpx     #$fa
        bne     fex

        lda     #$01
        ldy     $66

fex     sec
        pha
        sbc     #$01
        pha
        tya
        sbc     #$13
        tax
        pla
        php

        adc     #<flp2-1
        sta     $02
        txa
        adc     #>flp2
        sta     $03

        plp
        pla
        bcs     und

        adc     #$ff
        sta     $04
        tya
        ldy     #$1a
        adc     #$1c
        sta     $05

flp1    lda     ($02),y
        sta     $010f,y
        dey
        bne     flp1

        lda     #$30
        ldx     #$1d
        sty     $02
        sta     $03

        jmp     $0110

flp2    dey
        lda     ($04),y
        sta     ($02),y
        tya
        bne     flp2

        dec     $03
        dec     $05

        txa
        dex
        bne     flp2

und     cmp     #$01
        bne     down
        txa
        bne     down

        jmp     main


*=$2000

        ;       0 sys5133

        byte    $00,$0b,$20,$00,$00,$9e,$35,$31,$33,$33,$00,$00,$00


*=$200d

        ;       downward relocation (sys8205) <- Basic + 3340
        ;       (copied to $0110 and started there)

down    sei
        ldy     $2b
        lda     $2d
        ldx     $2e

        dey
        bne     xex
        cmp     #<ende
        bne     xex

        ldx     $2c
        bcs     smex

xex     ldy     $ffff
        cpy     #$fa
        bne     lex
        ldy     $fffe
        cpy     #$0e
        bne     kex

        ldx     $66
        ldy     #$00

smex    inx
        sty     $02
        stx     $03

        php
        bcs     zyex

kex     ldy     $ffff

lex     clc
        adc     #$ff
        sta     $02
        txa
        adc     #$00
        iny
        sta     $03

        php
        beq     qyex

        lda     #$00
        tax
        tay

        ;       TAZ / MAP

        byte    $4b,$5c

        lda     #$07
        ora     $00
        sta     $00

        lda     #$f8
        and     $01
        sta     $01

zyex    lda     #$14
        ldx     #$1d
        sty     $04
        sta     $05

flp3    lda     ($02),y
        sta     ($04),y
        iny
        bne     flp3

        inc     $03
        inc     $05

        dex
        bne     flp3

        plp
        bcs     sjex
        beq     stex

        lda     #$07
        ora     $01
        sta     $01

        tya

        ;       LDX #$E3
        ;       LDZ #$B3

        byte    $a2,$e3
        byte    $a3,$b3

        ;       MAP / TAZ

        byte    $5c,$4b

sjex    jmp     main

qyex    ldx     #$3f

stex    stx     $ff00
        bne     zyex
        beq     sjex


*=$2090

emsg    lda     #$08
amsg    adc     #$00
        byte    $2c

dmsg    lda     #$0d
        byte    $2c

fmsg    lda     #$0f

        ;       print message subroutine

xmsg    ldx     #$00

ymsg    tay
        beq     xysg

xxlp    inx

xylp    lda     xmgx-$0801,x
        beq     xysp
        inx
        bne     xylp

xysp    dey
        bne     xxlp

xysg    lda     xmgx-$0800,x
        sty     $05
        beq     xmex

        jsr     $ffd2
        iny
        inx
        bne     xysg

        txa

xmex    sei
        tay
        clc
        tax
        rts


*=$20bf

        ;       detecting emulator #2

emul2   bne     emma

        lda     $dfff
        cmp     #$55
        beq     emlp
        cmp     #$aa
        bne     amma

emlp    eor     #$ff
        cmp     $dfff
        bne     amma

        dey
        bne     emlp

ymmy    lda     $fffe
        cmp     #$17
        bne     yamm

        ldy     #$24
        lda     #$2c
        sty     jmme
        sta     dmme

yamm    ldy     #$00
emma    rts

amma    sty     $d0fe
        cpy     $d0fe
        beq     ymmy

        jsr     emul3
        beq     ymmy
        rts

        ;       speed test

stest   cmp     xrts-$0800
        beq     xcont
srest   rts


*=$20fe

        ;       (C65 Basic fix) <- $20fe (see also at $1cfe/$14fe/$13fe)

        byte    $00,$00

        ;       C65 DMA tables

dma1    byte    $00,$00,$01
        byte    $00,$13,$00
d1lb    byte    $00
d1hb    byte    $00
d1mb    byte    $00
        byte    $00

dma2    byte    $00,$00,$01
d2lb    byte    $00
d2hb    byte    $00
d2mb    byte    $00
        byte    $00,$12,$00
        byte    $00,$00

dcmp    byte    $00,$55,$aa,$ff

mnit    jsr     init-$0800
xnit    txa

        ;       print "testing " + a + " memory" + b + "... "

mmsg    pha

        jsr     dmsg-$0800

        pla
        pha
        and     #$0f

        jsr     xmsg-$0800

        pla
        bpl     nosg

        lda     #$0b
        byte    $2c

nosg    lda     #$0e
        jsr     xmsg-$0800

mosg    jmp     fmsg-$0800

        ;       speed test (continuation)

xcont   jsr     pret-$0800
        jsr     pret-$0800

        lda     #$0a
        jsr     mmsg-$0800

        ;       testing main memory (on all machines)

        lda     $fc

bns3    bne     xach
        lda     #$07

        ora     $00
        sta     $00

        lda     #$f8
        and     $01
        sta     $01

xach    ldy     #$00
        lda     #$04

        ldx     $fc
        beq     buch

        cpx     #$08
        bne     nach

        ldx     #$3f
        sty     fach-$07ff
        stx     $ff00

nach    cpx     #$07
        bne     bach

        ldx     #$b0
        stx     bubi-$07ff

bach    cpx     #$05
        bcc     qach

        cpx     #$06
        bcc     bech
        bne     buch

        stx     tech-$07ff
        sty     $ff3f

        ldx     $38
        byte    $2c
bech    ldx     #$6f
        stx     falp-$07ff

buch    cmp     $2c
        bcs     qach

        lda     $2c

qach    cmp     #$13
        bcc     cech
        cmp     #$31
        ldx     #$31
        bcc     cach
bubi    cmp     #$c0
        bcc     cech
        tax
        lda     falp-$07ff
        bcs     xech
cach    txa
cech    sta     $03

        lsr
        lsr
        lsr
        lsr
        tax
        ora     #$10
        cmp     $03
        adc     #$02
        sta     $04

        lda     $1300,x
        beq     qalp

wralp   lda     ($03),y
        sta     ($02),y
        iny
        bne     wralp

realp   lda     ($03),y
        eor     ($02),y
        bne     pech
        sta     ($02),y
        lda     ($02),y
        bne     pech
        iny
        bne     realp

qalp    inc     $03
        lda     $03

falp    cmp     #$ff
        bcc     qach

        ;       testing main memory <- extended

xech    jsr     $14f3

pech    ldx     #$00
        lda     $fc

        pha
        php
        pha

bns4    bne     tech
        lda     #$07

        ora     $01
        sta     $01

tech    eor     #$08
        bne     hach

fach    sta     $ff3e

hach    pla
        plp
        sei
        php
        bcc     xcent
        beq     xorm

        cmp     #$08
        bcc     xcent

        ;       testing normal copy speed

xorm    pha

        jsr     ynit-$0800

        lda     #$13
        sta     $03
        stx     $04

xorp    stx     $05

xyrp    lda     ($04),y
        sta     ($02),y
        iny
        bne     xyrp

        jsr     meas-$0800

        dex
        bne     xorp

        pla
        bne     bont

        lda     $0a
        bne     xont

        lda     $fd
        cmp     #$03
xcent   bcc     xent

bont    cmp     #$09
        bne     xont

        lsr
        byte    $2c

        ;       testing ZP + SP speed (on C65, C128, DTV and SuperCPU)

xont    lda     #$0b
        sta     $07
        sta     jolp-$07fe

xolp    dex
        lda     #$a5
        cpx     #$03
        jsr     stolp-$0800
        txa
        jsr     stolp-$0800
        lda     #$48
        jsr     stolp-$0800
        bcs     xolp

        lda     #$4c
        jsr     stolp-$0800
        lda     #<rolp
        jsr     stolp-$0800

        dex
        lda     #$1a
        sta     ($06),y

        jsr     init-$0800

nolp    lda     $fd
        tsx
        cmp     #$03
        txa
        ldx     #$ff
        txs
        tax
        bcs     solp

jolp    jmp     $0b00

rolp    bcs     tolp

dolp    txs

        jsr     meas-$0800

        dey
        bne     nolp

xclp    lda     ($02),y
        sta     ($04),y
        iny
        bne     xclp
        beq     xent

        ;       ZP + SP on 65816

solp    tya
        clc

        ;       XBA

        byte    $eb

        ;       TCD (set Direct Page register to $yy00)

        byte    $5b

alap    lda     #$0f
        ora     #$f0

        ;       INC A

        byte    $1a

        bne     flap

        lda     #$02

        ;       DEC A

flap    byte    $3a
        inc     alap-$07ff

        ;       XBA

        byte    $eb

        lda     #$ff

        ;       XCE (switch over to native mode)

        byte    $fb

        ;       TCS (set 16-bit Stack Pointer)

        byte    $1b

        bcs     jolp

        ;       XCE (switch back to emulation mode)

tolp    byte    $fb

        lda     #$00
        sec

        ;       XBA

        byte    $eb

        lda     #$00

        ;       TCD (set Direct Page register back to zero)

        byte    $5b

        bcs     dolp

xent    plp
        php

        jsr     emsg-$0800

        plp
        pla
        bcc     xend
        beq     qont

        cmp     #$08
        bcc     xend
        beq     sent

        txa

tent    pha

        lda     #$8a
        jsr     mmsg-$0800

        inc     bank-$0800

        pla
        bne     bent

        ;       testing banks (on C65)

        jsr     vic3

        ldx     #$06

        ;       LDZ #$01

        byte    $a3,$01

        lda     #$1f
        sta     $05

        ;       INC A

        byte    $1a

        sta     $07

wclp    lda     ($04),y
        jsr     $ff77
        iny
        bne     wclp

        lda     $05

        ;       DEC A

        byte    $3a
        ora     #$10
        sta     $05

        inc     $07
        lda     $07
        cmp     #$e0
        bcc     wclp

        lda     #$1f
        sta     $05

        ;       INC A

        byte    $1a

        sta     $07

rclp    jsr     $ff74
        eor     ($04),y
        clc
        bne     zent
        jsr     $ff77
        iny
        bne     rclp

        lda     $05

        ;       DEC A

        byte    $3a
        ora     #$10
        sta     $05

        inc     $07
        lda     $07
        cmp     #$e0
        bcc     rclp

zent    jsr     vicv

        ;       DEZ

        byte    $3b
        beq     cent

stolp   sta     ($06),y
        iny
        bne     xend
        inc     $07
xend    rts

qont    beq     cont

        ;       testing banks (on C128)

bent    cmp     #$02
        dex
        bcs     texx
        ldx     #$e0
texx    lsr

        jsr     $0178

cent    jsr     emsg-$0800

sent    lda     #$07
        and     bank-$0800

cram    cmp     #$00
        bcc     tent

        lda     #$31
        sta     bank-$0800

        ;       (continuation)

cont    lda     vdc
        beq     mont

        lda     cbmy+1
        bne     mont

        ;       testing VDC memory (with DRAM set to 0-15 if necessary)

        jsr     cvnt

        ;       (continuation)

mont    lda     $fc
        cmp     #$08
        bne     dont

        sta     xlpr-$07fe
        sta     rep2-$07ff
        sta     gep2-$07fe

dont    lda     treu+2
        sta     reua-$07fe
        sta     reub-$07fe
        sta     reuc-$07fe

        lda     gedex+2
        sta     gee1-$07fe
        sta     gee2-$07fe

        eor     #$01
        ldy     #$02
        sta     gef1-$07fe
        sta     gef2-$07fe

        sty     $09
        iny
        lda     scpu
        sty     $03
        beq     eont

scpp    lda     scpu,y
        sta     sdma-$0801,y
        dey
        bne     scpp

        ldx     #<d65o
        ldy     #<d65i
        lda     $0a
        beq     dic

        ldx     #$02
        stx     dent-$07ff

        dex
        stx     $d03f

        ldx     #<dtmo
        ldy     #<dtmi

dic     jsr     vic3

dikk    lda     $09
        bne     gont

        pla
        tay
        pla

zejx    jsr     zeux+$0800

        lda     $fb
        sta     $0d

        lda     geo
        eor     #$0d
        bne     eont

        ldx     #<geoo
        ldy     #<geoi

gont    cmp     #$01
        bne     ront

rejx    jsr     reux+$0800

        pha
        tya
        pha

        lda     #$ff
        sta     $0c
        lda     $fe
        sta     $0d

        lda     reu
        eor     #$0d
        beq     rent

eont    jmp     nont-$0800

rent    lda     #$01
        ldx     #<reuo
        ldy     #<reui

ront    eor     #$03
        ora     #$04
        stx     dcl1-$07ff
        sty     dcl2-$07ff
        tax

        jsr     mnit-$0800

        ldy     $0c

dylp    iny

dmlp    cpy     #$ff
        lda     #$02
        bcs     derr
        cpy     $0d
        beq     dmla
        bcs     derr

dmla    eor     $09
        bne     yent

        lda     $0b
        bne     dent
        bcs     derr

        ;       testing SuperRAM

        txa
        pha

        jsr     supr-$0800
        bvc     dmrr

pikk    bpl     dikk

        ;       testing DMA (on C65 or DTV)

dent    cpy     #$04
        txa
        bne     yent
        bcs     yent
        cpy     #$01
        bne     dylp

        lda     #$d0
        ldx     #$20
        sta     dclx-$07ff

yent    txa
        pha
        pha

        jsr     reas-$0800

dcl1    jsr     d65o-$0800

        jsr     meas-$0800

        pla
        tax

dcl2    jsr     d65i-$0800

        jsr     meas-$0800

xlpr    lda     $1200,x
        eor     $1300,x
        bne     dmrr
        inx
        bne     xlpr

smrr    sec

dmrr    pla
        tax

dmnx    inx
        bcc     derr

dclx    cpx     #$00
        bne     dmlp

        lda     #$03
        dec     $03
        and     $03
        sta     $03
        tax
        lda     dcmp-$0800,x
        ldx     #$00

xlpw    sta     $1300,x
        inx
        bne     xlpw

        cmp     #$ff
        stx     dclx-$07ff
        bcc     dmlp
        bcs     dylp

derr    lda     $0a
        beq     ric

        lda     #$00
        sta     $d03f

ric     jsr     vicv

        jsr     emsg-$0800

nont    dec     $09
        bpl     pikk

        ;       testing colour RAM & C65/MEGA65 <- extended

        jsr     $14f9

        ;       printing results of measurement

        jsr     cia1-$0800

        jsr     pret-$0800

cres    tya
        asl
        asl
        asl
        tax

        lda     $10c0,x
        beq     zres

        tya
        sty     $07
        stx     $08

        jsr     xmsg-$0800

        sec
        lda     #$09
        sbc     $05
        tax

xres    lda     #$20
        jsr     $ffd2

        dex
        bne     xres

        ldy     $08
        jsr     yres-$0800

        sec
        lda     $02
ovlb    sbc     #$00
        sta     $02

        lda     $03
ovhb    sbc     #$00
        sta     $03

        lda     $04
        sbc     #$00
        sta     $04
        bcs     sres

        stx     $02
        stx     $03
        stx     $04

sres    jsr     num24

        jsr     pret-$0800

        ldy     $07

zres    cpy     #$07
        iny
        bcc     cres

rjmp    rts
        word    $14fc

        ;       print return

pret    lda     #$0d
        jmp     $ffd2

        ;       time-measuring subroutines

yres    lda     $10c2,y
        sta     $02
        lda     $10c3,y
        sta     $03
        lda     $10c4,y
        sta     $04

        ldx     $10c0,y
        bne     dres

rres    lsr     $04
        ror     $03
        ror     $02

dres    dex
        bne     rres
        rts

        ;       initialization for the first time

ynit    lda     $dd0d
        sta     cia1-$07ff
        lda     $dd0e
        sta     cia2-$07ff

        jsr     ynyt-$0800

        ;       calculating overhead (in average)

yrep    jsr     meas-$0800

        iny
        bne     yrep

        jsr     yres-$0800

        ldy     $02
        stx     $02
        lda     $03

        sty     ovlb-$07ff
        sta     ovhb-$07ff

ynyt    ldy     #$40
        txa

xnyt    dey
        sta     $10c0,y
        bne     xnyt

        ;       initialization for a new run

init    txa
anit    asl
        asl
        asl
        ldy     #$00
        sta     $08
        bcc     reas

xeas    pla
        tax

        ;       CIA reset

cia1    lda     #$00
        sta     $dd0d

cia2    lda     #$08
        sta     $dd0e
        lda     $dd0d
        rts

        ;       Each run of measurement is done for every page (i.e. 256 bytes)
        ;       being copied, and then they are summed up to 128 times at most
        ;       (i.e. up to 32K) from that it is divided back to a 1K average.

meas    jsr     cia2-$0800

        txa
        pha

        ldx     $08
        bmi     xeas

        lda     $10c1,x
        bmi     xeas

        tya
        pha

        ldy     $dd04
        lda     $dd05
        beq     ceas

        cpy     #$ff
        eor     #$ff
        bcc     meax
        clc
        beq     yeas

meax    pha
        tya
        eor     #$ff

        adc     $10c5,x
        sta     $10c5,x

        pla
        adc     $10c6,x
        sta     $10c6,x

        lda     #$00
        adc     $10c7,x
        sta     $10c7,x

        inc     $10c1,x

        lda     #$04
        ldy     #$01

ceax    cmp     $10c1,x
        beq     reax

        asl
        iny
        bcc     ceax

ceas    clc

yeas    pla
        tay

        pla
        tax

reas    lda     #$01
        sta     $dd0d

        lda     #$ff
        sta     $dd04
        sta     $dd05

        lda     #$19
        sta     $dd0e
        rts

reax    lda     $10c5,x
        sta     $10c2,x

        lda     $10c6,x
        sta     $10c3,x

        lda     $10c7,x
        sta     $10c4,x

        tya
        sta     $10c0,x
        bcs     ceas

        ;       #00 "normal"

xmgx    byte    $4e,$4f,$52,$4d,$41,$4c,$00

        ;       #01 "zp+sp"

        byte    $5a,$50,$2b,$53,$50,$00

        ;       #02 "vdc/load"

        byte    $56,$44,$43,$2f,$4c,$4f,$41,$44,$00

        ;       #03 "vdc/copy"

        byte    $56,$44,$43,$2f,$43,$4f,$50,$59,$00

        ;       #04 "vdc/fill"

        byte    $56,$44,$43,$2f,$46,$49,$4c,$4c,$00

        ;       #05 "dma"

sdma    byte    $44,$4d,$41,$00

        ;       #06 "reu"

        byte    $52,$45,$55,$00

        ;       #07 "geo"

        byte    $47,$45,$4f,$00

        ;       #08 "error"

        byte    $45,$52,$52,$4f,$52,$0d,$00

        ;       #09 "ok"

        byte    $4f,$4b,$0d,$00

        ;       #0a "cpu"

        byte    $43,$50,$55,$00

        ;       #0b " bank 1"

        byte    $20,$42,$41,$4e,$4b,$20
bank    byte    $31,$00

        ;       #0c "vdc dram "

        byte    $56,$44,$43,$20,$44,$52,$41,$4d,$20,$00

        ;       #0d "testing "

        byte    $54,$45,$53,$54,$49,$4e,$47,$20,$00

        ;       #0e " memory"

        byte    $20,$4d,$45,$4d,$4f,$52,$59,$00

        ;       #0f "... "

        byte    $2e,$2e,$2e,$20,$00


*=$260a

        ;       setting DRAM refresh rate (in VDC register #36)

vpts    lda     #$24
        tax
        jsr     wpts
vchr    lda     #$01
        bne     rdct
        jmp     $ff62


*=$2617

        ;       testing VDC memory

vdct    cmp     #$20
        bcc     adct
        bne     ndct

        asl     $05

ndct    lda     #$31
        cmp     ram
        beq     rdct

adct    txa
        pha

        lda     #$02
        jsr     anit-$0800

        jsr     aptx

        pla
        tax
        bne     nolo

lolp    lda     ($02),y
lolb    bit     $d600
        bpl     lolb
        sta     $d601
        iny
        bne     lolp

        jsr     meas-$0800

ninc    inc     $03
        lda     $03
        and     #$0f
        ora     #$20
        sta     $03
        sec
rdct    rts

nolo    cmp     #$03
        beq     rorp

        cmp     #$04
        beq     ancp
        bcs     zozp

        lda     #$03

ancp    php
        jsr     anit-$0800
        plp
        txa
        pha
        ldx     #$00
        bcc     cocp

        jsr     wplx

        dex
        ldy     #$20

cinc    jsr     coxp-$0800

rinc    pla
        tax
        ldy     #$00
        beq     ninc

rorp    lda     $05
        cmp     #$12
        bcc     ninc

ryrp    jsr     wplp
        lda     $d601
        cmp     ($02),y
cdct    clc
        bne     rdct
        iny
        bne     ryrp
        beq     ninc

zozp    jsr     wplp
        lda     $d601
        bne     cdct
        iny
        bne     zozp
        beq     rdct

cocp    ldx     #$21
        lda     #$20
        jsr     wpts

        lda     $05
        and     #$01
        bne     conp

        ldx     #$10
        jsr     wplx

        ldx     #$00
        jsr     coyp-$0800
        bcc     cinc

conp    lda     $05
        cmp     #$1f
        bne     cofp

        lda     #$3f

cofp    clc
        pha
        adc     #$02
        tax
        jsr     wplx

        jsr     bptx

        ldx     #$10
        jsr     wplx

        ldx     #$00
        jsr     coyp-$0800

        clc
        pla
        adc     #$01
        clc
        tax

        lda     #$20
        sta     $d600
        jsr     wplx

        ldx     #$00
        bcc     cinc

coyp    ldy     #$a0

coxp    txa
        pha

        ldx     #$18
        lda     #$1e
        jsr     wpts

        pla
        tax

corp    jsr     reas-$0800
        jsr     wplx
        jmp     meas-$0800


*=$26f7

        ;       testing SuperRAM

supr    ldx     #$00

        sta     sps1-$07fe
        sty     sps1-$07fd
        sta     sps2-$07fe
        sty     sps2-$07fd

        jsr     reas-$0800

scs1    lda     $1300,x

        ;       STA $yyxx00,X

sps1    byte    $9f,$00,$00,$00

        inx
        bne     scs1

        jsr     meas-$0800

scs2    lda     $1300,x

        ;       EOR $yyxx00,X

sps2    byte    $5f,$00,$00,$00

        bne     yerr
        inx
        bne     scs2

        jsr     meas-$0800

        sec

yerr    clv
        rts


*=$2727

        ;       REU transfer subroutines

reuo    lda     #$90
        pha
rep1    lda     #$13
        bne     reua

reui    lda     #$91
        pha
rep2    lda     #$12

reua    sta     $de03
reub    stx     $de05

        ldx     #$01
reuc    stx     $de08
        dex
        txa
        jmp     treu


*=$2743

        ;       GeoRAM transfer subroutines

geoo    jsr     gexy-$0800

gep1    lda     $1300,x
gef1    sta     $de00,x
        inx
        bne     gep1
        rts

geoi    jsr     gexy-$0800

gef2    lda     $de00,x
gep2    sta     $1200,x
        inx
        bne     gef2
        rts

gexy    txa
        stx     $02
        and     #$3f
        ldx     #$00
gee1    sta     $dffe
        tya
        asl     $02
        rol
        asl     $02
        rol
gee2    sta     $dfff
        rts


*=$2772

        ;       DMA transfer subroutines (on DTV)

dtmo    jsr     aplp
        sta     $d305

        lda     #$13
        sta     $d301

        lda     #$40
        sta     $d302
        bne     dtmr

dtmi    jsr     aplp
        stx     $d301
        sta     $d302

        lda     #$40
        ldx     #$12
        sta     $d305

dtmr    lda     #$00
        stx     $d304
        sta     $d300
        sta     $d303

        ldx     #$01
        jmp     wdmr+$0800


*=$27a4

        ;       DMA transfer subroutines (on C65)

d65o    lda     #<dma1
        stx     d1hb-$0800
        sty     d1mb-$0800
        bpl     d65r

d65i    stx     d2hb-$0800
        sty     d2mb-$0800
        lda     #<dma2

d65r    ldx     #$00
        stx     $d702
        ldx     #$19
        stx     $d701
        ldx     #$00
        sta     $d700
        rts


*=$27c6

        ;       (self-modification)

xylf    lda     #$2c
        ldy     #$03

        sta     zejx
        sta     rejx

xplp    lda     sns1,y
        sta     bns1,y
        sta     bns3,y
        lda     sns2,y
        sta     bns2,y
        sta     bns4,y
        dey
        bpl     xplp
        rts

sns1    sei
        jsr     $1ff5

sns2    sei
        jsr     $1fee


*=$27ee

        ;       (* = $1fee) <-> (* = $27ee)

xpax    beq     xpaq

xpaxx   txa
        tay

        jsr     swxz


*=$27f5

        ;       (* = $1ff5) <-> (* = $27f5)

xpix    beq     xpiq

xpixx   txa
        tay

        ;       TAZ / MAP

        byte    $4b,$5c

xpiq    ldy     $09
xpaq    lda     #$07
xrts    rts


*=$2800

        ;       MEGA65 = fast mode <- sys10240

m65on   sei
        lda     #$47
        sta     $d02f
        lda     #$53
        sta     $d02f
        lda     $d054
        ora     #$40
        bne     mfs


*=$2812

        ;       MEGA65 = slow mode <- sys10258

m65off  sei
        lda     #$47
        sta     $d02f
        lda     #$53
        sta     $d02f
        lda     $d054
        and     #$bf
mfs     sta     $d054
        lda     #$ff
        sta     $d02f
        cli
        rts


*=$282c

        ;       C65 = fast mode <- sys10284

c65on   sei
        lda     #$a5
        sta     $d02f
        lda     #$96
        sta     $d02f
        lda     $d031
        ora     #$40
        bne     cfs


*=$283e

        ;       C65 = slow mode <- sys10302

c65off  sei
        lda     #$a5
        sta     $d02f
        lda     #$96
        sta     $d02f
        lda     $d031
        and     #$bf
cfs     sta     $d031
        lda     #$ff
        sta     $d02f
        cli
        rts


*=$2858

        ;       DTV = fast mode <- sys10328

dtvon   sei
        lda     #$01
        sta     $d03f
        byte    $32,$99
        lda     #$03
        byte    $32,$00
        lda     #$20
        bne     dts


*=$2868

        ;       DTV = slow mode <- sys10344

dtvoff  sei
        lda     #$01
        sta     $d03f
        byte    $32,$99
        lda     #$00
        byte    $32,$00
        lda     #$00
dts     sta     $d03c
        lda     #$00
        sta     $d03f
        cli
        rts


*=$2880

        ;       C128 = fast mode <- sys10368
        ;       (also for Turbo Chameleon, MEGA65 and TDC)

c128on  lda     #$01
        ora     $d030
        bne     c128s


*=$2887

        ;       C128 = slow mode <- sys10375
        ;       (also for Turbo Chameleon, MEGA65 and TDC)

c128off lda     #$fe
        and     $d030
c128s   sta     $d030
        rts


*=$2890

        ;       detecting memory of C128 (four banks)
        ;       (copied to $0140 and run from there)

vc128   txa
        ldy     #$04

vlp1    sbc     #$40
        dey
        sec
        sta     $ff00
        sty     $13ff
        bne     vlp1

vlp2    adc     #$3f
        iny
        sta     $ff00
        cpy     $13ff
        beq     vlp2

vend    stx     $ff00

        cpy     #$02
        bcc     tend

        sta     $d0fe
        cmp     $d0fe
        bne     tend

        ldy     #$02
        lda     #$80

tend    sty     cram+1
        tay
        sta     $02
        bne     rend
        inc     $03
rend    rts

        ;       testing banks 1-3 (on C128)
        ;       (copied to $0178 and run from there)

        ror
        ror
        stx     $05
        ora     #$3f
        sta     $ff00
        pha

tlp1    dex
        stx     $03

tlp2    lda     ($03),y
        sta     ($02),y
        iny
        bne     tlp2

        cpx     #$05
        bcs     tlp1

tlp3    lda     ($03),y
        eor     ($02),y
        bne     terr
        sta     ($02),y
        lda     ($02),y
        bne     terr
        iny
        bne     tlp3

        inx
        stx     $03
        cpx     $05
        bcc     tlp3

terr    pla
        ldy     #$00
cbmy    sty     $ff00
        bcc     rend

        ;       testing banks 1-3 (on C128) <- extended

        jmp     $14f0

        ;       testing VDC memory (with DRAM set to 0-15 if necessary)

cvnt    jsr     dmsg-$0800

        lda     #$0c
        jsr     xmsg-$0800

        lda     x36+1
        sta     $02
        stx     $03
        jsr     num16

        jsr     fmsg-$0800

        ldy     #$18
        txa

vnit    dey
        sta     $10d0,y
        bne     vnit

vvnt    lda     #$20
        sty     $02
        sta     $03
        lsr
        sta     $05

        ;       testing VDC memory

jvnt    jsr     vdct-$0800
        inc     $05
        lda     $05
        bcs     evnt

cynt    ldy     x36+1
        cpy     #$0f
        bcs     cvct

        ;       setting DRAM refresh rate (in VDC register #36)

        iny
        jsr     vpts-$0800

        lda     #$91
        jsr     $ffd2

        jsr     pret-$0800

        inc     x36+1
        bne     cvnt

evnt    bne     jvnt

        cpx     #$05
        inx
        bcc     vvnt

        ;       testing VDC memory <- extended

        jsr     $14f6
        bcc     cynt

        byte    $24
cvct    clc

        jmp     emsg-$0800


*=$295a

        ;       CBM-II relocation (10586) <- Basic + 5721
        ;       (copied to $0110 in system bank and started there)

        sei
        lda     $fffe
        ldx     #$01
        cmp     #$d6
        beq     cbm2
        dex

cbm2    ldy     #<$1688
        lda     #>$1688

        stx     $01
        sty     $02
        sta     $03

        ldy     #$00
        ldx     #$03

cblp    lda     ($02),y
        sta     $0400,y
        iny
        bne     cblp

        inc     $03
        inc     $012d

        dex
        bne     cblp

        jmp     $0403


*=$2986

        ;       CBM-II code (10630) <- Basic + 5765 ( = $1688)
        ;       (copied to $0400 in system bank and started there)

        sei
        ldy     #$00

        ;       (* = $0403)

        ldx     #$fe
        sty     $02
        stx     $03
        sty     $04

        ;       counting banks

faxp    txa
        and     #$0f
        sta     $01

        sta     ($02),y
        ora     #$40
        iny
        sta     ($02),y
        dey

        dex
        cpx     #$ef
        bcs     faxp

fexp    txa
        and     #$0f
        cmp     #$0f
        sta     $01
        sta     $05
        tax
        bcs     fdxp

        lda     ($02),y
        cmp     $05
        bne     fdxp

        ora     #$40
        iny
        sta     $05

        lda     ($02),y
        dey
        cmp     $05
        beq     fxxp

fdxp    tya
        byte    $2c
fxxp    inc     $04
        sta     cndc-$2586,x

        dex
        cpx     #$0e
        bne     fexp

        ;       counting free pages in system bank

        lda     #$04
        sta     $05
        lda     #$cf

sacp    sta     $03
        sta     ($02),y
        sbc     #$01
        cmp     #$08
        bcs     sacp

cacp    adc     #$01
        sta     $03
        cmp     ($02),y
        bne     necp

        pha
        and     #$03
        eor     #$03
        bne     pacp

        inc     $05
        bne     nacp

necp    ora     #$03
        pha

nacp    sta     cndc-$2584,x
        inx

pacp    pla
        cpx     #$40
        bcc     cacp

        ;       evaluating +kb (4-38)

        lda     $05

sbcp    sbc     #$0a
        inx
        bcs     sbcp

        adc     #$3a
        sta     cnp2-$2586

        cpx     #$42
        lda     #$0e
        bcc     nbcp

        txa
        sbc     #$11

nbcp    sta     cnp1-$2586

        ;       print message

        ldx     #$00
        jsr     cmsg-$2586

        ldx     $04
        bne     qmex
        inx

qmex    jsr     cmsg-$2586

        ldx     #$15
        jsr     cmsg-$2586

        ;       testing main memory (all banks except system bank)

        sei
        lda     #$fe
        sty     $02
        sta     $03

        ;       writing to all banks

wmex    stx     $01
        lda     cndc-$2586,x
        beq     zmex

wmlp    sta     ($02),y
        adc     #$01
        iny
        bne     wmlp

        dec     $03
        bne     wmlp

        ldy     #$02

wzlp    sta     ($02),y
        iny
        bne     wzlp

        lda     #$fe
        sta     $03

zmex    inx
        cpx     #$10
        bcc     wmex

        tax
        clc

        ;       reading back (comparing and clearing)

rmex    stx     $01
        lda     cndc-$2586,x
        beq     fmex

rmlp    sta     $04
        lda     ($02),y
        eor     $04
        bne     xerr
        sta     ($02),y
        lda     ($02),y
        bne     xerr
        lda     #$01
        adc     $04
        iny
        bne     rmlp

        dec     $03
        bne     rmlp

        ldy     #$02
        sta     $04

rzlp    lda     ($02),y
        eor     $04
        bne     xerr
        sta     ($02),y
        lda     ($02),y
        bne     xerr
        iny
        bne     rzlp

        lda     #$fe
        sta     $03
        bne     fmex

xerr    ldx     #$0f
        stx     $01
        inx

fmex    inx
        cpx     #$10
        bcc     rmex

        ;       "sys1024"

        lda     $fffe
        ldy     #$01
        cmp     #$d6
        beq     fbmf
        dey

fbmf    sty     $01

        ldy     #$09
fblp    lda     cbsc-$2587,y
        dey
        sta     ($2d),y
        bne     fblp

        lda     #$0f
        sta     $01

        jsr     cmsg-$2586

        ldx     #$16
        jsr     cmsg-$2586

        ;       testing system bank

        sei
        lda     #$08
        ldx     #$32
        sty     $02
        sta     $03
        lsr

        ;       writing ($0800-$cfff)

wrex    sta     $04

wrey    lda     ($03),y
        sta     ($02),y
        iny
        bne     wrey

        inc     $03
        dec     $04
        bne     wrey

        lda     #$04
        dex
        bne     wrex

        asl
        sta     $03
        lsr

        ;       reading back (comparing and clearing)

rrex    sta     $04

        lda     cndc-$2576,x
        bne     rnex

nrey    lda     ($03),y
        eor     ($02),y
        bne     serr
        sta     ($02),y
        lda     ($02),y
        bne     serr
        iny
        bne     nrey

        inc     $03
        dec     $04
        bne     nrey

rnex    lda     $04
        adc     $03
        sta     $03

        inx
        cpx     #$32
        lda     #$04
        bcc     rrex

        ;       "sys5133"

        ldx     #$4c
        stx     $140d
        sta     $140f

        ldx     #$10
        byte    $2c
serr    ldx     #$11
        ldy     #$00

        ;       print message subroutine

cmsg    txa
        beq     cysg

cxlp    iny

cylp    lda     cmgx-$2587,y
        beq     cysp
        iny
        bne     cylp

cysp    dex
        bne     cxlp

cysg    lda     cmgx-$2586,y
        beq     cmex

        jsr     $ffd2
        iny
        bne     cysg

        tya

cmex    clc
        tay
        cli
        rts

        ;       #00 "cbm-ii (6509) with "

cmgx    byte    $0e,$93,$43,$42,$4d,$2d,$49,$49,$20,$28,$36,$35,$30,$39,$29,$20
        byte    $57,$49,$54,$48,$20,$00

        ;       #01-#0f "64" (...) "960"

        byte    $36,$34,$00
        byte    $31,$32,$38,$00
        byte    $31,$39,$32,$00
        byte    $32,$35,$36,$00
        byte    $33,$32,$30,$00
        byte    $33,$38,$34,$00
        byte    $34,$34,$38,$00
        byte    $35,$31,$32,$00
        byte    $35,$37,$36,$00
        byte    $36,$34,$30,$00
        byte    $37,$30,$34,$00
        byte    $37,$36,$38,$00
        byte    $38,$33,$32,$00
        byte    $38,$39,$36,$00
        byte    $39,$36,$30,$00

        ;       #10 "ok"

        byte    $4f,$4b,$0d,$00

        ;       #11 "error"

        byte    $45,$52,$52,$4f,$52

        ;       0 sys1024

cbsc    byte    $0d,$00,$00,$00,$9e,$31,$30,$32,$34,$00

        ;       #15 "k +xxk testing main memory... "

        byte    $4b,$20,$2b

cnp1    byte    $0e
cnp2    byte    $34

        byte    $4b,$0d,$0d,$54,$45,$53,$54,$49,$4e,$47,$20,$4d,$41,$49,$4e,$20
        byte    $4d,$45,$4d,$4f,$52,$59,$2e,$2e,$2e,$20,$00

        ;       #16 "testing system bank... "

        byte    $54,$45,$53,$54,$49,$4e,$47,$20,$53,$59,$53,$54,$45,$4d,$20,$42
        byte    $41,$4e,$4b,$2e,$2e,$2e,$20,$00

cndc


*=$2bcb

        ;       swapping memory at $1400 <-> $2c00

swalt   lda     #$38
        ldx     x36+1

        eor     salp+2
        sta     salp+2
        sta     selp+2

        lda     gedex+2
        stx     z36
        sta     zedex

        ldx     #$14
        lda     #$2c
        stx     $03

        jmp     swalx

swalp   lda     ($02),y
        pha
        lda     ($04),y
        sta     ($02),y
        pla
        sta     ($04),y
        iny
        bne     swalp

        inc     $03
        inc     $05
        dex
        bne     swalp

        rts


*=$2c00

        ;       testing colour RAM & C65/MEGA65 (at $1400) <- extended

clrext  jsr     mwap-$1800

        jsr     dmsg-$0800
        jsr     xysg-$0800
        jsr     fmsg-$0800

        lda     #$02
        sec
        sta     $09

        ;       C65/DTV <- 8-bit colour RAM

        lda     $fd
        eor     #$01
        sta     $0c
        beq     clrv

        lda     $0a
        beq     clrp1

clrv    jsr     vic3

        lda     #$ff
        sta     clrff-$17ff

clrp1   ldy     #$00
clrd8   lda     #$d8
        sty     $02
        sta     $03

        lda     #$04
        sta     $04

clrp2   txa
        sta     ($02),y
        eor     ($02),y
clrff   and     #$0f
        beq     clerr
        clc
clerr   inx
        bne     clrp2

        lda     #$0d
        sta     ($02),y
        iny
        bne     clrp2

        inc     $03
        dec     $04
        bne     clrp2

        ;       1K colour RAM on C64 (or in C64 mode)

        lda     $fc
        beq     clre

        ;       2 x 1K colour RAM on C128 (in native mode)

        eor     #$08
        bne     clrc

        lda     #$2f
        sta     $00

        lda     #$03
        eor     $01
        sta     $01

        ;       4510 instruction set (on C65)

clrc    lda     $0c
        bne     clrn

        ;       2K colour RAM on C65 (in native mode)

        lda     #$04
        eor     clrd8-$17ff
        sta     clrd8-$17ff

        lda     #$01
        eor     $d030
        sta     $d030

clrn    dec     $09
        bne     clrp1

clre    jsr     emsg-$0800

        lda     $0c
        bne     mwap

        jsr     zero-$1800

        ;       C65 mapper total

        jsr     sfinx-$1800
        jsr     sfinx-$1800

        lda     #$01
        jsr     zmsg-$1800

        ;       C65 DMA total

        jsr     dminx-$1800
        jsr     dminx-$1800

        lda     #$02
        jsr     zmsg-$1800

        lda     $ffff

        ;       INC A

        byte    $1a

        php

        jsr     fexx-$1800

        ;       MEGA65 total

        jsr     mega65

        jsr     swaz

        plp
        bne     myap

        ;       MAP

        byte    $5c

        nop

myap    lda     #$03
        jsr     zmsg-$1800

mwap    ldy     #$2d
mwlp    lda     zmgz-$1801,y
        ldx     xmgx-$0801,y
        sta     xmgx-$0801,y
        txa
        dey
        sta     zmgz-$1800,y
        bne     mwlp

        jmp     vicv


*=$2cc2

z36     byte    $00

        ;       #00 "colour ram"

zmgz    byte    $43,$4f,$4c,$4f,$55,$52,$20,$52,$41,$4d,$00

        ;       #01 "c65 mapper"

        byte    $43,$36,$35,$20,$4d,$41,$50,$50,$45,$52,$00

        ;       #02 "c65 dma"

        byte    $43,$36,$35,$20,$44,$4d,$41,$00

        ;       #03 "mega65"

        byte    $4d,$45,$47,$41,$36,$35,$00

        ;       #04 " total"

        byte    $20,$54,$4f,$54,$41,$4c,$00

        ;       #05

        byte    $00


*=$2cf0

        jmp     bnk128
        jmp     rex-$1800
        jmp     vdcext
        jmp     clrext-$1800

        ;       stack safety save (restore) <- $14fc (rjmp)

rwap    sei
        ldx     $fd
        ldy     #$00
        dex
        clc
        bne     rwax

        lda     $fc
        cmp     #$09
        bcc     rwax

        tya

        ;       TAZ / MAP

        byte    $4b,$5c

        lda     #$07
        ora     $00
        sta     $00

        lda     #$fe
        and     $01
        sta     $01

rwax    jmp     xest

rex     ldx     #$60
        cpx     mnxrts
srex    sec
        bne     rex+1

        cpx     ralt
        bne     srex

        jmp     mainxt

zmsg    jsr     xmsg-$0800

        lda     #$0b
        bcc     ztov


*=$2d34

zedex   byte    $df

ztov    sbc     $05
        pha
        lda     #$04
        jsr     xmsg-$0800
        pla
        tay

znov    lda     #$20
        jsr     $ffd2
        dey
        bpl     znov

        ldy     #$04

        lda     $03
        ora     $04
        bne     zmeg

        lda     $02
        cmp     #$10
        bcs     zmeg

        lsr
        stx     $02
        ror     $02
        lsr
        sta     $03
        ror     $02

        lda     #$4b
        bne     kbmb

zmeg    lsr     $04
        ror     $03
        ror     $02
        dey
        bne     zmeg

        lda     #$4d
kbmb    pha

        jsr     num16

        pla
        jsr     $ffd2

zero    jsr     pret-$0800

        sei
        clc
        stx     $02
        stx     $03
        stx     $04
        rts

zinc    inc     $02
        bne     zinx
        inc     $03
        bne     zinx
        inc     $04
zinx    rts

        ;       C65 mapper total

sfinx   ldx     #$0f

        ;       LDZ #$B3

        byte    $a3,$b3

zapp    stx     $05

        txa
        ora     #$e0
        tax

        tya

        ;       MAP

        byte    $5c

        lda     ende
        stx     ende
        bcc     dinx

        cpx     #$e4
        sty     ende
        sta     $07
        lda     ende
        bcc     xinx
        bne     sinx

        cpx     $07
        bne     sinx

xinx    jsr     zinc-$1800

sinx    sec

dinx    ldx     $05
        dex
        bpl     zapp

        tya

        ldx     $fc
        bne     ninx

        ;       TAZ

        byte    $4b

        byte    $2c

        ;       LDX #$E3

ninx    byte    $a2,$e3

        ;       MAP / TAZ

        byte    $5c,$4b

        sec
        nop
        rts

        ;       C65 DMA total

dminx   ldy     #$7f

damox   ldx     #$a0
        tya

dalp1   sta     $1300,y
        dey
        bpl     dalp1

        tay
        bcs     damin

        jsr     d65o-$0800
        beq     damoy

damin   cpy     #$04
        bcc     daxxx

        jsr     d65i-$0800

        tya
        tax

dalp2   cmp     $1200,x
        bne     damos
        dex
        bpl     dalp2

daxxx   jsr     zinc-$1800

damos   sec

damoy   dey
        bpl     damox

        sec
        rts

fexx    tya

        ;       MAP

        byte    $5c

        lda     #$fe
        and     $01
        sta     $01
        rts


*=$2e00

        ;       testing main memory (on all machines) (via $14f3) <- extended
        ;       (overwrite with $00/$55/$aa/$ff page by page then restore)

mainxt  ldx     $09
        cpx     #$0e
        beq     nain

        cmp     #$ff
        ldx     $fc
        bcc     cain
        beq     yain

        cpx     #$08
        bne     nain

yain    tya

eain    stx     $a000
        cpx     $a000
        sty     $a000
        bne     nain

        cpy     $a000
        beq     cain

nain    lda     #$a0
        sta     anul+1

cain    cpx     #$00
        beq     stax

        cpx     #$06
        bcc     ctax

        cpx     #$07
        bne     xtax

        ldx     #$04
        stx     xaix+1

ctax    tax
        bpl     xtax

        lda     #$40

xtax    ldx     #$00

stax    sta     $04

caix    cpx     #>mainxt
        beq     cinx

xaix    cpx     #$10
        bne     xalp

        ldx     #$10

xalp    stx     $03

calp    lda     ($02),y
        sta     $1300,y
        iny
        bne     calp

        txa
        beq     ciny

        inx
        bne     cine

ciny    ldy     #$06

cine    ldx     #$05
        sty     $05

cixx    lda     xcmp,x

cixw    sta     ($02),y
        iny
        bne     cixw

        ldy     $05

cixc    cmp     ($02),y
        bne     noxc
        iny
        bne     cixc

        byte    $24
noxc    clc

        ldy     $05
        bcc     coxc

        dex
        bpl     cixx

        ldx     $03

coxc    lda     $1300,y
        sta     ($02),y
        iny
        bne     coxc

        bcc     mnxrts

cinx    inx
        cpx     $04
        bne     caix

mnxrts  rts

        ;       Z80 code (for detecting CP/M cartridge):

        ;       NOP
        ;       LD A, $01
        ;       LD ($04FD), A   <- $14fd (zde)
        ;       LD ($CE00), A   <- $de00
        ;       NOP
        ;       JP $0000

z80     byte    $00,$3e,$01,$32,$fd,$04,$32,$00,$ce,$00,$c3,$00

xcmp    byte    $00,$55,$aa,$ff

        ;       stack safety save

swalx   ldx     #$00
        sta     $05

        lda     rest+1
        bne     xwalx

xwalp   lda     $0100,x
        sta     $295a,x
        lda     $1200,x
        sta     $2a5a,x
        inx
        bne     xwalp

        tsx
        txa
        adc     #$04
        tax

        lda     #$4c
        sta     rjmp-$0800

xwalx   stx     rest+1

        ldx     #$02
        jmp     swalp

        ;       stack safety save (restore)

xest    ldx     #$ff
rest    lda     #$00
        beq     mnxrts

        txs
        tax

reaa    lda     $295a,y
        sta     $0100,y
        lda     $2a5a,y
        sta     $1200,y
        iny
        bne     reaa

        dey

reay    lda     $295a,y
        dey
        pha
        bne     reay

        txs

        jmp     swax

        ;       testing banks 1-3 (on C128) (via $14f0) <- extended
        ;       (overwrite with $00/$55/$aa/$ff page by page then restore)

bnk128  tsx
        stx     $05

anul    ldx     #$00
        bne     mnxrts

        ldx     $fd
        bne     mnxrts

        asl
        rol
        rol
        and     #$03

        sty     $d506
        sta     $d50a

sylp    sty     $d509
        sty     $03
        txs

        ldy     #$05

plp1    pla
        inx
        sta     $1300,x
        bne     plp1

pylp    lda     xcmp,y

pwp     inx
        pha
        bne     pwp

prp     pla
        cmp     xcmp,y
        bne     berr
        inx
        bne     prp

        dey
        bpl     pylp

        byte    $24
berr    clc

        ldx     #$00
        ldy     $03
        txs

plp2    lda     $1300,x
        dex
        pha
        bne     plp2

        bcc     cerr

        iny
        bne     sylp

cerr    ldy     #$00
        lda     #$04
        ldx     $05

        sty     $d50a
        iny
        sty     $d509
        sta     $d506

        txs
        dey

ralt    rts

        ;       testing 16K/64K VDC memory (on C128) (via $14f6) <- extended
        ;       (overwrite with $00/$55/$aa/$ff page by page then restore)

vdcext  lda     #$60
        eor     zerr
        bne     vdcext+1

        tay

vrap    jsr     aptx

vmp1    bit     $d600
        bpl     vmp1
        lda     $d601
        sta     $1300,y
        iny
        bne     vmp1

        ldx     #$05

vxp     lda     xcmp,x
        stx     $03
        sta     $04

        jsr     aptx
        lda     $04

vxp1    bit     $d600
        bpl     vxp1
        sta     $d601
        iny
        bne     vxp1

        jsr     aptx
        lda     $04

vxp2    bit     $d600
        bpl     vxp2
        cmp     $d601
        bne     verr
        iny
        bne     vxp2

        ldx     $03
        dex
        bpl     vxp

        byte    $24
verr    clc

        ldy     #$00
        jsr     aptx

vmp2    lda     $1300,y
vmp3    bit     $d600
        bpl     vmp3
        sta     $d601
        iny
        bne     vmp2

        bcc     zerr

        lda     ram
        eor     #$36
        beq     vram

        lda     #$40

vram    inc     $05
        cmp     $05
        bne     vrap

zerr    rts

        ;       CP/M cartridge detection (by Z80 code)

cpmz80  jsr     cwap
        bne     cwyp

        sty     $de00
        nop

cwyp    ldy     #$0d

cwap    lda     z80-1,y
        pha
        lda     $0fff,y
        sta     z80-1,y
        pla
        dey
        sta     $1000,y
        bne     cwap

        lda     zde
        rts

        ;       MEGA65 total

mega65  lda     $d030
        pha
        and     #$46
        sta     $d030

        lda     $01
        pha
        and     #$f8
        sta     $01

        lda     #$40
        sty     $06
        sta     $07
        sty     $08
        sty     $09

        lda     #$c0
        sty     $0a
        sta     $0b

mokk    jsr     dekk
        bcs     mugr

        ;       LDA ($06),Z

        byte    $ea,$b2,$06

        sta     ($0a),y

        inc     $06
        tya

        ;       LDA ($06),Z

        byte    $ea,$b2,$06

        iny
        sta     ($0a),y
        dey

        dec     $06

mugr    lda     $08
        ora     $09
        bne     mokk

        lda     #$c0
        sta     $0b

sakk    jsr     dekk

        lda     $08
        bcs     sugr

        ;       STA ($06),Z

        byte    $ea,$92,$06

        lda     $09
        inc     $06

        ;       STA ($06),Z

        byte    $ea,$92,$06

        dec     $06

        lda     $08
sugr    ora     $09
        bne     sakk

        lda     #$c0
        sta     $0b

makk    jsr     dekk

        sty     $4000
        sty     $4001
        bcs     pakk

        ;       LDA ($06),Z

        byte    $ea,$b2,$06

        sta     $05
        tya

        ;       STA ($06),Z

        byte    $ea,$92,$06

        lda     $08
        ora     $09
        beq     hakk

        ;       LDA ($06),Z

        byte    $ea,$b2,$06

hakk    pha
        lda     ($0a),y

        ;       STA ($06),Z

        byte    $ea,$92,$06

        inc     $06
        tya

        ;       LDA ($06),Z

        byte    $ea,$b2,$06

        sta     $0d

        iny
        lda     ($0a),y
        dey

        ;       STA ($06),Z

        byte    $ea,$92,$06

        dec     $06

        tya
        sta     ($0a),y
        iny
        sta     ($0a),y
        dey

        pla
        bne     pakk

        lda     $08
        cmp     $05
        bne     pukk

        lda     $09
        cmp     $0d
        beq     yakk

        lda     $08
pukk    ora     $09
        bne     makk

yakk    ldy     #$04

zilp    jsr     zinc-$1800
        dey
        bne     zilp

pakk    lda     $08
        ora     $09
        bne     makk

        pla
        sta     $01

        pla
        sta     $d030
        rts

dekk    sec
        lda     $08
        sbc     #$04
        sta     $08
        bcs     sokk
        dec     $09

sokk    cmp     #$f0
        bcc     cekk

        lda     $09
        eor     #$0f
        beq     cekk

        clc

cekk    php

        sec
        lda     $0a
        sbc     #$02
        sta     $0a
        bcs     cokk
        dec     $0b

cokk    plp

        tya
        rts


*=$30c1

ende

        ;       compiled with CBM prg Studio v3.10 (by Arthur Jordison)
        ;       http://ajordison.co.uk/

        ;       Rosetta Interactive Fiction project homepage:

        ;       http://istennyila.hu/rosetta

        ;       v0.13 (c) 2012-2017 by Robert Olessak
