#include "UIEntity.as";
#include "UIElement.as";
#include "UIContainer.as";
#include "UIButton.as";
#include "UIImage.as";
#include "UITextfield.as";
#include "UI3Dobject.as";
#include "UIMenuCursor.as";
#include "MenuController.as";
#include "UIMenu.as";

funcdef void UI_BUTTON_CLICK();
funcdef void UI_MENU_ESC();
funcdef void UI_CURSOR_UPDATE(Vector3);
Vector3 GLOBAL_UI_SCALE;
class UI{

	Scene@ UIScene;
	Camera@ UICam;
	MenuController@ m_menuController;
	InputController@ m_inputController;
	Timer@ m_timer;
	
	//need main viewport camera!!!
	UI(Viewport@ viewport, Timer@ timer, int layer, Vector3 scale = Vector3(1,1,1)){
		@m_timer = @timer;
		GLOBAL_UI_SCALE = scale;
		OctreePartition UIP;
		@UIScene = Scene(UIP);
		@UICam  = Camera(-512, 512,287,-287, 0.0f, 1000.0f);
		viewport.addCamera(layer,UICam);

		UIScene.add(UICam);
		UICam.enable();
		@m_menuController = MenuController();
		@m_inputController = InputController(@m_menuController,@m_timer);
		m_inputController.repeat = false;

		m_inputController.pairs.add(InputControlPair(PK_LEFT, UI_left));
		m_inputController.pairs.add(InputControlPair(PK_RIGHT, UI_right));
		m_inputController.pairs.add(InputControlPair(PK_UP, UI_up));
		m_inputController.pairs.add(InputControlPair(PK_DOWN, UI_down));
		m_inputController.pairs.add(InputControlPair(PK_SPACE, UI_space));
		m_inputController.pairs.add(InputControlPair(PK_ESCAPE, UI_esc));

		m_inputController.setActive();

		

	}

	void Add(UIEntity@ ent){
		ent.AddToScene(UIScene);
	}

	void Register(UIMenu@ menu){
		m_menuController.Register(menu);
	}

}
