class UIElement:UIEntity{
	int m_width;
	int m_height;
	Vector3 m_position(0,0,0);
	Vector3 m_parentPos(0,0,0);
	Vector3 m_translatedPosition(0,0,0);
	Vector3 m_scale(1,1,1);
	bool visible = true;

	UIElement()
	{
		m_scale = GLOBAL_UI_SCALE;
	}

	void Translate(Vector3 pos){
		m_position += pos;
		TranslateFromParent();
		
	}

	void Position(Vector3 pos){
		m_position = pos;
		TranslateFromParent();
	}

	void SetParentPos(Vector3 pos){
		m_parentPos = pos;
		TranslateFromParent();
	}

	private void TranslateFromParent(){
		m_translatedPosition = m_parentPos + m_position;

		UpdateObjectPosition();
	}

	void UpdateObjectPosition(){

	}

	void Hide(){
		if(visible)
		{
			Translate(Vector3(0,9999,0));
			visible = false;
		}
	}

	void Show(){
		if(!visible)
		{
			Translate(Vector3(0,-9999,0));
			visible = true;
		}
	}

	void Scale(Vector3 newScale){
		m_scale = newScale;
		UpdateScale();
	}

	void UpdateScale(){
		
	};

	Vector3 GetPosition(){

		return m_position;

	}

}