enum MenuDir{
	hor,
	vert,
	none
}
class UIMenu{

	int _startSelected = 0;
	int _selected = -1;
	bool active = false;
	int m_dir = none;
	Vector3 _cursorOffset = Vector3(0,0,0);
	Array<UIButton@> _menuItems;
	UIMenuCursor@ m_cursor;
	UI_MENU_ESC @EscFunc;
	UI_MENU_ESC @SpaceFunc;
	UIMenu() {

	}

	UIMenu(MenuDir dir, int ss = -1, UIMenuCursor@ cursor = null){
		m_dir = dir;
		_startSelected = ss;

		@m_cursor = cursor;
	}

	void Enable(){
		_selected = _startSelected;
		active = true;
		if(@m_cursor != null){
			m_cursor.Show();
			m_cursor.SetOffset(_cursorOffset);
		}
		SetButtonStates();
		/*for(int i = 0; i<int(_menuItems.length()); i++){
			_menuItems[i].State(BS_Passive);
		}*/
	}

	void Disable(){
		active = false;
		for(int i = 0; i<int(_menuItems.length()); i++){
			_menuItems[i].State(BS_Disabled);
		}
		if(@m_cursor != null) m_cursor.Hide();
	}

	void AddMenuItem(UIButton@ item){

		_menuItems.add(@item);
		SetButtonStates();
	}

	void next(){
		_selected++;
		if(_selected == int(_menuItems.length()) ){
			_selected = 0;
		}
		SetButtonStates();
	}

	void prev(){
		_selected--;
		if(_selected < 0){
			_selected = int(_menuItems.length() )-1;
		}
		SetButtonStates();
	}

	void MenuAction(InputControllerAction action){
		if(active){
			switch(action){

				case UI_up:
				echo("\nup");
					if(m_dir == vert){
						prev();
					}
				break;

				case UI_down:
					if(m_dir == vert){
						next();
					}
				echo("\ndown");
				break;

				case UI_left:
					if(m_dir == hor){
						prev();
					}
				echo("\nleft");
				break;

				case UI_right:
					if(m_dir == hor){
						next();
					}
				echo("\nright");
				break;

				case UI_enter:
				echo("\nenter");
				break;

				case UI_space:
				echo("\nspace");
				if(_selected >-1)
				{
					_menuItems[_selected].OnClick();
				}
				if(@SpaceFunc != null )SpaceFunc();
				break;

				case UI_esc:
				echo("\nesc");
				if(@EscFunc != null )EscFunc();
				break;

				default:

			}
		}
	}

	void SetButtonStates(){

		for(int i = 0; i<int(_menuItems.length()); i++){
			if(_selected == i){
				_menuItems[i].State(BS_Active);
				if(@m_cursor != null){
					m_cursor.Move(_menuItems[i].GetPosition());
				}
			} else {
				_menuItems[i].State(BS_Passive);
			}
			
		}
	}

	void SetCursorOffset(Vector3 offset){
		_cursorOffset = offset;
	}
}