//  Actor.as
//	Depends on:
//	-GameObject.as
//	-geom.as
//	-intersect.as
//	-InputController.as

#include "GameObject.as";

class Actor:GameObject,InputControllerFunctions,InputControllerInterface {
	Box@ stage;
	Timer@ timer;
	float speed;
	ActorBehaviour@ actorBehaviour;
	Actor() {
		
	}
	Actor(Timer@ t, Scene@ s) {
		@timer = @t;
		@scene = @s;
	}
	Actor(Timer@ t, Scene@ s, ActorBehaviour@ ab) {
		@timer = @t;
		@scene = @s;
		@actorBehaviour = @ab;
		@ab.actor = this;
	}	
	~Actor() {
		//echo("removed Actor\n");
	}
	void check() {
		//echo("check \n");
	}
	void addToIntersect(int ig) {
		intersectGroup = ig;
		if (!intersect) {
			intersect = true;
			if (@INTERSECT_LIST.get(intersectGroup) != null) {
				INTERSECT_LIST.get(intersectGroup).add(this);
			}	
		}
	}
	void removeFromIntersect() {
		if (intersect) {
			intersect = false;
			if (@INTERSECT_LIST.get(intersectGroup) != null) {
				INTERSECT_LIST.removeFromGroup(intersectGroup, this);
			}
		}	
	}	
	void removeFromScene() {
		removeFromIntersect();
		if (@controller !is null) {
			controller.remove();
			@controller = null; 
		}
		@timer = null;
		GameObject::removeFromScene();
	}
	void intersectAction(Base@ obj) {
	
	}
}