#include "Base.as";
#include "../misc/geom.as";
#include "GameObjectProperties.as";

funcdef void ENTITY_CALLBACK();

class GameObject:Base {
	Array<GameObjectProperties@> arrProperties;
	
	
	float width = 1;
	float height = 1;
	float length = 1;
	float angle = 0;
	Vector3 zAxis(0,0,1);
	Vector3 zAxisInit(0,0,1);
	Quaternion quaternion;
	
	int idNr = 0;
	Base@ parent; 
	Vector3 scaleVal(1,1,1);
	private uint ids = 0; 
	Timer@ timer;
	Object@ joinObject;
	
	GameObject() {
		// empty constructor
	}
	~GameObject() {
		//echo("remove gameObject");
		//removeFromScene();
	}
	uint addChild(Object@ obj) {
		return addChild(obj, Vector3(0,0,0));
	}
	
	uint addChild(GameObject@ obj) {
		return addChild(obj, Vector3(0,0,0));
	}	
	
	uint addChild(Object@ obj, Vector3 pos) {
		GameObjectProperties prop;
		if (addedToScene) {
			scene.add(obj);
			obj.setPosition(quaternion.rotVector3(position+pos));
		}
		@prop.object = @obj;
		return setProperties(@prop, pos);
	}
		
	uint addChild(GameObject@ obj, Vector3 pos) {
		GameObjectProperties prop;
		
		if (addedToScene) {
			obj.addToScene(scene);
			obj.setPosition(quaternion.rotVector3(pos));
		}		
		//@obj.parent = this;
		@prop.gameObject = @obj;
		prop.type = 1;
		return setProperties(@prop, pos);		
	}
	
	private uint setProperties(GameObjectProperties@ prop, Vector3 pos) {
		prop.id = ids;
		prop.position = quaternion.rotVector3(pos);
		prop.localPosition = pos;	
		arrProperties.add(@prop);	
		return ids++;
	}
	
	void join(Object@ object, Timer@ t) {
		@joinObject = object;
		@timer = @t; 
		timer.elapsed += Action(this.updateOnJoined);		
	}
	
	private void updateOnJoined() {
		//this.rotate(joinObject.quaternion);
		//echo(String(joinObject.quaternion
		this.setRotation(joinObject.quaternion);
		//this.setPosition(joinObject.position);
	}
	
	void setRotation(Quaternion q) {
		quaternion = q;
		for (uint i = 0; i < arrProperties.length(); i++) {
			arrProperties[i].position = q.rotVector3(arrProperties[i].localPosition);
			if (arrProperties[i].type == 0) {
				Object@ object = @arrProperties[i].object;
				object.setPosition(arrProperties[i].position+position);
				object.setRotation(q);
			} else {
				GameObject@ object = @arrProperties[i].gameObject;
				object.setPosition(arrProperties[i].position+position);
				//object.setRotation(q);
				//object.rotate(q);
			}
		}			
	}
	
	void rotate(Vector3 a, float r) {
		rotate(Quaternion(a, r));
	}
	
	void rotate(Quaternion q) {
		quaternion = quaternion*q;
		//quaternion = q;
		zAxis = q.rotVector3(zAxis);
		for (uint i = 0; i < arrProperties.length(); i++) {
			arrProperties[i].position = q.rotVector3(arrProperties[i].position);
			if (arrProperties[i].type == 0) {
				Object@ object = @arrProperties[i].object;
				Quaternion qt = object.quaternion.inverse()*q;
				object.setPosition(arrProperties[i].position+position);
				object.rotate(q);
			} else {
				GameObject@ object = @arrProperties[i].gameObject;
				Quaternion qt = object.quaternion.inverse()*q;
				object.setPosition(arrProperties[i].position+position);
				object.rotate(qt);			
			}
		}			
	}
	
	void relRotate(Vector3 a, float r) {		
		relRotate(Quaternion(a, r));	
	}
			// int key = ObjectList.iterate();
			// Object@ obj = ObjectList.get(key);	
			// Vector3 newPos = quaternion.rotVector3(objRelPos.get(key));
			// objPos.insert(key, newPos);
			// obj.setPosition(newPos+position);
			
	void relRotate(Quaternion q) {		
		Quaternion origRot = quaternion;
		Quaternion quatInv = quaternion.inverse();
		quaternion = quaternion*q;
		zAxis = quaternion.rotVector3(zAxisInit);
		for (uint i = 0; i < arrProperties.length(); i++) {
			arrProperties[i].position = quaternion.rotVector3(arrProperties[i].localPosition); 
			if (arrProperties[i].type == 0) {
				Object@ object = @arrProperties[i].object;
				
				object.setPosition(arrProperties[i].position+position);	
				if (object.quaternion.rotVector3(Vector3(0,0,1)) == origRot.rotVector3(Vector3(0,0,1))) {
					object.relRotate(q);
				} else {
					Quaternion rotDiffrence = quatInv*object.quaternion;
					rotDiffrence.normalize();
					object.relRotate(object.quaternion.inverse());
					object.relRotate(quaternion*rotDiffrence);				
				}
			} else {
				GameObject@ object = @arrProperties[i].gameObject;
				
				object.setPosition(arrProperties[i].position+position);	
				if (object.quaternion.rotVector3(Vector3(0,0,1)) == origRot.rotVector3(Vector3(0,0,1))) {
					object.relRotate(q);
				} else {
					Quaternion rotDiffrence = quatInv*object.quaternion;
					rotDiffrence.normalize();
					object.relRotate(object.quaternion.inverse());
					object.relRotate(quaternion*rotDiffrence);				
				}		
			}
		}	
	}
	
	
	void translate(Vector3 v) {
		position += v;
		// if (intersect) {
			// intersectTest(this);
		// }		
		translateAllChildrenWorld(position);				
	}
	
	void relTranslate(Vector3 v) {
		v = quaternion.rotVector3(v);
		position += v;
		translateAllChildrenWorld(position);				
	}	
	
	private void translateAllChildrenWorld(Vector3 v) {
		for (uint i = 0; i < arrProperties.length(); i++) {
			if (arrProperties[i].type == 0) {
				if (arrProperties[i].object !is null) {
					arrProperties[i].object.setPosition(arrProperties[i].position+v);
				}
			} else {
				arrProperties[i].gameObject.setPosition(arrProperties[i].position+v);
			}
		}		
	}
	
	void scale(float s) {
		scale(Vector3(s,s,s));
	}
	
	void scale(Vector3 s) {
		width = width*s.x;
		length = length*s.y;
		height = height*s.z;
		scaleVal += s;
		for (uint i = 0; i < arrProperties.length(); i++) {
			if (arrProperties[i].type == 0) {
				arrProperties[i].object.scale(s);
			} else {
				arrProperties[i].gameObject.scale(s);
			}
			setChildPosition(@arrProperties[i], arrProperties[i].localPosition*s);
		}			
	} 
	
	void setChildPosition(int objId, Vector3 v) {
		GameObjectProperties@ prop = getChildPropertiesById(objId);
		setChildPosition(prop, v);
	}
	
	void setChildPosition(Object@ child, Vector3 v) {
		GameObjectProperties@ prop = getChildProperties(child);
		setChildPosition(prop, v);
	}
	
	void setChildPosition(GameObject@ child, Vector3 v) {
		GameObjectProperties@ prop = getChildProperties(child);
		setChildPosition(prop, v);
	}
	
	void setChildPosition(GameObjectProperties@ prop, Vector3 v) {
		prop.localPosition = v;
		prop.position = quaternion.rotVector3(v);
		if (prop.type == 0) {
			prop.object.setPosition(prop.position+position);	
		} else {
			prop.gameObject.setPosition(prop.position+position);	
		}
	}
	
	void translateChild(uint objId, Vector3 v) {
		GameObjectProperties@ prop = getChildPropertiesById(objId);
		if (prop.exists) {
			prop.localPosition = prop.localPosition+v;
			prop.position = quaternion.rotVector3(prop.localPosition);
			if (prop.type == 0) {
				prop.object.setPosition(prop.position+position);
			} else {
				prop.gameObject.setPosition(prop.position+position);
			}			
		}
	}	
	
	void setPosition(Vector3 v) {
		position = v;
		for (uint i = 0; i < arrProperties.length(); i++) {
			if (arrProperties[i].type == 0) {
				arrProperties[i].object.setPosition(arrProperties[i].position+position);
			} else {
				arrProperties[i].gameObject.setPosition(arrProperties[i].position+position);
			}
		}		
	}
	
	void addToScene(Scene@ s) {
		if (addedToScene) {
			echo("WARNING: GameObject already added to a scene\n");
		} else {
			addedToScene = true;
			@scene = @s;
			for (uint i = 0; i < arrProperties.length(); i++) {
				if (arrProperties[i].type == 0) {
					arrProperties[i].object.setPosition(arrProperties[i].position+position);
					scene.add(arrProperties[i].object);
				} else {
					arrProperties[i].gameObject.setPosition(arrProperties[i].position+position);
					arrProperties[i].gameObject.addToScene(scene);
				}
			}
			Base::addToScene(s);
		}	
		
	}
	
	void removeFromScene() {
		if (@parent !is null) {
			GameObject@ tempRef = cast<GameObject@>(@parent);
			tempRef.removeChild(this);
		} else {
			if (addedToScene) {
				for (uint i = 0; i < arrProperties.length(); i++) {
					if (arrProperties[i].type == 0) {
						scene.remove(arrProperties[i].object);
						@arrProperties[i].object = null;
					} else {
						arrProperties[i].gameObject.removeFromScene();
					}
					//echo("Remove at "+String(i)+" length: "+String(arrProperties.length())+"\n");
					//arrProperties.removeAt(i--);
					//echo("removed\n");
				}				
				addedToScene = false;
			} else {
				echo("WARNING: GameObject can't be removed because it's not added to a scene\n");
			}
			@scene = null;	
			Base::removeFromScene();
		}
	}
	
	void removeChild(GameObject@ obj) {
		for (uint i = 0; i < arrProperties.length(); i++) {
			if (@arrProperties[i].gameObject is @obj) {
				echo("bla\n");
				arrProperties.removeAt(i--);
				break;
			}
		}
		@obj.parent = null;
		obj.removeFromScene();		
	}
	
	void removeChild(Object@ obj) {
		for (uint i = 0; i < arrProperties.length(); i++) {
			if (@arrProperties[i].object is @obj) {
				arrProperties.removeAt(i--);
				break;
			}
		}		
		scene.remove(obj);
	}	
	
	GameObjectProperties@ getChildProperties(Object@ object) {
		for (uint i = 0; i < arrProperties.length(); i++) {
			if (@arrProperties[i].object is @object) {
				return @arrProperties[i];
			}
		}
		return getEmptyProp();
	}
	
	GameObjectProperties@ getChildProperties(GameObject@ gameObject) {
		for (uint i = 0; i < arrProperties.length(); i++) {
			if (@arrProperties[i].gameObject is @gameObject) {
				return @arrProperties[i];
			}
		}
		return getEmptyProp();
	}	
	// GameObjectProperties@ getChildPropertiesById(int objId) {
		// return getChildPropertiesById(uint(objId));
	// }
	GameObjectProperties@ getChildPropertiesById(uint objId) {
		for (uint i = 0; i < arrProperties.length(); i++) {
			if (arrProperties[i].id == objId) {
				return @arrProperties[i];
			}
		}
		echo("WARNING: GameObject with ID objId doesn't exist\n");
		return getEmptyProp();
	}
	
	GameObjectProperties@ getEmptyProp() {
		GameObjectProperties prop;
		prop.exists = false;	
		return @prop;
	}
}