class GravitySource {
	Vector3 position;
	Vector3 direction;
	float mass;
	float startAttenuation;
	float range;
	Vector3 scale;
	bool directional = false;
	int type = 0;
	AIBox@ box;
	GravitySource(Vector3 pos, float m, float f = 0, bool dir=false) {
		position = pos;
		mass = m;
		startAttenuation = f;
	}
	GravitySource(Vector3 pos, Vector3 dir, float m, float f = 0, int t=0) {
		if (t == 0) {
			startAttenuation = f;
			directional = true;	
			mass = m;			
		} else {
			scale = Vector3(m,m,m);
		}
		
		type = t;
		position = pos;
		direction = dir;
	}
	GravitySource(Vector3 pos, Vector3 s, Quaternion n, float i) {
		position = pos;
		type = 2;
		direction = n.rotVector3(Vector3(0,0,-1));
		scale = s;
		@box = AIBox(pos, s, n);
	}
}

class GravityManager {
	Array<GravitySource@> sources;
	Array<Entity@> arrEntities;
	Array<Vector3> arrEntityGravTarget;
	float G = 10;
	float maxRange = 0;
	int count = 0;
	GravityManager() {
		CONTROL.stepped += StepCallback(this.eval);
	}
	
	void registerSource(GravitySource@ source) {
		sources.add(source);
	}
	
	void registerEntity(Entity@ entity) {
		arrEntities.add(entity);
		
		arrEntityGravTarget.add(Vector3(0,0,10));
		if (entity.proxy !is null) {
			entity.proxy.disableWorldGravity();
			entity.proxy.gravity = Vector3(0,0,-10);
		}	
	}

	void eval(float t) {
		float tval = t*0.02;
		for (uint i = 0; i < arrEntities.length(); i++) {	
			if (arrEntities[i].proxy !is null) {
				Vector3 grav = calcGrav(arrEntities[i].position);
				if (grav.length() > 0.0001) { 
					arrEntityGravTarget[i] = grav;
				}	
				
				Vector3 pn = arrEntities[i].proxy.gravity.normalized();
				Vector3 tn = arrEntityGravTarget[i].normalized();		
				float r = pn.dot(tn);

				if (r < 0.99) {
					Vector3 axis = pn.cross(tn).normalized();
					//Vector3 newV = rotate3D(arrEntities[i].proxy.gravity, axis, (PI*0.2)*tval);
					Vector3 newV = rotate3D(arrEntities[i].proxy.gravity, axis, acos(r)*tval);
					arrEntities[i].proxy.gravity = newV;
				} else {
					arrEntities[i].proxy.gravity = arrEntityGravTarget[i];
				}
			}
		}
	}
	
	Vector3 calcGrav(Vector3 affectedPosition) {
		Vector3 result = Vector3(0,0,0);
		Array<uint> arrAbsoluteSources;
		for (uint i = 0; i < sources.length(); i++) {
			Vector3 d;
			if (sources[i].type != 0) {
				d = sources[i].position - affectedPosition;
				if (sources[i].type == 2) {
					if (sources[i].box.containsPoint(affectedPosition)) {
						
						arrAbsoluteSources.add(i);
					}
				} else if (sources[i].type == 1 && d.length() < sources[i].scale.x) {
					arrAbsoluteSources.add(i);
				}				
			} else if (arrAbsoluteSources.length() < 1) {	
				if (!sources[i].directional) {
					d = sources[i].position - affectedPosition;
				} else {	
					d = affectedPosition - TPlane(sources[i].position, sources[i].direction).getNearestPoint(affectedPosition);
				}
				if (sources[i].startAttenuation > 0.1) {
					if (d.length() < sources[i].startAttenuation) {
						d = d.normalized()*sources[i].startAttenuation;
					}
				}
				result += d.normalized()*((G*sources[i].mass) / d.length2());
			}
		}
		
		if (arrAbsoluteSources.length() > 0) {	
 			//echo(String(arrAbsoluteSources.length()));
			uint nearest = 0;
			for (uint i = 0; i < arrAbsoluteSources.length(); i++) {
				//result += sources[arrAbsoluteSources[i]].direction; 
				float l = (sources[arrAbsoluteSources[i]].position - affectedPosition).length();
				float n = (sources[arrAbsoluteSources[nearest]].position - affectedPosition).length();
				nearest = (l < n) ? i : nearest; 
				//result += sources[arrAbsoluteSources[i]].direction; 
			}
			//return result*20;
			return sources[arrAbsoluteSources[nearest]].direction*20;
			//return result*20;
		}			
		return result;
	}
}

class AIBox {
	Vector3 min;
	Vector3 max;
	Quaternion orientation;
	Vector3 position;
	Vector3 scale;
	float centerDistance = 0.1;
	Object@ pObj;
	AIBox(Vector3 pos, Vector3 s, Quaternion n) {
		position = pos;
		scale = s;
		orientation = n;
		min = position-scale/2;
		max = position+scale/2;
	}
	AIBox() {
		//empty constructor
	}
	bool containsPoint(Vector3 p) {
		p = orientation.inverse().rotVector3(p-position) + position;
		if (p.x < max.x && p.x > min.x && p.y < max.y && p.y > min.y && p.z < max.z && p.z > min.z) {	
			return true;
		}
		return false;		
	}	
}

class TPlane {
	Vector3 p, n;
	TPlane(Vector3 pos, Vector3 normal) {
		p = pos;
		n = normal;
	}
	Vector3 getNearestPoint(Vector3 v) {
		float sb, sn, sd;
	
		sn = (this.n.dot(v - this.p));
		sd = this.n.dot(this.n);
		sb = sn / sd;

		return v + this.n * sb;
	}
}

