

class Level {
	Object@ skyBox;
	GravityManager@ gravityManager;
	
	Array<Vector3> spawnLocations;
	Array<AIBox@> arrJumpPads;
	Array<AIBox@> arrHealthPickup;
	Array<uint> arrHealthPickupTaken;
	
	Array<PointLight@> arrPointLights;	
	Array<DirectionalLight@> arrDirectionalLights;	
	Object@ level_geom;
	Object@ level_geom_collision;
	Object@ level_geom_logo;
	Object@ proxyObject;
	ObjectAnimation@ anim;
	
	
	Level(String levelLocator, String skyBoxLocator) {
		@skyBox = objectFactory.load(skyBoxLocator);
		skyBox.setPosition(Vector3(0,0,0));
		skyBox.model.setDrawMode(DM_EMISSIVE);
		SKYBOX_SCENE.add(skyBox);
		MAIN_CAM.link.add(SKYBOX_CAM, LM_OVERRIDE, LT_ROTATION);		
		
		@gravityManager = GravityManager();
		
		DirectionalLight@ dirlight = DirectionalLight();
		dirlight.setPosition(0,0,10);
		//dirlight.rotate(1, 0, 0, -0.7*PI);
		//dirlight.color = Color(255,255,255,255);
		dirlight.color = Color(40,40,40,255);
		arrDirectionalLights.add(dirlight);
		MAIN_SCENE.add(dirlight);

		DirectionalLight@ dirlight2 = DirectionalLight();
		dirlight2.rotate(0, 0, 1, PI*0.4);
		dirlight2.color = Color(80,80,80,255);
		arrDirectionalLights.add(dirlight2);
		MAIN_SCENE.add(dirlight2);

		//MAIN_SCENE.world.gravity = Vector3(0,0,-9.8);

		// gravityManager.registerSource(GravitySource(Vector3(0,0,0),  Vector3(0,0,-1),7, 0, 1));
		// gravityManager.registerSource(GravitySource(Vector3(-7,0,0),  Vector3(0,0,1), 7, 0, 1));
		// gravityManager.registerSource(GravitySource(Vector3(0,0,-50), 1000, 50));	
		
		@level_geom = objectFactory.load(levelLocator);
		@level_geom_collision = objectFactory.load("../../Assets/3D/dm1_collision.fbx");
		@level_geom_logo = objectFactory.load("../../Assets/3D/dm1_logo.fbx");
		parseGeom(level_geom);
		parseLocators(level_geom);
		@proxyObject = Object();
		@proxyObject.proxy = MAIN_SCENE.world.createProxy(PT_STATIC);
		proxyObject.proxy.addTriangleMesh(level_geom_collision.model);
		//@level_geom_logo.animator = Animator();
		MAIN_SCENE.add(level_geom);	
		MAIN_SCENE.add(level_geom_logo);	
		MAIN_SCENE.add(proxyObject);
		level_geom_logo.proxy.type = PT_KINEMATIC;		
		
		// @anim = ObjectAnimation("test", 5);
		// anim.addFrame(Quaternion(Vector3(0.0, 0, 1.0), 0));
		// anim.addFrame(Quaternion(Vector3(0.0, 0, 1.0), PI*0.5));
		// anim.addFrame(Quaternion(Vector3(0.0, 0, 1.0), PI));
		// anim.addFrame(Quaternion(Vector3(0.0, 0, 1.0), PI*1.5));
		// anim.build(IM_LINEAR);
		level_geom_logo.position = level_geom.getLocator("logo-loc").position;
		CONTROL.stepped += StepCallback(this.rotateLogo);
		//level_geom_logo.animator.play(anim, true);
	}
	
	~Level() {
		echo ("unloading level");
		unload();
	}
	
	void parseGeom(Object@ obj) {
		for (uint i = 0; i < obj.model.getSurfaceCount(); i++) {
			if (obj.model.getSurface(i).name.subString(0, 4) == "EMIS") {
				echo("set "+obj.model.getSurface(i).name+" to emissive");
				obj.model.getSurface(i).material.mode = DM_EMISSIVE;
			} else if (obj.model.getSurface(i).name.subString(0, 4) == "ADDI") {
				echo("set "+obj.model.getSurface(i).name+" to additive");
				obj.model.getSurface(i).material.mode = DM_ADDITIVE;
			}
		}	
	}
	
	void parseLocators(Object@ obj) {
		for (uint i = 0; i < obj.getLocatorCount(); i++) {
			if (obj.getLocator(i).name.subString(0, 4) == "GRAV") {
				echo("set grav trigger: "+obj.getLocator(i).name);
				gravityManager.registerSource(GravitySource(obj.getLocator(i).position,  obj.getLocator(i).scale, obj.getLocator(i).quaternion, 1));
			} else if (obj.getLocator(i).name.subString(0, 5) == "SPAWN") {
				echo("set spawn loaction: "+obj.getLocator(i).name);
				spawnLocations.add(obj.getLocator(i).position);
			} else if (obj.getLocator(i).name.subString(0, 5) == "HEALT") {
				echo("set health trigger: "+obj.getLocator(i).name);
				
				AIBox box = AIBox(obj.getLocator(i).position, obj.getLocator(i).scale, obj.getLocator(i).quaternion);
				@box.pObj = objectFactory.load("../../Assets/3D/health.fbx");
				//@box.pObj = objectFactory.createCube();
				box.pObj.model.setDrawMode(DM_EMISSIVE);
				box.pObj.quaternion = box.orientation;
				box.pObj.position = box.position+box.orientation.rotVector3(Vector3(0,0,1));
				MAIN_SCENE.add(box.pObj);
				arrHealthPickup.add(box);
				arrHealthPickupTaken.add(0);
				
			} else if (obj.getLocator(i).name.subString(0, 4) == "JUMP") {
				echo("set jump trigger: "+obj.getLocator(i).name);
				arrJumpPads.add(AIBox(obj.getLocator(i).position, obj.getLocator(i).scale, obj.getLocator(i).quaternion));
			} else if (obj.getLocator(i).name.subString(0, 5) == "LIGHT") {
				echo("adding point light: "+obj.getLocator(i).name);

				int r = hexToDec(obj.getLocator(i).name.subString(7, 2));
				int g = hexToDec(obj.getLocator(i).name.subString(9, 2));
				int b = hexToDec(obj.getLocator(i).name.subString(11, 2));

				PointLight@ light = PointLight();
				light.setPosition(obj.getLocator(i).position);
				light.scale(obj.getLocator(i).scale);
				light.color = Color(r,g,b,255);
				MAIN_SCENE.add(light);
				arrPointLights.add(light);
			} 
		}

		if (arrJumpPads.length() > 0) {
			CONTROL.stepped += StepCallback(this.checkJump);
		}
		if (arrHealthPickup.length() > 0) {
			CONTROL.stepped += StepCallback(this.rotatePickup);
		}			
		if (spawnLocations.length() < 1) {
			echo("WRANING: no spawn locations present in map file, adding location 0,0,0");
			spawnLocations.add(Vector3(0,0,0));
		}
	}
	
	void unload() {
		
		for (pUInt i = 0; i < arrPointLights.length(); i++) {
			MAIN_SCENE.remove(arrPointLights[i]);
		}

		for (pUInt i = 0; i < arrDirectionalLights.length(); i++) {
			MAIN_SCENE.remove(arrDirectionalLights[i]);
		}
		
		for (pUInt i = 0; i < arrHealthPickup.length(); i++) {
			MAIN_SCENE.remove(arrHealthPickup[i].pObj);
		}

		SKYBOX_SCENE.remove(skyBox);
		MAIN_SCENE.remove(level_geom);
		MAIN_SCENE.remove(level_geom_logo);
		MAIN_SCENE.remove(proxyObject);
		gravityManager.sources.length = 0;		
		spawnLocations.length = 0;
		arrJumpPads.length = 0;
		arrHealthPickup.length = 0;
		arrHealthPickupTaken.length = 0;

		CONTROL.stepped -= StepCallback(this.checkJump);
		CONTROL.stepped -= StepCallback(this.rotatePickup);
		CONTROL.stepped -= StepCallback(this.rotateLogo);
		
		arrDirectionalLights.length = 0;
		arrPointLights.length = 0;
		@level_geom = null;
	}
	
	void checkJump(float) {
		for (uint i = 0; i < arrJumpPads.length(); i++) {
			if (arrJumpPads[i].containsPoint(mainPlayer.body.position)) {
				mainPlayer.body.proxy.applyImpulse(arrJumpPads[i].orientation.rotVector3(Vector3(0,0,1))*50, Vector3(0,0,0));
			}
		}
	}	
	void rotatePickup(float t) {
		float tval = t*0.001;
		for (uint i = 0; i < arrHealthPickup.length(); i++) {
			//arrHealthPickup[i].pObj.relRotate(arrHealthPickup[i].orientation.rotVector3(Vector3(0,0,1)), tval);
			arrHealthPickup[i].pObj.relRotate(Vector3(0,0,1), tval);
		}
	}	
	void rotateLogo(float t) {
		float tval = t*0.0001;
	
		level_geom_logo.relRotate(Vector3(0,0,1), tval);

	}		
}

Array<String> hex = {"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
int hexToDec(String input) {
	int result = 0;
	for (uint i = 0; i < input.length(); i++) {
		for (uint j = 0; j < 16; j++) {
			if (input.subString(input.length()-(i+1), 1) == hex[j]) {
				result += int(j*pow(16, i));
			}
		}
	}
	return result;
}

