ResolutionPicker@ resolutionPicker;

UIElement@ ResolutionElement() {
  Color buttonColor = Color(163,163,163,255);
  int offset = 170;

  UIElement@ element = UIElement(Vector3(0,-1,10),450,400);
  element.setBackground(Color(66,80,88,255));
  element.ignoreDepthManager = true;
  Label@ title = Label(aldoFont,"Resolution");
  title.setScale(0.8);
  element.addChild(@title);
  element.setChildPosition(@title,Vector3(-130,0,0+offset));

  //ResolutionPicker
  @resolutionPicker = ResolutionPicker();
  element.addChild(@resolutionPicker.element);
  element.setChildPosition(@resolutionPicker.element,Vector3(0,0,-120+offset));
  ///////////////

  //fullScreen checkbox
  Label@ fsText = Label(aldoFont,"Fullscreen");
  fsText.setScale(0.6);
  element.addChild(@fsText);
  element.setChildPosition(@fsText,Vector3(-170,0,-180+offset));
  CheckBox@ fullscreenCheckbox = CheckBox(fullscreen);
  element.addChild(@fullscreenCheckbox.element);
  element.setChildPosition(@fullscreenCheckbox.element,Vector3(105,0,-205+offset));
  @fullscreenCheckbox.checkboxEvent = @setFullscreen;

  //////////////

  //Apply button
  UIElement@ applyButton = UIElement(Vector3(0,0,0),300,75);
  applyButton.setBackground(Color(163,163,163,255));
  Label@ applyText = Label(aldoFont,"Apply");
  applyText.setScale(0.8);
  applyButton.addChild(@applyText);
  applyButton.setChildPosition(@applyText,Vector3(-60,0,35));
  @applyButton.onClick = @applyResolution;
  element.addChild(@applyButton);
  element.setChildPosition(@applyButton,Vector3(0,0,-295+offset));
  ///////////////

  //closebutton
  UIElement@ closeButton = CloseElement();
  element.addChild(@closeButton);
  element.setChildPosition(@closeButton,Vector3(205,0,15+offset));
  closeButton.visible = false;
  //////////////// end close button
  return element;
}

void setFullscreen(bool state){
  fullscreen = state;
}

void applyResolution(UIEventInfo event){
  echo("new res "+String(resolutionPicker.width)+" x "+String(resolutionPicker.height));
  setGameWindow(resolutionPicker.width,resolutionPicker.height, fullscreen);
  //call whatever function creates new window, hopefully somwhere in main
}

class ResolutionPicker{
  UIElement@ element;
  UIElement@ btnPrev;
  UIElement@ btnNext;
  Label@ resolutionText;
  Array<String> resolutions;
  int selectedResolution = 0;
  pUInt resolutionCount = 0;

  int width = gameWidth;
  int height = gameHeight;

  ResolutionPicker(){
    parseResolutions();
    @element = UIElement(Vector3(0,0,0),340,60);
    element.setBackground(Color(32,32,32,255));
    //echo(String(ACTIVE_DISPLAY.nr));
    @resolutionText = Label(aldoFont,"");
    resolutionText.setScale(0.4);
    element.addChild(@resolutionText);
    element.setChildPosition(@resolutionText,Vector3(-120,0,20));

    @btnPrev = arrowButton("<");
    element.addChild(@btnPrev);
    element.setChildPosition(@btnPrev,Vector3(-150,0,0));
    @btnPrev.onClick = UIEvent(@prev);

    @btnNext = arrowButton(">");
    element.addChild(@btnNext);
    element.setChildPosition(@btnNext,Vector3(150,0,0));
    @btnNext.onClick = UIEvent(@next);

	auto currentMode = ACTIVE_DISPLAY.getCurrentDisplayMode();
	echo ("Current display mode = " + currentMode.toString());

    updateText();
  }

  UIElement@ arrowButton(String direction){

    UIElement@ element = UIElement(Vector3(0,0,0),40,60);
    element.setBackground(Color(163,163,163,255));
    Label@ text = Label(aldoFont,direction);
    text.setScale(0.8);
    element.addChild(@text);
    element.setChildPosition(@text,Vector3(-17.5,0,40));

    return element;
  }

  void next(UIEventInfo event){
    selectedResolution--;
    if(selectedResolution < 0){
      selectedResolution = resolutionCount-1;
    }
    updateText();
  }

  void prev(UIEventInfo event) {
    selectedResolution++;
	if(pUInt(selectedResolution) >= resolutionCount){
      selectedResolution = 0;
    }
    updateText();
  }

  void updateText(){

    resolutionText.text = resolutions[selectedResolution];
    auto mode = ACTIVE_DISPLAY.getDisplayMode(selectedResolution);

    width = mode.width;
    height = mode.height;
  }

  void parseResolutions(){
    resolutionCount = ACTIVE_DISPLAY.getDisplayModeCount();
    for (pUInt j = 0; j < resolutionCount; ++j) {
      auto mode = ACTIVE_DISPLAY.getDisplayMode(j);
      resolutions.add(mode.toString());//String(mode.width)+"X"+String(mode.height));
  	}
  }

}
