
UIElement@ SoundElement(){
  int offset = 95;
  UIElement@ element = UIElement(Vector3(0,1,85),450,250);
  element.setBackground(Color(66,80,88,255));

  Label@ title = Label(aldoFont,"Sound");
  title.setScale(0.8);
  element.addChild(@title);
  element.setChildPosition(@title,Vector3(-110,0,0+offset));

  Label@ backgroundMusicText = Label(aldoFont,"Music");
  Label@ gameSoundText = Label(aldoFont,"Effects");

  bool loadedMusicState;
  if(!GAME_SETTINGS.loadBool("muteMusic",loadedMusicState)){
    loadedMusicState = true;
  }
  toggleMusic(loadedMusicState);
  CheckBox@ muteMusic = CheckBox(loadedMusicState);
  @muteMusic.checkboxEvent = @toggleMusic;

  element.addChild(@muteMusic.element);

  bool loadedEffectsState;
  if(!GAME_SETTINGS.loadBool("muteEffects",loadedEffectsState)){
    loadedEffectsState = true;
  }
  EFFECTS_MUTED = !loadedEffectsState;
  CheckBox@ muteEffects = CheckBox(loadedEffectsState);
  @muteEffects.checkboxEvent = @toggleEffects;

  element.addChild(@muteEffects.element);

  float scale = 0.7;
  backgroundMusicText.setScale(scale);
  gameSoundText.setScale(scale);

  element.addChild(backgroundMusicText);
  element.addChild(gameSoundText);

  int textHorAlign = -130;
  int textSize = -50;
  int textVertAlign = -70;
  element.setChildPosition(@backgroundMusicText,Vector3(40+textHorAlign,0,textVertAlign+(textSize*0)+offset));
  element.setChildPosition(@gameSoundText,Vector3(0+textHorAlign,0,textVertAlign+(textSize*1)+offset));

  int checkBoxHorAlign = 105;
  int checkboxVertAlign = textVertAlign-32;
  element.setChildPosition(@muteMusic.element,Vector3(checkBoxHorAlign,0,offset+(textSize*0)+checkboxVertAlign));
  element.setChildPosition(@muteEffects.element,Vector3(checkBoxHorAlign,0,offset+(textSize*1)+checkboxVertAlign));


  //closebutton
  UIElement@ closeButton = CloseElement();
	element.addChild(@closeButton);
	element.setChildPosition(@closeButton,Vector3(205,0,15+offset));
  closeButton.visible = false;
  //////////////// end close button
  return @element;
}

void toggleMusic(bool state) {
  GAME_SETTINGS.saveValue("muteMusic",state);
  GAME_SETTINGS.save();
  if(state) {
    MusicVolume(100); //can be found in menuInit...
  } else {
    MusicVolume(0);
  }
}

void toggleEffects(bool state) {
  GAME_SETTINGS.saveValue("muteEffects",state);
  GAME_SETTINGS.save();
  EFFECTS_MUTED = !state;
}
