#include "joinServerElement.as";
#include "HostServerElement.as";

UIElement@ joinServerMenu;
UIElement@ hostServerMenu;

UIElement@ PlayElement() {
  int playOffset = 0;
  UIElement@ element = UIElement(Vector3(0,0,50),450,320);

	UIElement@ buttonHost = UIElement(Vector3(0,0,0), 300, 75);
	UIElement@ buttonJoin = UIElement(Vector3(0,0,0), 300, 75);
  element.setBackground(Color(66,80,88,255));
  buttonHost.setBackground(Color(163,163,163,255));
  buttonJoin.setBackground(Color(163,163,163,255));

	Label@ hostGameText = Label(aldoFont, "Host game");
	Label@ joinGameText = Label(aldoFont, "Join game");

	Label@ title = Label(aldoFont,"Play");

  element.addChild(buttonHost);
  element.addChild(buttonJoin);
  element.addChild(title);

  buttonHost.addChild(hostGameText);
  buttonJoin.addChild(joinGameText);

	hostGameText.setScale(0.8);
	joinGameText.setScale(0.8);
	title.setScale(0.8);

	buttonHost.setChildPosition(hostGameText, Vector3(-130, 1, 35));
	buttonJoin.setChildPosition(joinGameText, Vector3(-120, 1, 35));

	element.setChildPosition(buttonJoin, Vector3(0, 0, 0+playOffset));
	element.setChildPosition(buttonHost, Vector3(0, 0, -90+playOffset));
	element.setChildPosition(title, Vector3(-55, 1, 130+playOffset));

  UIElement@ closeButton = CloseElement();
	element.addChild(@closeButton);
	element.setChildPosition(@closeButton,Vector3(205,0,145+playOffset));
  closeButton.visible = false;

	@buttonHost.onClick = @openHostServerMenu;
	@buttonJoin.onClick = @openJoinServerMenu;

  @joinServerMenu = JoinServerElement();
	joinServerMenu.addToScene(INTERFACE_SCENE);
	joinServerMenu.visible = false;

	@hostServerMenu = hostServerElement();
	hostServerMenu.addToScene(INTERFACE_SCENE);
	hostServerMenu.visible = false;

  return @element;
}

void openJoinServerMenu(UIEventInfo event) {
	setMenu(lvl_2, true, joinServerMenu);
}

void openHostServerMenu(UIEventInfo event) {
	setMenu(lvl_2, true, hostServerMenu);
}
