
UIInput@ ipPortHost;
UIInput@ hostPlayerName;
UIInput@ hostPassword;

UIElement@ hostServerElement() {

  UIElement@ element = UIElement(Vector3(0,0,10),640,400);
  @ipPortHost = UIInput(Vector3(-20,2,0),150,50, aldoFont);
  @hostPlayerName = UIInput(Vector3(30,2,60),250,50, aldoFont);
  @hostPassword = UIInput(Vector3(30,2,-60),250,50, aldoFont);

  UIElement@ confirmButton = UIElement(Vector3(0,0,-140),150,75);

  Label@ title = Label(aldoFont,"Host Game");
  Label@ portText = Label(aldoFont,"Port");
  Label@ playerNameText = Label(aldoFont,"Name");
  Label@ passwordText = Label(aldoFont, "Password");
  Label@ okText = Label(aldoFont,"ok");

  Color cGray = Color(163,163,163,255);

  element.setBackground(Color(66,80,88,255));
  confirmButton.setBackground(cGray);
  ipPortHost.setBackground(cGray);
  ipPortHost.Scale = 0.6;
  ipPortHost.maxLength = 5;
  hostPlayerName.setBackground(cGray);
  hostPlayerName.Scale = 0.6;
  hostPlayerName.maxLength = 12;

  hostPassword.setBackground(cGray);
  hostPassword.Scale = 0.6;
  hostPassword.maxLength = 12;


  portText.setScale(0.6);
  playerNameText.setScale(0.6);
  passwordText.setScale(0.6);
  okText.setScale(0.8);

  element.addChild(title);
  element.addChild(ipPortHost);
  element.addChild(hostPlayerName);
  element.addChild(hostPassword);
  element.addChild(passwordText);
  element.addChild(playerNameText);
  element.addChild(portText);
  element.addChild(confirmButton);

  confirmButton.addChild(okText);

  element.setChildPosition(title,Vector3(-150,1,200));
  element.setChildPosition(portText, Vector3(-200,1,30));
  element.setChildPosition(playerNameText, Vector3(-200,1,90));
  element.setChildPosition(passwordText, Vector3(-300, 1, -30));

  confirmButton.setChildPosition(okText,Vector3(-25,1,35));

  UIElement@ closeButton = CloseElement();
	element.addChild(@closeButton);
	element.setChildPosition(@closeButton,Vector3(305,1,185));

  //element.setChildPosition(ipAddress, Vector3(80,0,40));
  uint loadedPort;
  if(GAME_SETTINGS.loadUint("port",loadedPort)){
    port = loadedPort;
  }

  String loadedUsername;
  if(GAME_SETTINGS.loadString("username",loadedUsername)){
    userName = loadedUsername;
  }
  ipPortHost.value = String(port);
  hostPlayerName.value = userName;

  @confirmButton.onClick = @setHostData;
  return @element;
}

void setHostData(UIEventInfo info) {
  port = ipPortHost.value.toUint();
  gPlayerName = hostPlayerName.value;
  server_password = hostPassword.value;

  GAME_SETTINGS.saveValue("port", port);
  GAME_SETTINGS.saveValue("username", gPlayerName);
  GAME_SETTINGS.save();

  hostGame();
  closeWholeMenu();
}
