#include "MenuElement.as";

UIInput@ ipAddress;
UIInput@ ipPort;
UIInput@ joinPlayerName;
UIInput@ joinPlayerPassword;


UIElement@ JoinServerElement() {


  UIElement@ element;
  @element = UIElement(Vector3(0,0,10),640,480);
  @ipAddress = UIInput(Vector3(80,1,80),350,50, aldoFont);
  @ipPort = UIInput(Vector3(-20,1,20),150,50, aldoFont);
  @joinPlayerPassword = UIInput(Vector3(30,1,-40),250,50,aldoFont);
  @joinPlayerName = UIInput(Vector3(30,1,-100),250,50,aldoFont);

  UIElement@ confirmButton = UIElement(Vector3(0,0,-170),150,75);

  Label@ title = Label(aldoFont,"Join Game");
  Label@ hostText = Label(aldoFont,"Host ip");
  Label@ portText = Label(aldoFont,"Port");
  Label@ playerNameText = Label(aldoFont,"Name");
  Label@ passwordText = Label(aldoFont,"Password");
  Label@ okText = Label(aldoFont,"ok");

  Color bgGrey = Color(163,163,163,255);
  element.setBackground(Color(66,80,88,255));
  confirmButton.setBackground(bgGrey);
  ipAddress.setBackground(bgGrey);
  ipAddress.Scale = 0.6;
  ipAddress.maxLength = 18;
  ipPort.setBackground(bgGrey);
  ipPort.Scale = 0.6;
  ipPort.maxLength = 5;

  joinPlayerName.setBackground(bgGrey);
  joinPlayerName.Scale = 0.6;
  joinPlayerName.maxLength = 12;

  joinPlayerPassword.setBackground(bgGrey);
  joinPlayerPassword.Scale = 0.6;
  joinPlayerPassword.maxLength = 12;

  hostText.setScale(0.6);
  portText.setScale(0.6);
  playerNameText.setScale(0.6);
  passwordText.setScale(0.6);
  okText.setScale(0.8);

  element.addChild(@title);
  element.addChild(@ipAddress);
  element.addChild(@hostText);
  element.addChild(@ipPort);
  element.addChild(@portText);
  element.addChild(@joinPlayerName);
  element.addChild(@playerNameText);
  element.addChild(@joinPlayerPassword);
  element.addChild(@passwordText);

  element.addChild(@confirmButton);

  confirmButton.addChild(@okText);

  element.setChildPosition(@title,Vector3(-150,1,220));
  element.setChildPosition(@hostText, Vector3(-250,1,100));
  element.setChildPosition(@portText, Vector3(-200,1,50));
  element.setChildPosition(@passwordText, Vector3(-300,1,-10));
  element.setChildPosition(@playerNameText, Vector3(-200,1,-70));


  confirmButton.setChildPosition(@okText,Vector3(-25,1,35));
  UIElement@ closeButton = CloseElement();
	element.addChild(@closeButton);
  element.setChildPosition(@closeButton,Vector3(300,0,225));
  //element.setChildPosition(ipAddress, Vector3(80,0,40));

  String loadedIP;
  if(GAME_SETTINGS.loadString("ip",loadedIP)){
    ip = loadedIP;
  }
  uint loadedPort;
  if(GAME_SETTINGS.loadUint("port",loadedPort)){
    port = loadedPort;
  }
  String loadedUsername;
  if(GAME_SETTINGS.loadString("username",loadedUsername)){
    userName = loadedUsername;
  }

  ipAddress.value = ip;
  ipPort.value = String(port);
  joinPlayerName.value = userName;

  @confirmButton.onClick = @setServerData;
  return @element;
}

void setServerData(UIEventInfo info) {
	ip = ipAddress.value;
	port = ipPort.value.toUint();
  userName = joinPlayerName.value;
	server_password = joinPlayerPassword.value;

  GAME_SETTINGS.saveValue("ip",ip);
  GAME_SETTINGS.saveValue("port",port);
  GAME_SETTINGS.saveValue("username",userName);
  GAME_SETTINGS.save();
	gPlayerName = joinPlayerName.value;

	clientJoin();
}
