#include "PlayElement.as";
#include "CloseElement.as";
#include "CheckBox.as";
#include "gameMenuElement.as";
#include "CreditsElement.as";
#include "Options/OptionElement.as";


enum MenuState {
	MS_MainMenu,
	MS_Lobby,
	MS_GameMenu,
}

BitmapFont@ aldoFont;
UIElement@ mainMenu;
UIElement@ playMenu;
UIElement@ OptionMenu;
UIElement@ GameMenu;
UIElement@ creditsMenu;

OpenALDevice@ alDev = OpenALDevice();
OpenALContext@ AL_CONTEXT;
OpenALSource@ BG_SOURCE;
Sound@ BG_MUSIC;

OpenALSource@ MENU_SOURCE;
Sound@ MENU_MUSIC;

MenuState mState = MS_MainMenu;

bool isReturnToTitle = false;

Array<UIElement@> activeMenus;
enum menuLevel {lvl_null = -1, lvl_0 = 0, lvl_1 = 1, lvl_2 = 2, lvl_3 = 3};
int currentMenuLevel = lvl_null;
String ip = "127.0.0.1";
String server_password = "";
uint port = 1337;
String userName = "Player";
bool isEscOverride = false;

Timer@ MenuTimeout;

Panel@ WrackyPanel;
Label@ ConnectionStatusLabel;



void FocusChanged(Window@ window, bool gotFocus)
{
	if (mState == MS_GameMenu && !mainMenu.visible ) { movementController.active = gotFocus; }
}

void MusicVolume(int volume){
	MENU_SOURCE.volume = volume;
	BG_SOURCE.volume = volume;
}

void menu_init() {


	@AL_CONTEXT = alDev.createContext(MAIN_SCENE);

	@MENU_MUSIC = pool.getSound("../../Assets/Sounds/Music/Dascon_Game_Menu.ogg");
	@MENU_SOURCE = AL_CONTEXT.createSource();
	MENU_SOURCE.loop = true;

	@BG_MUSIC = pool.getSound("../../Assets/Sounds/Music/Dascon-Shootgelderpressung.ogg");
	@BG_SOURCE = AL_CONTEXT.createSource();
	BG_SOURCE.loop = true;

	//ConnectionStatusLabel.hAlign = GHA_CENTER;
	int menuOfsset = 85;
	@mainMenu = UIElement(Vector3(0,-5,0), 450, 500);
	@aldoFont = pool.getBitmapFont("../../Assets/Fonts/AldoTheApache.fnt");

	@WrackyPanel = Panel(500, 400);
	WrackyPanel.translate(-250, -10, 250);

	//INTERFACE_SCENE.add(WrackyPanel);

	@ConnectionStatusLabel = Label(aldoFont,"Press ESC to start!");
	ConnectionStatusLabel.setScale(0.5);
	ConnectionStatusLabel.model.visible = true;
	ConnectionStatusLabel.hAlign = GHA_CENTER;
	ConnectionStatusLabel.vAlign = GVA_BOTTOM;
	WrackyPanel.addChild(ConnectionStatusLabel);
	INTERFACE_SCENE.add(ConnectionStatusLabel);

	MENU_SOURCE.play(MENU_MUSIC);


	UIElement@ buttonQuit = UIElement(Vector3(0,0,0), 300, 75);
	UIElement@ buttonPlay = UIElement(Vector3(0,0,0), 300, 75);
	UIElement@ buttonOptions = UIElement(Vector3(0,0,0), 300, 75);
	UIElement@ buttonCredits = UIElement(Vector3(0,0,0), 300, 75);

	mainMenu.setBackground(Color(66,80,88,255));
	buttonQuit.setBackground(Color(163,163,163,255));
	buttonPlay.setBackground(Color(163,163,163,255));
	buttonOptions.setBackground(Color(163,163,163,255));
	buttonCredits.setBackground(Color(163,163,163,255));

	Label@ buttonQuitText = Label(aldoFont,"Quit");
	Label@ menuTitleText = Label(aldoFont,"Menu");
	Label@ playText = Label(aldoFont, "Play");
	Label@ optionsText = Label(aldoFont, "Options");
	Label@ creditsText = Label(aldoFont, "Credits");

	buttonQuitText.setScale(0.8);
	menuTitleText.setScale(0.8);
	playText.setScale(0.8);
	optionsText.setScale(0.8);
	creditsText.setScale(0.8);

	@buttonQuit.onClick = @quit;
	@buttonPlay.onClick = @openPlayMenu;
	@buttonOptions.onClick = @openOptionMenu;
	@buttonCredits.onClick = @openButtonCredits;
	//@buttonOptions.onClick = @openJoinServerMenu;

	mainMenu.addChild(buttonQuit);
	mainMenu.addChild(buttonPlay);
	mainMenu.addChild(buttonOptions);
	mainMenu.addChild(menuTitleText);
	mainMenu.addChild(buttonCredits);
	buttonQuit.addChild(buttonQuitText);
	buttonPlay.addChild(playText);
	buttonOptions.addChild(optionsText);
	buttonCredits.addChild(creditsText);

	buttonQuit.setChildPosition(buttonQuitText, Vector3(-50, 1, 35));
	buttonPlay.setChildPosition(playText, Vector3(-55, 1, 35));
	buttonOptions.setChildPosition(optionsText, Vector3(-100, 1, 35));
	buttonCredits.setChildPosition(creditsText, Vector3(-90, 1, 35));

	mainMenu.setChildPosition(buttonPlay, Vector3(0, 0, 0+menuOfsset));
	mainMenu.setChildPosition(buttonOptions, Vector3(0, 0, -90+menuOfsset));
	mainMenu.setChildPosition(buttonCredits, Vector3(0, 0, -180+menuOfsset));
	mainMenu.setChildPosition(buttonQuit, Vector3(0, 0, -270+menuOfsset));


	mainMenu.setChildPosition(menuTitleText, Vector3(-55, 2, 130+menuOfsset));

	UIElement@ closeButton = CloseElement();
	mainMenu.addChild(@closeButton);
	mainMenu.setChildPosition(@closeButton,Vector3(205,0,145+menuOfsset));
	//closeButton.visible = false;

	mainMenu.addToScene(INTERFACE_SCENE);

	mainMenu.visible = false;

	activeMenus.insertAt(0,@mainMenu);
	activeMenus.insertAt(1,null);
	activeMenus.insertAt(2,null);
	activeMenus.insertAt(3,null);
	@playMenu = PlayElement();
	playMenu.addToScene(INTERFACE_SCENE);
	playMenu.visible = false;

	@OptionMenu = OptionElement();
	OptionMenu.addToScene(INTERFACE_SCENE);
	OptionMenu.visible = false;


	@GameMenu = gameMenuElement(@backForGame);
	GameMenu.addToScene(INTERFACE_SCENE);
	GameMenu.visible = false;

	@creditsMenu = CreditsElement();
	creditsMenu.addToScene(INTERFACE_SCENE);
	creditsMenu.visible = false;


	MAIN_WINDOW.Input.windowFocusChanged() += @FocusChanged;
	CONTROL.Input.key(PK_ESCAPE) += handleToggleMenu;

	mState = MS_MainMenu;

	//@ani = Animate(myElement, EL_X, 0, 200, 90, MAIN_TIMER, @EASE_ELASTIC_IN);
}


// Menu actions

void openPlayMenu(UIEventInfo event) {
	setMenu(lvl_1, true, playMenu);
}

void openOptionMenu(UIEventInfo event) {
	setMenu(lvl_1, true, OptionMenu);
}

void openButtonCredits(UIEventInfo event) {
	setMenu(lvl_1,true, creditsMenu);
}
void handleToggleMenu(pKeyCode, pByte)
{
	if(!isEscOverride)
	toggleMenu();
}


void toggleMenu(){

	if(isReturnToTitle) {
		isReturnToTitle = false;
		BackToTitle();
	}
	if (mState == MS_GameMenu) 	{
		@activeMenus[lvl_0] = GameMenu;
	} else if(mState == MS_MainMenu) {
		@activeMenus[lvl_0] = mainMenu;
	}


	if(currentMenuLevel == lvl_null){
		setMenu(lvl_0,true);
		if(mState == MS_GameMenu) disableController();
	} else {
		setMenu(currentMenuLevel, false);
		if(currentMenuLevel == lvl_null)
		if(mState == MS_GameMenu) enableController();
	}
	echo("currentLevel"+ String(currentMenuLevel));
}

void enableController() {
	if (movementController !is null)
			movementController.active = true;
	if (actionController !is null)
		actionController.active = true;
}

void disableController() {
	if (movementController !is null)
			movementController.active = false;
	if (actionController !is null)
		actionController.active = false;
		
	MAIN_WINDOW.GrabInput = false;
}




void closeWholeMenu(){
	for(int menuCounter = 0, menuLength = activeMenus.length; menuCounter < menuLength; menuCounter++){
		if(@activeMenus[menuCounter] != null){
			activeMenus[menuCounter].visible = false;
		}

	}
	currentMenuLevel = lvl_null;
	MENU_SOURCE.stop();
}



void setMenu(int level, bool menuState, UIElement@ levelElement = null)
{
	//calculate parent level, should be minus current level
	int parentLevel = level -1;
	ConnectionStatusLabel.model.visible = false;

	if(@levelElement != null){
		@activeMenus[level] = @levelElement;
	}

	if(@activeMenus[level] != null){
		if(parentLevel >= 0){
			activeMenus[parentLevel].visible = !menuState;
		}
		activeMenus[level].visible = menuState;
	}

	if(menuState){
		currentMenuLevel = level;
	} else {
		currentMenuLevel = parentLevel;
	}
}

void hostGame()
{
	@gHost = Host();
	//If we allow more than 8 players, the server list
	gHost.mFragLimit = 10;
	gHost.StartServer(port, 8, server_password);

	clientJoin();
}

void StartGameBtnClicked(UIEventInfo info) {
	gHost.startGame();
}

void BackBtnClicked(UIEventInfo info) {
	backForGame();
}

void backForGame() {
	isReturnToTitle = true;
	toggleMenu();
	toggleMenu();
	disableController();
}

void BackToTitle(){
	HideLobby();
	LeaveGame();
	disableController();
	//disableController();
	//toggleMenu();
}


void ClientConnectionCB(pConnectionState res)
{
	switch (res)
	{
		case CS_CONNECTED:
		{
			mState = MS_Lobby;

			ConnectionStatusLabel.model.visible = false;
			ConnectionStatusLabel.text = "";
			LobbyInit(StartGameBtnClicked, BackBtnClicked, gHost !is null);

			if (BG_MUSIC !is null) {
				BG_SOURCE.play(BG_MUSIC);
			} else {
				echo ("No BG sound...");
			}
			break;
		}
		case CS_FAILED:
		{
			echo ("Connection failed!");
			ConnectionStatusLabel.text = "Connection failed! (Press esc to return to menu)";
			ConnectionStatusLabel.model.visible = true;
			isReturnToTitle = true;
			break;
		}
		case CS_INVALIDPASSWORD:
		{
			echo ("Invalid Password");
			ConnectionStatusLabel.text = "Invalid Server Password! (Press esc to return to menu)";
			isReturnToTitle = true;
			break;
		}

		case CS_CONNECTIONREFUSED:
		{
			echo ("Connection refused");
			ConnectionStatusLabel.text = "Connection refused! Server full ? (Press esc to return to menu)";
			isReturnToTitle = true;
			break;
		}
		case CS_CLIENTLOST:
		{
			echo ("Connection to server lost");
			ConnectionStatusLabel.text = "Connection lost! (Press esc to return to menu)";
			mState = MS_MainMenu;
			isReturnToTitle = true;
			break;
		}

		default:
			echo ("Unknown connection result: " + String(res));
	}
}

void GameStateChangeCB(GameState state)
{
	switch (state)
	{
		case GS_Started: {
			if (mState == MS_Lobby) {
				mState = MS_GameMenu;
				HideLobby();
				enableController();
				gClient.startPlayerSync();

				OverlayInit();
			}
			break;
		}
		case GS_Ended: {
			mState = MS_Lobby;
			closeWholeMenu();
			ShowLobby();
			disableController();
		}
	}
}



void clientJoin() {

	ConnectionStatusLabel.text = "Loading ..."; //THis doesn't realy do anything since everything is sync right now.
	closeWholeMenu();
	gameStart();

	@gClient = Client(ClientConnectionCB, GameStateChangeCB);
	ConnectionStatusLabel.text = "Connecting ...";
	String clientIp = ip;
	if(@gHost != null){
		clientIp = "127.0.0.1";
	}
	gClient.Connect(clientIp, port, server_password);

	//setup client.
	@mainPlayer.client = gClient;
	gClient.setPlayer(mainPlayer);
	@gClient.cube = cube;
}

void LeaveGame()
{
	if (gHost !is null) {
		gHost.shutDown();
		@gHost = null;
	}

	gClient.shutDown();
	gameEnd();
	BG_SOURCE.stop();
	MENU_SOURCE.play(MENU_MUSIC);

	mState = MS_MainMenu;
	cleanupOverlay();

	//toggleMenu();
}


void quit(UIEventInfo info) {
	//info.element.setBackground(Color(0,255,0,255));
	CONTROL.quit();
}
