//game specific stuff
#include "InteractableEntity/InteractableEntity.as";
#include "player/player.as"
#include "player/CharacterController.as";
#include "../interface/UIElement.as";
#include "../interface/UIInput.as";
#include "../interface/Animate.as";
#include "GravityManager.as";
#include "Level.as";
#include "../network/host.as";
#include "../network/client.as";
#include "world/JumpPad.as";
#include "Menu/menuInit.as";
#include "IngameOverlay/OverlayInit.as"


// gobalSettings
String gPlayerName;
int mouseUp = 1;

InputControlPair@ ICPForwardUp;
InputControlPair@ ICPBackwardUp;
InputControlPair@ ICPLeftUp;
InputControlPair@ ICPRightUp;

InputControlPair@ ICPForwardDown;
InputControlPair@ ICPBackwardDown;
InputControlPair@ ICPLeftDown;
InputControlPair@ ICPRightDown;

InputControlPair@ ICPJump;
InputControlPair@ ICProuch;
////////////////

Player@ mainPlayer;

Object@ cube;

InputController@ interfaceController;
InputController@ movementController;
InputController@ actionController;

PointLight@ mainTestLight;
PointLight@ mainTestLight2;


IERegistery@ reg;

Animate@ ani;
Object@ testObj;


Host@ gHost;
Client@ gClient;
Timer@ PROJECTILE_TIMER;


Level@ LEVEL;
Splash@ splash;
Object@ crosshair;
Array<Object@> ARR_GIBS;
Array<String> ARR_GIBS_STRING;
//game main


JumpPad@ jump;


void game_init(){





	ARR_GIBS_STRING.add("../../Assets/3D/gibs/gib_foot_l.fbx");
	ARR_GIBS_STRING.add("../../Assets/3D/gibs/gib_head.fbx");
	ARR_GIBS_STRING.add("../../Assets/3D/gibs/gib_foot_r.fbx");
	ARR_GIBS_STRING.add("../../Assets/3D/gibs/gib_01.fbx");
	ARR_GIBS_STRING.add("../../Assets/3D/gibs/gib_02.fbx");
	ARR_GIBS_STRING.add("../../Assets/3D/gibs/gib_03.fbx");
	ARR_GIBS_STRING.add("../../Assets/3D/gibs/gib_04.fbx");

	for (uint i = 0; i<  ARR_GIBS_STRING.length(); i++) {
		ARR_GIBS.add(objectFactory.load(ARR_GIBS_STRING[i]));
	}


	@PROJECTILE_TIMER = CONTROL.createTimer(100, true);
	PROJECTILE_TIMER.start();

	@reg = IERegistery();



	@splash = Splash();
	@ICPLeftDown = InputControlPair(PK_a, PA_moveLeft, false, T_DOWN);
	@ICPRightDown = InputControlPair(PK_d, PA_moveRight, false, T_DOWN);
	@ICPForwardDown = InputControlPair(PK_w, PA_moveForward, false, T_DOWN);
	@ICPBackwardDown = InputControlPair(PK_s, PA_moveBackward, false, T_DOWN);
	@ICPLeftUp = InputControlPair(PK_a, PA_moveLeft, false, T_UP);
	@ICPRightUp = InputControlPair(PK_d, PA_moveRight, false, T_UP);
	@ICPForwardUp = InputControlPair(PK_w, PA_moveForward, false, T_UP);
	@ICPBackwardUp = InputControlPair(PK_s, PA_moveBackward, false, T_UP);
	@ICPJump = InputControlPair(PK_SPACE, PA_jump, false);



}

void gameStart() {
	splash.remove();



	@LEVEL = Level("../../Assets/3D/dm1.fbx", "../../Assets/3D/skybox_cubemap.fbx");

	@mainPlayer = Player(MAIN_SCENE, @MAIN_TIMER ,@MAIN_CAM);

	@movementController = InputController(@mainPlayer.controller, @MAIN_TIMER, MAIN_WINDOW);
	movementController.active = false;

	movementController.pairs.add(@ICPLeftDown);
	movementController.pairs.add(@ICPRightDown);
	movementController.pairs.add(@ICPForwardDown);
	movementController.pairs.add(@ICPBackwardDown);
	movementController.pairs.add(@ICPLeftUp);
	movementController.pairs.add(@ICPRightUp);
	movementController.pairs.add(@ICPForwardUp);
	movementController.pairs.add(@ICPBackwardUp);

	movementController.pairs.add(ICPJump);
	movementController.setMouseControl(PA_cursorX,PA_cursorY, MAIN_WINDOW);


	@actionController = InputController(@mainPlayer, @MAIN_TIMER, MAIN_WINDOW);
	actionController.pairs.add(InputControlPair(PM_LEFT, PA_fireWeapon,false));
	actionController.pairs.add(InputControlPair(PM_RIGHT, PA_fireWeapon2, false, T_UP));
	//actionController.active = true;

	//CONTROL.Input.key(PK_g) += genGibs;
}

void gameEnd()
{
	//BG_SOURCE.stop();
	LEVEL.unload();
	@LEVEL = null;
	@mainPlayer = null;
	@movementController = null;
	@actionController = null;

	CONTROL.script.CollectGarbage();
	@splash = Splash();

	MAIN_CAM.xForm = Transform();

}

class Splash {
	Object@ sb;
	Object@ logo;
	Splash() {
		@sb = objectFactory.load("../../Assets/3D/skybox_cubemap.fbx");
		sb.setPosition(Vector3(0,0,0));
		sb.model.setDrawMode(DM_EMISSIVE);
		sb.rotate(Vector3(0,1,0), PI*0.08);
		sb.rotate(Vector3(0,0,1), PI*0.28);

		SKYBOX_SCENE.add(sb);

		@logo = objectFactory.load("../../Assets/3D/logo.fbx");
		logo.setPosition(Vector3(0,0.5,0));
		logo.model.setDrawMode(DM_EMISSIVE);
		SKYBOX_SCENE.add(logo);
	}

	void remove() {
		SKYBOX_SCENE.remove(logo);
		SKYBOX_SCENE.remove(sb);
	}
}
void genGibs(pKeyCode, pByte) {
	for (int i = 0; i < 15; i++) {
		Gib(LEVEL.spawnLocations[0]+Vector3(1,0,0), Vector3(-10,0,0), objectFactory.load(ARR_GIBS_STRING[RANDOM.get(3,6)]), randRange(1,2));
	}
}
class Gib : iRefObj{
	int lifetime;// = rand() % (max + 1 - min) + min;
	int counter = 0;
	float gibScale = 0.2;
	Object@ obj;
	bool scaleGib;
	Gib() {

	}

	Gib(Vector3 p, Vector3 g, Object@ o, float s = 1, int lmin = 500, int lmax = 800, float impulseMult = 0.2, bool useOffset = true,bool sb = false) {
		lifetime = rand() % (lmax + 1 - lmin) + lmin;
		@obj = o;
		obj.setScale(s);
		@obj.proxy = MAIN_SCENE.world.createProxy(PT_DYNAMIC);
		scaleGib = sb;
		obj.proxy.addBox(gibScale*s,gibScale*s,gibScale*s,1);
		obj.proxy.gravity = g;
		obj.position = (useOffset) ? p-g.normalized() : p;
		MAIN_TIMER.elapsed += Action(this.remCheck);
		MAIN_SCENE.add(obj);
		@obj.userRef = this;
		Vector3 v = Vector3(randRange(-1,1), randRange(-1,1), randRange(-1,1)).normalized();
		//echo(v.toString());
		obj.proxy.applyImpulse(v*impulseMult, Vector3(0,0,0));
	}

	void remCheck() {
		if (scaleGib) {
			obj.scale(0.9);
		}
		if (counter++ > lifetime) {
			MAIN_TIMER.elapsed -= Action(this.remCheck);
			MAIN_SCENE.remove(obj);
			@obj.userRef = null;
		}
	}
}

float randRange(float min, float max) {
	min = min*100;
	max = max*100;
	return float(min + rand() % (max - min + 1))/100;
}
